/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.nodetype;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.MalformedInputException;
import java.nio.charset.UnmappableCharacterException;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.services.jcr.core.nodetype.NodeDefinitionData;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeData;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataManager;
import org.exoplatform.services.jcr.core.nodetype.PropertyDefinitionData;
import org.exoplatform.services.jcr.core.nodetype.PropertyDefinitionDatas;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeDefinitionImpl;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeDefinitionImpl;
import org.exoplatform.services.jcr.impl.core.nodetype.PropertyDefinitionImpl;
import org.exoplatform.services.jcr.impl.core.value.BaseValue;
import org.exoplatform.services.jcr.impl.core.value.ValueConstraintsMatcher;
import org.exoplatform.services.jcr.impl.util.JCRDateFormat;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class NodeTypeImpl
extends NodeTypeDefinitionImpl
implements NodeType {
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.NodeTypeImpl");

    public NodeTypeImpl(NodeTypeData nodeTypeData, NodeTypeDataManager nodeTypeDataManager, ExtendedNodeTypeManager nodeTypeManager, LocationFactory locationFactory, ValueFactory valueFactory, ItemDataConsumer dataManager) {
        super(nodeTypeData, nodeTypeDataManager, nodeTypeManager, locationFactory, valueFactory, dataManager);
    }

    public boolean canAddChildNode(String childNodeName) {
        try {
            InternalQName cname = this.locationFactory.parseJCRName(childNodeName).getInternalName();
            NodeDefinitionData childNodeDef = this.nodeTypeDataManager.getChildNodeDefinition(cname, this.nodeTypeData.getName());
            return childNodeDef != null && !childNodeDef.isProtected() && childNodeDef.getDefaultPrimaryType() != null;
        }
        catch (RepositoryException e) {
            LOG.error((Object)("canAddChildNode " + (Object)((Object)e)), (Throwable)e);
            return false;
        }
    }

    public boolean canAddChildNode(String childNodeName, String nodeTypeName) {
        try {
            InternalQName cname = this.locationFactory.parseJCRName(childNodeName).getInternalName();
            InternalQName ntname = this.locationFactory.parseJCRName(nodeTypeName).getInternalName();
            NodeDefinitionData childNodeDef = this.nodeTypeDataManager.getChildNodeDefinition(cname, ntname, this.nodeTypeData.getName());
            return childNodeDef != null && !childNodeDef.isProtected() && this.isChildNodePrimaryTypeAllowed(nodeTypeName);
        }
        catch (RepositoryException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("canAddChildNode " + (Object)((Object)e)), (Throwable)e);
            }
            return false;
        }
    }

    public boolean canRemoveItem(String itemName) {
        try {
            PropertyDefinitionData pd;
            InternalQName iname = this.locationFactory.parseJCRName(itemName).getInternalName();
            PropertyDefinitionDatas pdefs = this.nodeTypeDataManager.getPropertyDefinitions(iname, this.nodeTypeData.getName());
            if (pdefs != null && (pd = pdefs.getAnyDefinition()) != null) {
                return !pd.isMandatory() && !pd.isProtected();
            }
            NodeDefinitionData cndef = this.nodeTypeDataManager.getChildNodeDefinition(iname, this.nodeTypeData.getName());
            if (cndef != null) {
                return !cndef.isMandatory() && !cndef.isProtected();
            }
            return false;
        }
        catch (RepositoryException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("canRemoveItem " + (Object)((Object)e)), (Throwable)e);
            }
            return false;
        }
    }

    public boolean canSetProperty(String propertyName, Value value) {
        try {
            PropertyDefinitionData pd;
            InternalQName pname = this.locationFactory.parseJCRName(propertyName).getInternalName();
            PropertyDefinitionDatas pdefs = this.nodeTypeDataManager.getPropertyDefinitions(pname, this.nodeTypeData.getName());
            if (pdefs != null && (pd = pdefs.getDefinition(false)) != null) {
                if (pd.isProtected()) {
                    return false;
                }
                if (value != null) {
                    return this.canSetPropertyForType(pd.getRequiredType(), value, pd.getValueConstraints());
                }
                return !pd.isMandatory();
            }
            return false;
        }
        catch (RepositoryException e) {
            LOG.error((Object)("canSetProperty value " + (Object)((Object)e)), (Throwable)e);
            return false;
        }
    }

    public boolean canSetProperty(String propertyName, Value[] values) {
        try {
            InternalQName pname = this.locationFactory.parseJCRName(propertyName).getInternalName();
            PropertyDefinitionDatas pdefs = this.nodeTypeDataManager.getPropertyDefinitions(pname, this.nodeTypeData.getName());
            PropertyDefinitionData pd = pdefs.getDefinition(true);
            if (pd != null) {
                if (pd.isProtected()) {
                    return false;
                }
                if (values != null) {
                    int res = 0;
                    for (Value value : values) {
                        if (!this.canSetPropertyForType(pd.getRequiredType(), value, pd.getValueConstraints())) continue;
                        ++res;
                    }
                    return res == values.length;
                }
                return !pd.isMandatory();
            }
            return false;
        }
        catch (RepositoryException e) {
            LOG.error((Object)("canSetProperty value " + (Object)((Object)e)), (Throwable)e);
            return false;
        }
    }

    public NodeDefinition[] getChildNodeDefinitions() {
        NodeDefinitionData[] nodeDefs = this.nodeTypeDataManager.getAllChildNodeDefinitions(this.nodeTypeData.getName());
        NodeDefinition[] ndefs = new NodeDefinition[nodeDefs.length];
        for (int i = 0; i < nodeDefs.length; ++i) {
            NodeDefinitionData cnd = nodeDefs[i];
            ndefs[i] = new NodeDefinitionImpl(cnd, this.nodeTypeDataManager, this.nodeTypeManager, this.locationFactory, this.valueFactory, this.dataManager);
        }
        return ndefs;
    }

    public NodeDefinition[] getDeclaredChildNodeDefinitions() {
        NodeDefinitionData[] cndefs = this.nodeTypeData.getDeclaredChildNodeDefinitions();
        NodeDefinition[] ndefs = new NodeDefinition[cndefs.length];
        for (int i = 0; i < cndefs.length; ++i) {
            NodeDefinitionData cnd = cndefs[i];
            ndefs[i] = new NodeDefinitionImpl(cnd, this.nodeTypeDataManager, this.nodeTypeManager, this.locationFactory, this.valueFactory, this.dataManager);
        }
        return ndefs;
    }

    public PropertyDefinition[] getDeclaredPropertyDefinitions() {
        PropertyDefinitionData[] pdefs = this.nodeTypeData.getDeclaredPropertyDefinitions();
        return this.getPropertyDefinition(pdefs);
    }

    public NodeType[] getDeclaredSupertypes() {
        InternalQName[] snames = this.nodeTypeData.getDeclaredSupertypeNames();
        NodeType[] supers = new NodeType[snames.length];
        for (int i = 0; i < snames.length; ++i) {
            NodeTypeData superNodeTypeData = this.nodeTypeDataManager.getNodeType(snames[i]);
            supers[i] = new NodeTypeImpl(superNodeTypeData, this.nodeTypeDataManager, this.nodeTypeManager, this.locationFactory, this.valueFactory, this.dataManager);
        }
        return supers;
    }

    public String getName() {
        try {
            return this.locationFactory.createJCRName(this.nodeTypeData.getName()).getAsString();
        }
        catch (RepositoryException e) {
            throw new RuntimeException("Wrong name in nodeTypeData " + (Object)((Object)e), e);
        }
    }

    public String getPrimaryItemName() {
        try {
            if (this.nodeTypeData.getPrimaryItemName() != null) {
                return this.locationFactory.createJCRName(this.nodeTypeData.getPrimaryItemName()).getAsString();
            }
            return null;
        }
        catch (RepositoryException e) {
            throw new RuntimeException("Wrong primary item name in nodeTypeData " + (Object)((Object)e), e);
        }
    }

    public PropertyDefinition[] getPropertyDefinitions() {
        PropertyDefinitionData[] propertyDefs = this.nodeTypeDataManager.getAllPropertyDefinitions(this.nodeTypeData.getName());
        return this.getPropertyDefinition(propertyDefs);
    }

    public InternalQName getQName() {
        return this.nodeTypeData.getName();
    }

    public NodeType[] getSupertypes() {
        Set<InternalQName> supers = this.nodeTypeDataManager.getSupertypes(this.nodeTypeData.getName());
        NodeType[] superTypes = new NodeType[supers.size()];
        int i = 0;
        for (InternalQName nodeTypeName : supers) {
            try {
                superTypes[i++] = this.nodeTypeManager.findNodeType(nodeTypeName);
            }
            catch (NoSuchNodeTypeException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            catch (RepositoryException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return superTypes;
    }

    public boolean hasOrderableChildNodes() {
        return this.nodeTypeData.hasOrderableChildNodes();
    }

    public boolean isChildNodePrimaryTypeAllowed(String typeName) {
        try {
            InternalQName iname = this.locationFactory.parseJCRName(typeName).getInternalName();
            return this.nodeTypeDataManager.isChildNodePrimaryTypeAllowed(iname, this.nodeTypeData.getName(), new InternalQName[0]);
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    public boolean isMixin() {
        return this.nodeTypeData.isMixin();
    }

    public boolean isNodeType(InternalQName nodeTypeQName) {
        return this.nodeTypeDataManager.isNodeType(nodeTypeQName, this.nodeTypeData.getName(), new InternalQName[0]);
    }

    public boolean isNodeType(String nodeTypeName) {
        try {
            return this.nodeTypeDataManager.isNodeType(this.locationFactory.parseJCRName(nodeTypeName).getInternalName(), this.nodeTypeData.getName());
        }
        catch (RepositoryException e) {
            throw new RuntimeException("Wrong nodetype name " + (Object)((Object)e), e);
        }
    }

    /*
     * Loose catch block
     */
    private boolean canSetPropertyForType(int requiredType, Value value, String[] constraints) {
        if (requiredType == value.getType()) {
            return this.checkValueConstraints(requiredType, constraints, value);
        }
        if (requiredType == 2 && (value.getType() == 1 || value.getType() == 5 || value.getType() == 3 || value.getType() == 4 || value.getType() == 7 || value.getType() == 8 || value.getType() == 6)) {
            return this.checkValueConstraints(requiredType, constraints, value);
        }
        if (requiredType == 6) {
            if (value.getType() == 1) {
                return this.checkValueConstraints(requiredType, constraints, value);
            }
            if (value.getType() == 2) {
                try {
                    return this.isCharsetString(value.getString(), "UTF-8") && this.checkValueConstraints(requiredType, constraints, value);
                }
                catch (Exception e) {
                    return false;
                }
            }
            return false;
        }
        if (requiredType == 5) {
            String likeDataString = null;
            try {
                if (value.getType() == 1) {
                    likeDataString = value.getString();
                } else if (value.getType() == 2) {
                    likeDataString = this.getCharsetString(value.getString(), "UTF-8");
                } else {
                    if (value.getType() == 4 || value.getType() == 3) {
                        return this.checkValueConstraints(requiredType, constraints, value);
                    }
                    return false;
                }
                JCRDateFormat.parse(likeDataString);
                return this.checkValueConstraints(requiredType, constraints, value);
            }
            catch (Exception e) {
                return false;
            }
        }
        if (requiredType == 4) {
            String likeDoubleString = null;
            try {
                if (value.getType() == 1) {
                    likeDoubleString = value.getString();
                } else if (value.getType() == 2) {
                    likeDoubleString = this.getCharsetString(value.getString(), "UTF-8");
                } else {
                    if (value.getType() == 5) {
                        return true;
                    }
                    if (value.getType() == 3) {
                        return this.checkValueConstraints(requiredType, constraints, value);
                    }
                    return false;
                }
                Double doubleValue = new Double(likeDoubleString);
                return doubleValue != null && this.checkValueConstraints(requiredType, constraints, value);
            }
            catch (Exception e) {
                return false;
            }
        }
        if (requiredType == 3) {
            String likeLongString = null;
            try {
                if (value.getType() == 1) {
                    likeLongString = value.getString();
                } else if (value.getType() == 2) {
                    likeLongString = this.getCharsetString(value.getString(), "UTF-8");
                } else {
                    if (value.getType() == 5) {
                        return true;
                    }
                    return value.getType() == 4;
                }
                Long longValue = new Long(likeLongString);
                return longValue != null && this.checkValueConstraints(requiredType, constraints, value);
            }
            catch (Exception e) {
                return false;
            }
        }
        if (requiredType == 7) {
            String likeNameString;
            block61: {
                likeNameString = null;
                if (value.getType() == 1) {
                    likeNameString = value.getString();
                    break block61;
                }
                if (value.getType() == 2) {
                    likeNameString = this.getCharsetString(value.getString(), "UTF-8");
                    break block61;
                }
                if (value.getType() == 8) {
                    String pathString = value.getString();
                    String[] pathParts = pathString.split("\\/");
                    if (pathString.startsWith("/") && (pathParts.length > 1 || pathString.indexOf("[") > 0)) {
                        return false;
                    }
                    if (!pathParts.equals("/") && pathParts.length == 1 && pathString.indexOf("[") < 0) {
                        return this.checkValueConstraints(requiredType, constraints, value);
                    }
                    if (pathString.startsWith("/") && pathString.lastIndexOf("/") < 1 && pathString.indexOf("[") < 0) {
                        return this.checkValueConstraints(requiredType, constraints, value);
                    }
                    return false;
                }
                return false;
                {
                    catch (Exception e) {
                        return false;
                    }
                }
            }
            try {
                Value nameValue = this.valueFactory.createValue(likeNameString, requiredType);
                return nameValue != null && this.checkValueConstraints(requiredType, constraints, value);
            }
            catch (Exception e) {
                return false;
            }
        }
        if (requiredType == 8) {
            String likeNameString;
            block62: {
                likeNameString = null;
                if (value.getType() == 1) {
                    likeNameString = value.getString();
                    break block62;
                }
                if (value.getType() == 2) {
                    likeNameString = this.getCharsetString(value.getString(), "UTF-8");
                    break block62;
                }
                if (value.getType() == 7) {
                    return this.checkValueConstraints(requiredType, constraints, value);
                }
                return false;
                {
                    catch (Exception e) {
                        return false;
                    }
                }
            }
            try {
                Value nameValue = this.valueFactory.createValue(likeNameString, requiredType);
                return nameValue != null && this.checkValueConstraints(requiredType, constraints, value);
            }
            catch (Exception e) {
                return false;
            }
        }
        if (requiredType == 1) {
            String likeStringString = null;
            try {
                if (value.getType() == 2) {
                    likeStringString = this.getCharsetString(value.getString(), "UTF-8");
                } else if (value.getType() == 5 || value.getType() == 3 || value.getType() == 6 || value.getType() == 7 || value.getType() == 8 || value.getType() == 4) {
                    likeStringString = value.getString();
                } else {
                    return false;
                }
                return likeStringString != null && this.checkValueConstraints(requiredType, constraints, value);
            }
            catch (Exception e) {
                return false;
            }
        }
        if (requiredType == 0) {
            return this.checkValueConstraints(requiredType, constraints, value);
        }
        return false;
    }

    private boolean checkValueConstraints(int requiredType, String[] constraints, Value value) {
        ValueConstraintsMatcher constrMatcher = new ValueConstraintsMatcher(constraints, this.locationFactory, this.dataManager, this.nodeTypeDataManager);
        try {
            return constrMatcher.match(((BaseValue)value).getInternalData(), requiredType);
        }
        catch (RepositoryException e1) {
            return false;
        }
    }

    private String getCharsetString(String source, String charSetName) {
        try {
            CharBuffer cb = CharBuffer.wrap(source.toCharArray());
            Charset cs = Charset.forName(charSetName);
            CharsetEncoder cse = cs.newEncoder();
            ByteBuffer encoded = cse.encode(cb);
            return new String(encoded.array()).trim();
        }
        catch (IllegalStateException e) {
            return null;
        }
        catch (MalformedInputException e) {
            return null;
        }
        catch (UnmappableCharacterException e) {
            return null;
        }
        catch (CharacterCodingException e) {
            return null;
        }
    }

    private PropertyDefinition[] getPropertyDefinition(PropertyDefinitionData[] pdefs) {
        PropertyDefinition[] propertyDefinitions = new PropertyDefinition[pdefs.length];
        for (int i = 0; i < pdefs.length; ++i) {
            propertyDefinitions[i] = new PropertyDefinitionImpl(pdefs[i], this.nodeTypeDataManager, this.nodeTypeManager, this.locationFactory, this.valueFactory, this.dataManager);
        }
        return propertyDefinitions;
    }

    private boolean isCharsetString(String source, String charSetName) {
        try {
            String s = this.getCharsetString(source, charSetName);
            return s != null;
        }
        catch (Exception e) {
            return false;
        }
    }
}

