/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.ispn;

import java.io.IOException;
import java.io.Serializable;
import java.util.Set;
import org.exoplatform.services.jcr.impl.core.query.IndexerIoMode;
import org.exoplatform.services.jcr.impl.core.query.IndexerIoModeHandler;
import org.exoplatform.services.jcr.impl.core.query.IndexerIoModeListener;
import org.exoplatform.services.jcr.impl.core.query.ispn.IndexInfosKey;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexInfos;
import org.exoplatform.services.jcr.impl.core.query.lucene.MultiIndex;
import org.exoplatform.services.jcr.infinispan.PrivilegedISPNCacheHelper;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.infinispan.Cache;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Listener
public class ISPNIndexInfos
extends IndexInfos
implements IndexerIoModeListener {
    private final Log log = ExoLogger.getLogger((String)"exo.jcr.component.core.ISPNIndexInfos");
    private static final String INDEX_NAMES = "$names".intern();
    private static final String SYSINDEX_NAMES = "$sysNames".intern();
    private final Cache<Serializable, Object> cache;
    private final IndexerIoModeHandler modeHandler;
    private final IndexInfosKey namesKey;

    public ISPNIndexInfos(String wsId, Cache<Serializable, Object> cache, boolean system, IndexerIoModeHandler modeHandler) {
        this(wsId, "indexes", cache, system, modeHandler);
    }

    public ISPNIndexInfos(String wsId, String fileName, Cache<Serializable, Object> cache, boolean system, IndexerIoModeHandler modeHandler) {
        super(fileName);
        this.cache = cache;
        this.modeHandler = modeHandler;
        this.modeHandler.addIndexerIoModeListener(this);
        this.namesKey = new IndexInfosKey(wsId + (system ? SYSINDEX_NAMES : INDEX_NAMES));
        if (modeHandler.getMode() == IndexerIoMode.READ_ONLY) {
            cache.addListener((Object)this);
        }
    }

    @Override
    public void onChangeMode(IndexerIoMode mode) {
        if (mode == IndexerIoMode.READ_WRITE) {
            this.cache.removeListener((Object)this);
            try {
                super.read();
            }
            catch (IOException e) {
                this.log.error((Object)"Cannot read the list of index names", (Throwable)e);
            }
        } else {
            this.cache.addListener((Object)this);
        }
    }

    @Override
    public void write() throws IOException {
        if (this.isDirty() && this.modeHandler.getMode() == IndexerIoMode.READ_WRITE) {
            super.write();
            PrivilegedISPNCacheHelper.put(this.cache, this.namesKey, this.getNames());
        }
    }

    @CacheEntryModified
    public void cacheEntryModified(CacheEntryModifiedEvent event) {
        Set set;
        if (!event.isPre() && event.getKey().equals(this.namesKey) && (set = (Set)event.getValue()) != null) {
            this.setNames(set);
            try {
                MultiIndex multiIndex = this.getMultiIndex();
                if (multiIndex != null) {
                    multiIndex.refreshIndexList();
                }
            }
            catch (IOException e) {
                this.log.error((Object)("Failed to update indexes! " + e.getMessage()), (Throwable)e);
            }
        }
    }
}

