/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.InvalidItemStateException;
import javax.jcr.RepositoryException;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.ScoreDocComparator;
import org.apache.lucene.search.SortComparator;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.datamodel.IllegalNameException;
import org.exoplatform.services.jcr.datamodel.IllegalPathException;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.ItemType;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.query.lucene.FieldNames;
import org.exoplatform.services.jcr.impl.core.query.lucene.FieldSelectors;
import org.exoplatform.services.jcr.impl.core.query.lucene.MultiIndexReader;
import org.exoplatform.services.jcr.impl.core.query.lucene.NamespaceMappings;
import org.exoplatform.services.jcr.impl.core.query.lucene.SharedFieldCache;
import org.exoplatform.services.jcr.impl.core.query.lucene.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class SharedFieldSortComparator
extends SortComparator {
    private static Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.SharedFieldSortComparator");
    private final String field;
    private final ItemDataConsumer ism;
    private final LocationFactory locationFactory;
    private final NamespaceMappings nsMappings;

    public SharedFieldSortComparator(String fieldname, ItemDataConsumer ism, NamespaceMappings nsMappings) {
        this.field = fieldname;
        this.ism = ism;
        this.locationFactory = new LocationFactory(nsMappings);
        this.nsMappings = nsMappings;
    }

    public ScoreDocComparator newComparator(IndexReader reader, String relPath) throws IOException {
        try {
            QPath p = this.locationFactory.parseJCRPath(relPath).getInternalPath();
            SimpleScoreDocComparator simple = new SimpleScoreDocComparator(reader, this.nsMappings.translatePath(p));
            if (p.getEntries().length == 1) {
                return simple;
            }
            return new CompoundScoreDocComparator(reader, new ScoreDocComparator[]{simple, new RelPathScoreDocComparator(reader, p)});
        }
        catch (IllegalNameException e) {
            throw Util.createIOException(e);
        }
        catch (RepositoryException e) {
            throw Util.createIOException(e);
        }
    }

    protected Comparable getComparable(String termtext) {
        throw new UnsupportedOperationException();
    }

    private static void getIndexReaders(List readers, IndexReader reader) {
        if (reader instanceof MultiIndexReader) {
            IndexReader[] r = ((MultiIndexReader)reader).getIndexReaders();
            for (int i = 0; i < r.length; ++i) {
                SharedFieldSortComparator.getIndexReaders(readers, r[i]);
            }
        } else {
            readers.add(reader);
        }
    }

    private ItemData getItemData(NodeData parent, QPathEntry name, ItemType itemType) throws RepositoryException {
        if (name.getName().equals("..") && name.getNamespace().equals("")) {
            if (parent.getIdentifier().equals("00exo0jcr0root0uuid0000000000000")) {
                return null;
            }
            return this.ism.getItemData(parent.getParentIdentifier());
        }
        return this.ism.getItemData(parent, name, itemType);
    }

    private ItemData getItemData(NodeData parent, QPath relPath, ItemType itemType) throws RepositoryException {
        QPathEntry[] relPathEntries = relPath.getEntries();
        ItemData item = parent;
        for (int i = 0; i < relPathEntries.length && (item = i == relPathEntries.length - 1 ? this.getItemData(parent, relPathEntries[i], itemType) : this.getItemData(parent, relPathEntries[i], ItemType.UNKNOWN)) != null; ++i) {
            if (item.isNode()) {
                parent = (NodeData)item;
                continue;
            }
            if (i >= relPathEntries.length - 1) continue;
            throw new IllegalPathException("Path can not contains a property as the intermediate element");
        }
        return item;
    }

    private final class CompoundScoreDocComparator
    extends AbstractScoreDocComparator {
        private final ScoreDocComparator[] comparators;

        public CompoundScoreDocComparator(IndexReader reader, ScoreDocComparator[] comparators) throws IOException {
            super(reader);
            this.comparators = comparators;
        }

        public Comparable sortValue(ScoreDoc i) {
            for (int j = 0; j < this.comparators.length; ++j) {
                Comparable c = this.comparators[j].sortValue(i);
                if (c == null) continue;
                return c;
            }
            return null;
        }
    }

    private final class RelPathScoreDocComparator
    extends AbstractScoreDocComparator {
        private final QPath relPath;

        public RelPathScoreDocComparator(IndexReader reader, QPath relPath) throws IOException {
            super(reader);
            this.relPath = relPath;
        }

        public Comparable sortValue(ScoreDoc i) {
            try {
                int idx = this.readerIndex(i.doc);
                IndexReader reader = (IndexReader)this.readers.get(idx);
                Document doc = reader.document(i.doc - this.starts[idx], FieldSelectors.UUID);
                String uuid = doc.get(FieldNames.UUID);
                ItemData parent = SharedFieldSortComparator.this.ism.getItemData(uuid);
                if (!parent.isNode()) {
                    throw new InvalidItemStateException();
                }
                ItemData property = SharedFieldSortComparator.this.getItemData((NodeData)parent, this.relPath, ItemType.PROPERTY);
                if (property != null) {
                    if (property.isNode()) {
                        throw new InvalidItemStateException();
                    }
                    PropertyData propertyData = (PropertyData)property;
                    List<ValueData> values = propertyData.getValues();
                    if (values.size() > 0) {
                        return Util.getComparable(values.get(0), propertyData.getType());
                    }
                }
                return null;
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                return null;
            }
        }
    }

    private final class SimpleScoreDocComparator
    extends AbstractScoreDocComparator {
        protected final SharedFieldCache.ValueIndex[] indexes;

        public SimpleScoreDocComparator(IndexReader reader, String propertyName) throws IOException {
            super(reader);
            this.indexes = new SharedFieldCache.ValueIndex[this.readers.size()];
            String namedValue = FieldNames.createNamedValue(propertyName, "");
            for (int i = 0; i < this.readers.size(); ++i) {
                IndexReader r = (IndexReader)this.readers.get(i);
                this.indexes[i] = SharedFieldCache.INSTANCE.getValueIndex(r, SharedFieldSortComparator.this.field, namedValue, SharedFieldSortComparator.this);
            }
        }

        public Comparable sortValue(ScoreDoc i) {
            int idx = this.readerIndex(i.doc);
            return this.indexes[idx].getValue(i.doc - this.starts[idx]);
        }
    }

    abstract class AbstractScoreDocComparator
    implements ScoreDocComparator {
        protected final List readers = new ArrayList();
        protected final int[] starts;

        public AbstractScoreDocComparator(IndexReader reader) throws IOException {
            SharedFieldSortComparator.getIndexReaders(this.readers, reader);
            int maxDoc = 0;
            this.starts = new int[this.readers.size() + 1];
            for (int i = 0; i < this.readers.size(); ++i) {
                IndexReader r = (IndexReader)this.readers.get(i);
                this.starts[i] = maxDoc;
                maxDoc += r.maxDoc();
            }
            this.starts[this.readers.size()] = maxDoc;
        }

        public int compare(ScoreDoc i, ScoreDoc j) {
            return Util.compare(this.sortValue(i), this.sortValue(j));
        }

        public int sortType() {
            return 9;
        }

        protected int readerIndex(int n) {
            int lo = 0;
            int hi = this.readers.size() - 1;
            while (hi >= lo) {
                int mid = lo + hi >> 1;
                int midValue = this.starts[mid];
                if (n < midValue) {
                    hi = mid - 1;
                    continue;
                }
                if (n > midValue) {
                    lo = mid + 1;
                    continue;
                }
                while (mid + 1 < this.readers.size() && this.starts[mid + 1] == midValue) {
                    ++mid;
                }
                return mid;
            }
            return hi;
        }
    }
}

