/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.quasiliteral;

import com.google.caja.SomethingWidgyHappenedError;
import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.InputSource;
import com.google.caja.parser.AbstractParseTreeNode;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.ParseTreeNodeContainer;
import com.google.caja.parser.js.BreakStmt;
import com.google.caja.parser.js.ContinueStmt;
import com.google.caja.parser.js.Declaration;
import com.google.caja.parser.js.Identifier;
import com.google.caja.parser.js.Literal;
import com.google.caja.parser.js.Reference;
import com.google.caja.parser.js.SyntheticNodes;
import com.google.caja.parser.quasiliteral.RewriterMessageType;
import com.google.caja.parser.quasiliteral.Rule;
import com.google.caja.parser.quasiliteral.RuleChain;
import com.google.caja.parser.quasiliteral.Scope;
import com.google.caja.render.Concatenator;
import com.google.caja.render.JsPrettyPrinter;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.MessageTypeInt;
import com.google.caja.reporting.RenderContext;
import com.google.caja.util.SyntheticAttributes;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Rewriter {
    private final RuleChain rules = new RuleChain();
    private final Set<String> ruleNames = new HashSet<String>();
    final MessageQueue mq;
    private final boolean taintChecking;
    private final boolean logging;

    public Rewriter(MessageQueue mq, boolean taintChecking, boolean logging) {
        assert (mq != null);
        this.mq = mq;
        this.taintChecking = taintChecking;
        this.logging = logging;
    }

    public Iterable<? extends Rule> getRules() {
        return this.rules.getAllRules();
    }

    protected final ParseTreeNode expand(ParseTreeNode node, Scope scope) {
        boolean debug = false;
        Iterable<Rule> run = debug ? this.rules.getAllRules() : this.rules.applicableTo(node);
        for (Rule rule : run) {
            try {
                ParseTreeNode result = rule.fire(node, scope);
                if (result == Rule.NONE) continue;
                if (debug && !this.rules.applicableTo(node).contains(rule)) {
                    throw new SomethingWidgyHappenedError(rule.getName() + " should be applicable to " + node);
                }
                FilePosition resultPos = result.getFilePosition();
                if (result instanceof AbstractParseTreeNode && InputSource.UNKNOWN.equals(resultPos.source())) {
                    ((AbstractParseTreeNode)result).setFilePosition(node.getFilePosition());
                }
                if (this.logging) {
                    this.logResults(rule, node, result, null);
                }
                return result;
            }
            catch (RuntimeException ex) {
                if (this.logging) {
                    this.logResults(rule, node, null, ex);
                }
                throw ex;
            }
        }
        this.mq.addMessage((MessageTypeInt)RewriterMessageType.UNMATCHED_NODE_LEFT_OVER, node.getFilePosition(), node);
        return node;
    }

    public void addRule(Rule rule) {
        if (!this.ruleNames.add(rule.getName())) {
            throw new IllegalArgumentException("Duplicate rule name: " + rule.getName());
        }
        this.rules.add(rule);
        rule.setRewriter(this);
    }

    public void addRules(Rule[] rules) {
        for (Rule r : rules) {
            this.addRule(r);
        }
    }

    private void logResults(Rule rule, ParseTreeNode input, ParseTreeNode result, Exception exception) {
        StringBuilder s = new StringBuilder();
        s.append("-----------------------------------------------------------------------\n");
        if (rule != null) {
            s.append("rule: ").append(rule.getName()).append("\n");
        }
        if (input != null) {
            s.append("input: (").append(input.getClass().getSimpleName()).append(") ").append(Rewriter.render(input)).append("\n");
        }
        if (result != null) {
            s.append("result: (").append(result.getClass().getSimpleName()).append(") ").append(Rewriter.render(result)).append("\n");
        }
        if (exception != null) {
            s.append("error: ").append(exception.toString()).append("\n");
        }
        System.err.println(s.toString());
    }

    public static String render(ParseTreeNode n) {
        StringBuilder output = new StringBuilder();
        JsPrettyPrinter renderer = new JsPrettyPrinter(new Concatenator(output));
        n.render(new RenderContext(renderer));
        renderer.noMoreTokens();
        return output.toString();
    }

    public final ParseTreeNode expand(ParseTreeNode node) {
        if (this.taintChecking) {
            Rewriter.flagTainted(node, this.mq);
            ParseTreeNode result = this.expand(node, null);
            Rewriter.checkTainted(result, this.mq);
            return result;
        }
        return this.expand(node, null);
    }

    private static void flagTainted(ParseTreeNode node, MessageQueue mq) {
        if (node.getAttributes().is(ParseTreeNode.TAINTED)) {
            mq.addMessage((MessageTypeInt)RewriterMessageType.MULTIPLY_TAINTED, node, node.getFilePosition());
        }
        node.getAttributes().set(ParseTreeNode.TAINTED, true);
        for (ParseTreeNode parseTreeNode : node.children()) {
            Rewriter.flagTainted(parseTreeNode, mq);
        }
    }

    private static void checkTainted(ParseTreeNode node, MessageQueue mq) {
        if (mq.hasMessageAtLevel(MessageLevel.ERROR)) {
            return;
        }
        SyntheticAttributes attrs = node.getAttributes();
        if (attrs.is(ParseTreeNode.TAINTED) && !attrs.is(SyntheticNodes.SYNTHETIC)) {
            mq.addMessage((MessageTypeInt)RewriterMessageType.UNSEEN_NODE_LEFT_OVER, node, node.getFilePosition());
        }
        for (ParseTreeNode parseTreeNode : node.children()) {
            Rewriter.checkTainted(parseTreeNode, mq);
        }
    }

    private <T extends ParseTreeNode> T removeTaint(T node) {
        if (this.taintChecking) {
            node.getAttributes().remove(ParseTreeNode.TAINTED);
        }
        return node;
    }

    protected Reference noexpand(Reference node) {
        this.removeTaint(node.getIdentifier());
        return this.removeTaint(node);
    }

    protected Declaration noexpand(Declaration node) {
        if (node.getInitializer() != null) {
            this.mq.addMessage((MessageTypeInt)RewriterMessageType.NOEXPAND_BINARY_DECL, node.getFilePosition(), node);
            return node;
        }
        this.removeTaint(node.getIdentifier());
        return this.removeTaint(node);
    }

    protected Identifier noexpand(Identifier node) {
        return this.removeTaint(node);
    }

    protected <T extends Literal> T noexpand(T node) {
        return this.removeTaint(node);
    }

    protected BreakStmt noexpand(BreakStmt node) {
        return this.removeTaint(node);
    }

    protected ContinueStmt noexpand(ContinueStmt node) {
        return this.removeTaint(node);
    }

    protected ParseTreeNodeContainer noexpandParams(ParseTreeNodeContainer node) {
        if (this.taintChecking) {
            for (ParseTreeNode parseTreeNode : node.children()) {
                this.noexpand((Declaration)parseTreeNode);
            }
            return this.removeTaint(node);
        }
        return node;
    }
}

