/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionSafeMap<K, V>
implements Map<K, V> {
    private static final Object TOMBSTONE = new Object();
    private final Map<K, V> wrapped;
    private Map<K, Object> changes = null;
    private Set<K> deleted = Collections.emptySet();
    private int size;

    public TransactionSafeMap(Map<K, V> m) {
        if (null == m) {
            throw new NullPointerException();
        }
        this.wrapped = m;
        this.size = this.wrapped.size();
    }

    @Override
    public V get(Object k) {
        if (null != this.changes && this.changes.containsKey(k)) {
            Object result = this.changes.get(k);
            return (V)(TOMBSTONE != result ? result : null);
        }
        return this.wrapped.get(k);
    }

    @Override
    public boolean containsKey(Object k) {
        if (null != this.changes && this.changes.containsKey(k)) {
            return TOMBSTONE != this.changes.get(k);
        }
        return this.wrapped.containsKey(k);
    }

    @Override
    public boolean containsValue(Object v) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<K> keySet() {
        if (null == this.changes) {
            return Collections.unmodifiableMap(this.wrapped).keySet();
        }
        HashSet<K> keys = new HashSet<K>(this.wrapped.keySet());
        keys.addAll(this.changes.keySet());
        keys.removeAll(this.deleted);
        return Collections.unmodifiableSet(keys);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (null == this.changes) {
            return Collections.unmodifiableMap(this.wrapped).entrySet();
        }
        HashSet<Map.Entry<K, V>> entries = new HashSet<Map.Entry<K, V>>();
        for (Map.Entry<K, V> entry : this.wrapped.entrySet()) {
            entries.add(this.entry(entry.getKey(), entry.getValue()));
        }
        for (Map.Entry<K, Object> entry : this.changes.entrySet()) {
            Object v = entry.getValue();
            if (TOMBSTONE == v) {
                entries.remove(entry.getKey());
                continue;
            }
            entries.add(this.entry(entry.getKey(), entry.getValue()));
        }
        return Collections.unmodifiableSet(entries);
    }

    @Override
    private Map.Entry<K, V> entry(final K k, final V v) {
        return new Map.Entry<K, V>(){

            @Override
            public K getKey() {
                return k;
            }

            @Override
            public V getValue() {
                return v;
            }

            @Override
            public V setValue(V _) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int hashCode() {
                return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
            }

            @Override
            public boolean equals(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry that = (Map.Entry)o;
                return (this.getKey() == null ? that.getKey() == null : this.getKey().equals(that.getKey())) && (this.getValue() == null ? that.getValue() == null : this.getValue().equals(that.getValue()));
            }
        };
    }

    @Override
    public Collection<V> values() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        if (null == this.changes) {
            this.changes = new HashMap<K, Object>();
        } else {
            this.changes.clear();
        }
        for (K k : this.wrapped.keySet()) {
            this.changes.put(k, TOMBSTONE);
        }
        this.size = 0;
    }

    @Override
    public V put(K k, V v) {
        Object ov;
        if (null == this.changes || !this.changes.containsKey(k)) {
            if (this.wrapped.containsKey(k)) {
                ov = this.wrapped.get(k);
                if (v == ov) {
                    return ov;
                }
            } else {
                ++this.size;
                ov = null;
            }
            if (null == this.changes) {
                this.changes = new HashMap<K, Object>();
            }
        } else {
            Object o = this.changes.get(k);
            if (TOMBSTONE == o) {
                ++this.size;
                ov = null;
            } else {
                ov = o;
            }
        }
        this.changes.put(k, v);
        return ov;
    }

    @Override
    public V remove(Object k) {
        if (null == this.changes || !this.changes.containsKey(k)) {
            if (this.wrapped.containsKey(k)) {
                V o = this.wrapped.get(k);
                if (null == this.changes) {
                    this.changes = new HashMap<K, Object>();
                }
                this.changes.put(k, TOMBSTONE);
                --this.size;
                return o;
            }
            return null;
        }
        Object o = this.changes.get(k);
        if (TOMBSTONE == o) {
            return null;
        }
        this.changes.put(k, TOMBSTONE);
        --this.size;
        return (V)o;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public boolean isEmpty() {
        return 0 == this.size;
    }

    @Override
    public int size() {
        return this.size;
    }

    public void commit() {
        if (null != this.changes) {
            for (Map.Entry<K, Object> e : this.changes.entrySet()) {
                K k = e.getKey();
                Object v = e.getValue();
                if (TOMBSTONE != v) {
                    this.wrapped.put(k, v);
                    continue;
                }
                this.wrapped.remove(k);
            }
            this.changes = null;
        }
    }

    public void rollback() {
        this.changes = null;
        this.size = this.wrapped.size();
    }
}

