/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.pc;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.commons.utils.Safe;
import org.exoplatform.portal.pc.ExoResourceBundleFactory;
import org.exoplatform.portal.pc.GlobalPortletMetaData;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.pc.mc.PortletApplicationDeployer;
import org.gatein.pc.portlet.impl.metadata.PortletApplication10MetaData;
import org.gatein.wci.WebApp;
import org.jboss.xb.binding.JBossXBException;

public class ExoPortletApplicationDeployer
extends PortletApplicationDeployer {
    private final Logger log = LoggerFactory.getLogger(ExoPortletApplicationDeployer.class);

    protected PortletApplication10MetaData buildPortletApplicationMetaData(WebApp webApp) {
        PortletApplication10MetaData md;
        block6: {
            md = super.buildPortletApplicationMetaData(webApp);
            if (md != null) {
                md.setResourceBundleFactoryName(ExoResourceBundleFactory.class.getName());
                String globalPortletLocation = PropertyManager.getProperty((String)"gatein.portlet.config");
                if (globalPortletLocation != null) {
                    try {
                        GlobalPortletMetaData globalPortletMetaData = this.loadGlobalMetadata(globalPortletLocation);
                        globalPortletMetaData.mergeTo(md);
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("Complete merging global portlet metadata to portlet application " + webApp.getServletContext().getServletContextName()));
                        }
                        break block6;
                    }
                    catch (Exception ex) {
                        if (this.log.isErrorEnabled()) {
                            this.log.error((Object)("Error during merge global portlet metadata to portlet application " + webApp.getServletContext().getServletContextName()), (Throwable)ex);
                        }
                        break block6;
                    }
                }
                this.log.warn((Object)"The global portlet metadata is not configured");
            }
        }
        return md;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GlobalPortletMetaData loadGlobalMetadata(String globalPortletLocation) throws FileNotFoundException, JBossXBException {
        FileInputStream in = new FileInputStream(new File(globalPortletLocation));
        try {
            GlobalPortletMetaData globalPortletMetaData = GlobalPortletMetaData.unmarshalling(in);
            return globalPortletMetaData;
        }
        finally {
            Safe.close((Closeable)in);
        }
    }
}

