/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.clean.rdbms;

import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class DBCleanHelper {
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.DBCleanHelper");
    private final String selectItems;
    private final String removeItems;
    protected final Connection connection;

    public DBCleanHelper(Connection connection, String selectItemds, String removeItems) {
        this.connection = connection;
        this.selectItems = selectItemds;
        this.removeItems = removeItems;
    }

    public void clean() throws SQLException {
        this.recursiveClean(Constants.ROOT_PARENT_UUID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recursiveClean(String parentID) throws SQLException {
        ResultSet result;
        Statement removeStatement;
        block9: {
            PreparedStatement selectStatement = null;
            removeStatement = null;
            result = null;
            try {
                selectStatement = this.connection.prepareStatement(this.selectItems);
                selectStatement.setString(1, parentID);
                final PreparedStatement fSelectStatement = selectStatement;
                result = (ResultSet)SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        return fSelectStatement.executeQuery();
                    }
                });
                if (result.next()) {
                    do {
                        this.recursiveClean(result.getString(1));
                    } while (result.next());
                    removeStatement = this.connection.prepareStatement(this.removeItems);
                    removeStatement.setString(1, parentID);
                    Statement fRemoveStatement = removeStatement;
                    SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>((PreparedStatement)fRemoveStatement){
                        final /* synthetic */ PreparedStatement val$fRemoveStatement;
                        {
                            this.val$fRemoveStatement = preparedStatement;
                        }

                        @Override
                        public Object run() throws Exception {
                            this.val$fRemoveStatement.executeUpdate();
                            return null;
                        }
                    });
                }
                Object var8_7 = null;
                if (selectStatement == null) break block9;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (selectStatement != null) {
                    selectStatement.close();
                }
                if (removeStatement != null) {
                    removeStatement.close();
                }
                if (result != null) {
                    result.close();
                }
                throw throwable;
            }
            selectStatement.close();
        }
        if (removeStatement != null) {
            removeStatement.close();
        }
        if (result != null) {
            result.close();
        }
    }
}

