/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser;

import com.google.caja.parser.ParseTreeNode;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ChildNodes<T extends ParseTreeNode> {
    private List<T> backingList;
    private final Class<? extends T> elementClass;
    private List<T> mutableFacet;
    private List<T> immutableFacet;

    public ChildNodes(Class<? extends T> elementClass) {
        assert (elementClass.getTypeParameters().length == 0);
        this.elementClass = elementClass;
    }

    public ChildNodes(ChildNodes<? extends T> source) {
        this.backingList = new ArrayList<T>(source.backingList);
        this.elementClass = source.elementClass;
    }

    public Class<? extends T> getElementClass() {
        return this.elementClass;
    }

    public List<T> getMutableFacet() {
        if (this.mutableFacet == null) {
            this.mutableFacet = new MutableFacet();
        }
        return this.mutableFacet;
    }

    public List<T> getImmutableFacet() {
        if (this.immutableFacet == null) {
            this.immutableFacet = Collections.unmodifiableList(this.getBackingList());
        }
        return this.immutableFacet;
    }

    public <SubT extends T> ChildNodes<? extends SubT> as(Class<SubT> subClass) {
        this.elementClass.asSubclass(subClass);
        return this;
    }

    private List<T> getBackingList() {
        if (this.backingList == null) {
            this.backingList = new ArrayList<T>();
        }
        return this.backingList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MutableFacet
    extends AbstractList<T> {
        private MutableFacet() {
        }

        @Override
        public int size() {
            return ChildNodes.this.getBackingList().size();
        }

        @Override
        public T get(int i) {
            return (ParseTreeNode)ChildNodes.this.getBackingList().get(i);
        }

        @Override
        public T set(int i, T element) {
            return (ParseTreeNode)ChildNodes.this.getBackingList().set(i, ChildNodes.this.elementClass.cast(element));
        }

        @Override
        public void add(int i, T element) {
            ChildNodes.this.getBackingList().add(i, ChildNodes.this.elementClass.cast(element));
        }

        @Override
        public T remove(int i) {
            return (ParseTreeNode)ChildNodes.this.getBackingList().remove(i);
        }
    }
}

