/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.quartz.inflow;

import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkManager;
import org.jboss.resource.adapter.quartz.inflow.QuartzResourceAdapter;
import org.quartz.SchedulerConfigException;
import org.quartz.spi.ThreadPool;

public class JBossQuartzThreadPool
implements ThreadPool {
    private int poolSize = Integer.MAX_VALUE;
    private WorkManager workManager;

    public void initialize() throws SchedulerConfigException {
        this.workManager = QuartzResourceAdapter.getConfigTimeWorkManager();
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public boolean runInThread(Runnable runnable) {
        try {
            WorkWrapper workWrapper = new WorkWrapper(runnable);
            this.workManager.doWork((Work)workWrapper);
            return true;
        }
        catch (WorkException e) {
            return false;
        }
    }

    public void shutdown(boolean waitForJobsToComplete) {
    }

    public void setPoolSize(int poolSize) {
        this.poolSize = poolSize;
    }

    private class WorkWrapper
    implements Work {
        private Runnable delegate;

        public WorkWrapper(Runnable delegate) {
            this.delegate = delegate;
        }

        public void run() {
            this.delegate.run();
        }

        public void release() {
        }
    }
}

