/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.container.jboss50.deployer;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import javax.management.ObjectName;
import javax.naming.Context;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.ejb.deployers.EjbDeployment;
import org.jboss.ejb.deployers.MergedJBossMetaDataDeployer;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.Ejb3Deployment;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.wsf.container.jboss50.deployer.AbstractWebServiceDeployer;
import org.jboss.wsf.spi.deployment.integration.WebServiceDeclaration;
import org.jboss.wsf.spi.deployment.integration.WebServiceDeployment;

public class WebServiceDeployerEJB
extends AbstractWebServiceDeployer {
    private static final Logger log = Logger.getLogger(WebServiceDeployerEJB.class);

    public WebServiceDeployerEJB() {
        this.addInput(MergedJBossMetaDataDeployer.EJB_MERGED_ATTACHMENT_NAME);
        this.addInput(EjbDeployment.class);
        this.addInput(Ejb3Deployment.class);
        this.addOutput(JBossWebMetaData.class);
        this.addOutput(WebServiceDeployment.class);
    }

    public void internalDeploy(DeploymentUnit unit) throws DeploymentException {
        JBossMetaData beans = (JBossMetaData)unit.getAttachment(MergedJBossMetaDataDeployer.EJB_MERGED_ATTACHMENT_NAME);
        Ejb3Deployment ejb3Deployment = (Ejb3Deployment)unit.getAttachment(Ejb3Deployment.class);
        if (beans != null) {
            WebServiceDeploymentAdapter wsDeployment = new WebServiceDeploymentAdapter();
            for (JBossEnterpriseBeanMetaData ejb : beans.getEnterpriseBeans()) {
                EJBContainer ejbContainer = null;
                if (ejb3Deployment != null && !ejb.isEntity()) {
                    ObjectName objName = null;
                    try {
                        objName = new ObjectName(ejb.determineContainerName());
                    }
                    catch (Exception e) {
                        throw new DeploymentException((Throwable)e);
                    }
                    ejbContainer = (EJBContainer)ejb3Deployment.getContainer(objName);
                }
                if (ejb.getEjbClass() != null) {
                    wsDeployment.getEndpoints().add(new WebServiceDeclarationAdapter(ejb, ejbContainer, unit.getClassLoader()));
                    continue;
                }
                log.warn((Object)("Ingore ejb deployment with null classname: " + ejb));
            }
            unit.addAttachment(WebServiceDeployment.class, (Object)wsDeployment);
            super.internalDeploy(unit);
        }
    }

    public void internalUndeploy(DeploymentUnit unit) {
        super.internalUndeploy(unit);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WebServiceDeploymentAdapter
    implements WebServiceDeployment {
        private List<WebServiceDeclaration> endpoints = new ArrayList<WebServiceDeclaration>();

        private WebServiceDeploymentAdapter() {
        }

        public List<WebServiceDeclaration> getServiceEndpoints() {
            return this.endpoints;
        }

        public List<WebServiceDeclaration> getEndpoints() {
            return this.endpoints;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WebServiceDeclarationAdapter
    implements WebServiceDeclaration {
        private JBossEnterpriseBeanMetaData ejbMetaData;
        private EJBContainer ejbContainer;
        private ClassLoader loader;

        public WebServiceDeclarationAdapter(JBossEnterpriseBeanMetaData ejbMetaData, EJBContainer ejbContainer, ClassLoader loader) {
            this.ejbMetaData = ejbMetaData;
            this.ejbContainer = ejbContainer;
            this.loader = loader;
        }

        public String getContainerName() {
            return this.ejbMetaData.determineContainerName();
        }

        public Context getContext() {
            return this.ejbContainer.getEnc();
        }

        public String getComponentName() {
            return this.ejbMetaData.getName();
        }

        public String getComponentClassName() {
            return this.ejbMetaData.getEjbClass();
        }

        public <T extends Annotation> T getAnnotation(Class<T> annotation) {
            Class bean;
            Annotation result;
            Annotation annotation2 = result = this.ejbContainer != null ? this.ejbContainer.getAnnotation(annotation) : null;
            if (result == null && (bean = this.getComponentClass()).isAnnotationPresent(annotation)) {
                result = bean.getAnnotation(annotation);
            }
            return (T)result;
        }

        private Class getComponentClass() {
            try {
                return this.loader.loadClass(this.getComponentClassName());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Failed to load component class " + this.getComponentClassName() + ". Loader:" + this.loader);
            }
        }
    }
}

