/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.conf;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.conf.ClassMap;
import org.jgroups.util.Util;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MagicNumberReader {
    public static final String MAGIC_NUMBER_FILE = "jg-magic-map.xml";
    public String mMagicNumberFile = "jg-magic-map.xml";
    protected static final Log log = LogFactory.getLog(MagicNumberReader.class);

    public void setFilename(String file) {
        this.mMagicNumberFile = file;
    }

    public ClassMap[] readMagicNumberMapping() {
        try {
            InputStream stream;
            block9: {
                stream = Util.getResourceAsStream(this.mMagicNumberFile, this.getClass());
                if (stream == null) {
                    try {
                        if (log.isTraceEnabled()) {
                            log.trace((Object)("Could not read " + this.mMagicNumberFile + " as Resource from the CLASSPATH, will try to read it from file."));
                        }
                        stream = new FileInputStream(this.mMagicNumberFile);
                        if (log.isTraceEnabled()) {
                            log.trace((Object)("Magic number file found at '" + this.mMagicNumberFile + '\''));
                        }
                    }
                    catch (FileNotFoundException fnfe) {
                        if (!log.isWarnEnabled()) break block9;
                        log.warn((Object)("Failed reading - '" + this.mMagicNumberFile + "' is not found, got error '" + fnfe.getLocalizedMessage() + "'. Please make sure it is in the CLASSPATH or in the " + "specified location. Will continue, but marshalling will be slower"));
                    }
                }
            }
            if (stream == null) {
                return new ClassMap[0];
            }
            return MagicNumberReader.parse(stream);
        }
        catch (Exception x) {
            if (log.isErrorEnabled()) {
                log.error((Object)"failed reading magic map", (Throwable)x);
            }
            return new ClassMap[0];
        }
    }

    protected static ClassMap[] parse(InputStream stream) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(stream);
        NodeList class_list = document.getElementsByTagName("class");
        Vector<ClassMap> v = new Vector<ClassMap>();
        for (int i = 0; i < class_list.getLength(); ++i) {
            if (class_list.item(i).getNodeType() != 1) continue;
            v.addElement(MagicNumberReader.parseClassData(class_list.item(i)));
        }
        Object[] data = new ClassMap[v.size()];
        v.copyInto(data);
        return data;
    }

    protected static ClassMap parseClassData(Node protocol) throws IOException {
        try {
            protocol.normalize();
            NamedNodeMap attrs = protocol.getAttributes();
            String clazzname = null;
            String magicnumber = null;
            magicnumber = attrs.getNamedItem("id").getNodeValue();
            clazzname = attrs.getNamedItem("name").getNodeValue();
            return new ClassMap(clazzname, Short.valueOf(magicnumber));
        }
        catch (Exception x) {
            IOException tmp = new IOException();
            tmp.initCause(x);
            throw tmp;
        }
    }
}

