/*
 * Decompiled with CFR 0.152.
 */
package org.quartz;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.TreeSet;
import org.quartz.ValueSet;

public class CronExpression
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 12423409423L;
    protected static final int SECOND = 0;
    protected static final int MINUTE = 1;
    protected static final int HOUR = 2;
    protected static final int DAY_OF_MONTH = 3;
    protected static final int MONTH = 4;
    protected static final int DAY_OF_WEEK = 5;
    protected static final int YEAR = 6;
    protected static final int ALL_SPEC_INT = 99;
    protected static final int NO_SPEC_INT = 98;
    protected static final Integer ALL_SPEC = new Integer(99);
    protected static final Integer NO_SPEC = new Integer(98);
    protected static Map monthMap = new HashMap(20);
    protected static Map dayMap = new HashMap(60);
    private String cronExpression = null;
    private TimeZone timeZone = null;
    protected transient TreeSet seconds;
    protected transient TreeSet minutes;
    protected transient TreeSet hours;
    protected transient TreeSet daysOfMonth;
    protected transient TreeSet months;
    protected transient TreeSet daysOfWeek;
    protected transient TreeSet years;
    protected transient boolean lastdayOfWeek = false;
    protected transient int nthdayOfWeek = 0;
    protected transient boolean lastdayOfMonth = false;
    protected transient boolean nearestWeekday = false;
    protected transient boolean calendardayOfWeek = false;
    protected transient boolean calendardayOfMonth = false;
    protected transient boolean expressionParsed = false;

    public CronExpression(String cronExpression) throws ParseException {
        if (cronExpression == null) {
            throw new IllegalArgumentException("cronExpression cannot be null");
        }
        this.cronExpression = cronExpression;
        this.buildExpression(cronExpression.toUpperCase(Locale.US));
    }

    public boolean isSatisfiedBy(Date date) {
        Calendar testDateCal = Calendar.getInstance();
        testDateCal.setTime(date);
        testDateCal.set(14, 0);
        Date originalDate = testDateCal.getTime();
        testDateCal.add(13, -1);
        return this.getTimeAfter(testDateCal.getTime()).equals(originalDate);
    }

    public Date getNextValidTimeAfter(Date date) {
        return this.getTimeAfter(date);
    }

    public TimeZone getTimeZone() {
        if (this.timeZone == null) {
            this.timeZone = TimeZone.getDefault();
        }
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public String toString() {
        return this.cronExpression;
    }

    public static boolean isValidExpression(String cronExpression) {
        try {
            new CronExpression(cronExpression);
        }
        catch (ParseException pe) {
            return false;
        }
        return true;
    }

    protected void buildExpression(String expression) throws ParseException {
        this.expressionParsed = true;
        try {
            int exprOn;
            if (this.seconds == null) {
                this.seconds = new TreeSet();
            }
            if (this.minutes == null) {
                this.minutes = new TreeSet();
            }
            if (this.hours == null) {
                this.hours = new TreeSet();
            }
            if (this.daysOfMonth == null) {
                this.daysOfMonth = new TreeSet();
            }
            if (this.months == null) {
                this.months = new TreeSet();
            }
            if (this.daysOfWeek == null) {
                this.daysOfWeek = new TreeSet();
            }
            if (this.years == null) {
                this.years = new TreeSet();
            }
            StringTokenizer exprsTok = new StringTokenizer(expression, " \t", false);
            for (exprOn = 0; exprsTok.hasMoreTokens() && exprOn <= 6; ++exprOn) {
                String expr = exprsTok.nextToken().trim();
                StringTokenizer vTok = new StringTokenizer(expr, ",");
                while (vTok.hasMoreTokens()) {
                    String v = vTok.nextToken();
                    this.storeExpressionVals(0, v, exprOn);
                }
            }
            if (exprOn <= 5) {
                throw new ParseException("Unexpected end of expression.", expression.length());
            }
            if (exprOn <= 6) {
                this.storeExpressionVals(0, "*", 6);
            }
        }
        catch (ParseException pe) {
            throw pe;
        }
        catch (Exception e) {
            throw new ParseException("Illegal cron expression format (" + e.toString() + ")", 0);
        }
    }

    protected int storeExpressionVals(int pos, String s, int type) throws ParseException {
        int val;
        int incr = 0;
        int i = this.skipWhiteSpace(pos, s);
        if (i >= s.length()) {
            return i;
        }
        char c = s.charAt(i);
        if (c >= 'A' && c <= 'Z' && !s.equals("L") && !s.equals("LW")) {
            int eval;
            int sval;
            block45: {
                String sub = s.substring(i, i + 3);
                sval = -1;
                eval = -1;
                if (type == 4) {
                    sval = this.getMonthNumber(sub) + 1;
                    if (sval < 0) {
                        throw new ParseException("Invalid Month value: '" + sub + "'", i);
                    }
                    if (s.length() > i + 3 && (c = s.charAt(i + 3)) == '-' && (eval = this.getMonthNumber(sub = s.substring(i += 4, i + 3)) + 1) < 0) {
                        throw new ParseException("Invalid Month value: '" + sub + "'", i);
                    }
                } else if (type == 5) {
                    sval = this.getDayOfWeekNumber(sub);
                    if (sval < 0) {
                        throw new ParseException("Invalid Day-of-Week value: '" + sub + "'", i);
                    }
                    if (s.length() > i + 3) {
                        c = s.charAt(i + 3);
                        if (c == '-') {
                            if ((eval = this.getDayOfWeekNumber(sub = s.substring(i += 4, i + 3))) < 0) {
                                throw new ParseException("Invalid Day-of-Week value: '" + sub + "'", i);
                            }
                            if (sval > eval) {
                                throw new ParseException("Invalid Day-of-Week sequence: " + sval + " > " + eval, i);
                            }
                        } else {
                            if (c == '#') {
                                try {
                                    this.nthdayOfWeek = Integer.parseInt(s.substring(i += 4));
                                    if (this.nthdayOfWeek < 1 || this.nthdayOfWeek > 5) {
                                        throw new Exception();
                                    }
                                    break block45;
                                }
                                catch (Exception e) {
                                    throw new ParseException("A numeric value between 1 and 5 must follow the '#' option", i);
                                }
                            }
                            if (c == 'L') {
                                this.lastdayOfWeek = true;
                                ++i;
                            }
                        }
                    }
                } else {
                    throw new ParseException("Illegal characters for this position: '" + sub + "'", i);
                }
            }
            if (eval != -1) {
                incr = 1;
            }
            this.addToSet(sval, eval, incr, type);
            return i + 3;
        }
        if (c == '?') {
            int val2;
            if (++i + 1 < s.length() && s.charAt(i) != ' ' && s.charAt(i + 1) != '\t') {
                throw new ParseException("Illegal character after '?': " + s.charAt(i), i);
            }
            if (type != 5 && type != 3) {
                throw new ParseException("'?' can only be specfied for Day-of-Month or Day-of-Week.", i);
            }
            if (type == 5 && !this.lastdayOfMonth && (val2 = ((Integer)this.daysOfMonth.last()).intValue()) == 98) {
                throw new ParseException("'?' can only be specfied for Day-of-Month -OR- Day-of-Week.", i);
            }
            this.addToSet(98, -1, 0, type);
            return i;
        }
        if (c == '*' || c == '/') {
            if (c == '*' && i + 1 >= s.length()) {
                this.addToSet(99, -1, incr, type);
                return i + 1;
            }
            if (c == '/' && (i + 1 >= s.length() || s.charAt(i + 1) == ' ' || s.charAt(i + 1) == '\t')) {
                throw new ParseException("'/' must be followed by an integer.", i);
            }
            if (c == '*') {
                ++i;
            }
            if ((c = s.charAt(i)) == '/') {
                if (++i >= s.length()) {
                    throw new ParseException("Unexpected end of string.", i);
                }
                incr = this.getNumericValue(s, i);
                ++i;
                if (incr > 10) {
                    ++i;
                }
                if (incr > 59 && (type == 0 || type == 1)) {
                    throw new ParseException("Increment > 60 : " + incr, i);
                }
                if (incr > 23 && type == 2) {
                    throw new ParseException("Increment > 24 : " + incr, i);
                }
                if (incr > 31 && type == 3) {
                    throw new ParseException("Increment > 31 : " + incr, i);
                }
                if (incr > 7 && type == 5) {
                    throw new ParseException("Increment > 7 : " + incr, i);
                }
                if (incr > 12 && type == 4) {
                    throw new ParseException("Increment > 12 : " + incr, i);
                }
            } else {
                incr = 1;
            }
            this.addToSet(99, -1, incr, type);
            return i;
        }
        if (c == 'L') {
            ++i;
            if (type == 3) {
                this.lastdayOfMonth = true;
            }
            if (type == 5) {
                this.addToSet(7, 7, 0, type);
            }
            if (type == 3 && s.length() > i && (c = s.charAt(i)) == 'W') {
                this.nearestWeekday = true;
                ++i;
            }
            return i;
        }
        if (c >= '0' && c <= '9') {
            val = Integer.parseInt(String.valueOf(c));
            if (++i < s.length()) {
                c = s.charAt(i);
                if (c >= '0' && c <= '9') {
                    ValueSet vs = this.getValue(val, s, i);
                    val = vs.value;
                    i = vs.pos;
                }
                i = this.checkNext(i, s, val, type);
                return i;
            }
        } else {
            throw new ParseException("Unexpected character: " + c, i);
        }
        this.addToSet(val, -1, -1, type);
        return i;
    }

    protected int checkNext(int pos, String s, int val, int type) throws ParseException {
        int end = -1;
        int i = pos;
        if (i >= s.length()) {
            this.addToSet(val, end, -1, type);
            return i;
        }
        char c = s.charAt(pos);
        if (c == 'L') {
            if (type != 5) {
                throw new ParseException("'L' option is not valid here. (pos=" + i + ")", i);
            }
            this.lastdayOfWeek = true;
            TreeSet set = this.getSet(type);
            set.add(new Integer(val));
            return ++i;
        }
        if (c == 'W') {
            if (type != 3) {
                throw new ParseException("'W' option is not valid here. (pos=" + i + ")", i);
            }
            this.nearestWeekday = true;
            TreeSet set = this.getSet(type);
            set.add(new Integer(val));
            return ++i;
        }
        if (c == '#') {
            if (type != 5) {
                throw new ParseException("'#' option is not valid here. (pos=" + i + ")", i);
            }
            ++i;
            try {
                this.nthdayOfWeek = Integer.parseInt(s.substring(i));
                if (this.nthdayOfWeek < 1 || this.nthdayOfWeek > 5) {
                    throw new Exception();
                }
            }
            catch (Exception e) {
                throw new ParseException("A numeric value between 1 and 5 must follow the '#' option", i);
            }
            TreeSet set = this.getSet(type);
            set.add(new Integer(val));
            return ++i;
        }
        if (c == 'C') {
            if (type == 5) {
                this.calendardayOfWeek = true;
            } else if (type == 3) {
                this.calendardayOfMonth = true;
            } else {
                throw new ParseException("'C' option is not valid here. (pos=" + i + ")", i);
            }
            TreeSet set = this.getSet(type);
            set.add(new Integer(val));
            return ++i;
        }
        if (c == '-') {
            int v;
            c = s.charAt(++i);
            end = v = Integer.parseInt(String.valueOf(c));
            if (++i >= s.length()) {
                this.addToSet(val, end, 1, type);
                return i;
            }
            c = s.charAt(i);
            if (c >= '0' && c <= '9') {
                int v1;
                ValueSet vs = this.getValue(v, s, i);
                end = v1 = vs.value;
                i = vs.pos;
            }
            if (i < s.length() && (c = s.charAt(i)) == '/') {
                c = s.charAt(++i);
                int v2 = Integer.parseInt(String.valueOf(c));
                if (++i >= s.length()) {
                    this.addToSet(val, end, v2, type);
                    return i;
                }
                c = s.charAt(i);
                if (c >= '0' && c <= '9') {
                    ValueSet vs = this.getValue(v2, s, i);
                    int v3 = vs.value;
                    this.addToSet(val, end, v3, type);
                    i = vs.pos;
                    return i;
                }
                this.addToSet(val, end, v2, type);
                return i;
            }
            this.addToSet(val, end, 1, type);
            return i;
        }
        if (c == '/') {
            c = s.charAt(++i);
            int v2 = Integer.parseInt(String.valueOf(c));
            if (++i >= s.length()) {
                this.addToSet(val, end, v2, type);
                return i;
            }
            c = s.charAt(i);
            if (c >= '0' && c <= '9') {
                ValueSet vs = this.getValue(v2, s, i);
                int v3 = vs.value;
                this.addToSet(val, end, v3, type);
                i = vs.pos;
                return i;
            }
            throw new ParseException("Unexpected character '" + c + "' after '/'", i);
        }
        this.addToSet(val, end, 0, type);
        return ++i;
    }

    public String getCronExpression() {
        return this.cronExpression;
    }

    public String getExpressionSummary() {
        StringBuffer buf = new StringBuffer();
        buf.append("seconds: ");
        buf.append(this.getExpressionSetSummary(this.seconds));
        buf.append("\n");
        buf.append("minutes: ");
        buf.append(this.getExpressionSetSummary(this.minutes));
        buf.append("\n");
        buf.append("hours: ");
        buf.append(this.getExpressionSetSummary(this.hours));
        buf.append("\n");
        buf.append("daysOfMonth: ");
        buf.append(this.getExpressionSetSummary(this.daysOfMonth));
        buf.append("\n");
        buf.append("months: ");
        buf.append(this.getExpressionSetSummary(this.months));
        buf.append("\n");
        buf.append("daysOfWeek: ");
        buf.append(this.getExpressionSetSummary(this.daysOfWeek));
        buf.append("\n");
        buf.append("lastdayOfWeek: ");
        buf.append(this.lastdayOfWeek);
        buf.append("\n");
        buf.append("nearestWeekday: ");
        buf.append(this.nearestWeekday);
        buf.append("\n");
        buf.append("NthDayOfWeek: ");
        buf.append(this.nthdayOfWeek);
        buf.append("\n");
        buf.append("lastdayOfMonth: ");
        buf.append(this.lastdayOfMonth);
        buf.append("\n");
        buf.append("calendardayOfWeek: ");
        buf.append(this.calendardayOfWeek);
        buf.append("\n");
        buf.append("calendardayOfMonth: ");
        buf.append(this.calendardayOfMonth);
        buf.append("\n");
        buf.append("years: ");
        buf.append(this.getExpressionSetSummary(this.years));
        buf.append("\n");
        return buf.toString();
    }

    protected String getExpressionSetSummary(Set set) {
        if (set.contains(NO_SPEC)) {
            return "?";
        }
        if (set.contains(ALL_SPEC)) {
            return "*";
        }
        StringBuffer buf = new StringBuffer();
        Iterator itr = set.iterator();
        boolean first = true;
        while (itr.hasNext()) {
            Integer iVal = (Integer)itr.next();
            String val = iVal.toString();
            if (!first) {
                buf.append(",");
            }
            buf.append(val);
            first = false;
        }
        return buf.toString();
    }

    protected String getExpressionSetSummary(ArrayList list) {
        if (list.contains(NO_SPEC)) {
            return "?";
        }
        if (list.contains(ALL_SPEC)) {
            return "*";
        }
        StringBuffer buf = new StringBuffer();
        Iterator itr = list.iterator();
        boolean first = true;
        while (itr.hasNext()) {
            Integer iVal = (Integer)itr.next();
            String val = iVal.toString();
            if (!first) {
                buf.append(",");
            }
            buf.append(val);
            first = false;
        }
        return buf.toString();
    }

    protected int skipWhiteSpace(int i, String s) {
        while (i < s.length() && (s.charAt(i) == ' ' || s.charAt(i) == '\t')) {
            ++i;
        }
        return i;
    }

    protected int findNextWhiteSpace(int i, String s) {
        while (i < s.length() && (s.charAt(i) != ' ' || s.charAt(i) != '\t')) {
            ++i;
        }
        return i;
    }

    protected void addToSet(int val, int end, int incr, int type) throws ParseException {
        TreeSet set = this.getSet(type);
        if (type == 0 || type == 1) {
            if ((val < 0 || val > 59 || end > 59) && val != 99) {
                throw new ParseException("Minute and Second values must be between 0 and 59", -1);
            }
        } else if (type == 2) {
            if ((val < 0 || val > 23 || end > 23) && val != 99) {
                throw new ParseException("Hour values must be between 0 and 23", -1);
            }
        } else if (type == 3) {
            if ((val < 1 || val > 31 || end > 31) && val != 99 && val != 98) {
                throw new ParseException("Day of month values must be between 1 and 31", -1);
            }
        } else if (type == 4) {
            if ((val < 1 || val > 12 || end > 12) && val != 99) {
                throw new ParseException("Month values must be between 1 and 12", -1);
            }
        } else if (type == 5 && (val == 0 || val > 7 || end > 7) && val != 99 && val != 98) {
            throw new ParseException("Day-of-Week values must be between 1 and 7", -1);
        }
        if ((incr == 0 || incr == -1) && val != 99) {
            if (val != -1) {
                set.add(new Integer(val));
            } else {
                set.add(NO_SPEC);
            }
            return;
        }
        int startAt = val;
        int stopAt = end;
        if (val == 99 && incr <= 0) {
            incr = 1;
            set.add(ALL_SPEC);
        }
        if (type == 0 || type == 1) {
            if (stopAt == -1) {
                stopAt = 59;
            }
            if (startAt == -1 || startAt == 99) {
                startAt = 0;
            }
        } else if (type == 2) {
            if (stopAt == -1) {
                stopAt = 23;
            }
            if (startAt == -1 || startAt == 99) {
                startAt = 0;
            }
        } else if (type == 3) {
            if (stopAt == -1) {
                stopAt = 31;
            }
            if (startAt == -1 || startAt == 99) {
                startAt = 1;
            }
        } else if (type == 4) {
            if (stopAt == -1) {
                stopAt = 12;
            }
            if (startAt == -1 || startAt == 99) {
                startAt = 1;
            }
        } else if (type == 5) {
            if (stopAt == -1) {
                stopAt = 7;
            }
            if (startAt == -1 || startAt == 99) {
                startAt = 1;
            }
        } else if (type == 6) {
            if (stopAt == -1) {
                stopAt = 2099;
            }
            if (startAt == -1 || startAt == 99) {
                startAt = 1970;
            }
        }
        for (int i = startAt; i <= stopAt; i += incr) {
            set.add(new Integer(i));
        }
    }

    protected TreeSet getSet(int type) {
        switch (type) {
            case 0: {
                return this.seconds;
            }
            case 1: {
                return this.minutes;
            }
            case 2: {
                return this.hours;
            }
            case 3: {
                return this.daysOfMonth;
            }
            case 4: {
                return this.months;
            }
            case 5: {
                return this.daysOfWeek;
            }
            case 6: {
                return this.years;
            }
        }
        return null;
    }

    protected ValueSet getValue(int v, String s, int i) {
        char c = s.charAt(i);
        String s1 = String.valueOf(v);
        while (c >= '0' && c <= '9') {
            s1 = s1 + c;
            if (++i >= s.length()) break;
            c = s.charAt(i);
        }
        ValueSet val = new ValueSet();
        val.pos = i < s.length() ? i : i + 1;
        val.value = Integer.parseInt(s1);
        return val;
    }

    protected int getNumericValue(String s, int i) {
        int endOfVal = this.findNextWhiteSpace(i, s);
        String val = s.substring(i, endOfVal);
        return Integer.parseInt(val);
    }

    protected int getMonthNumber(String s) {
        Integer integer = (Integer)monthMap.get(s);
        if (integer == null) {
            return -1;
        }
        return integer;
    }

    protected int getDayOfWeekNumber(String s) {
        Integer integer = (Integer)dayMap.get(s);
        if (integer == null) {
            return -1;
        }
        return integer;
    }

    protected Date getTime(int sc, int mn, int hr, int dayofmn, int mon) {
        try {
            Calendar cl = Calendar.getInstance(this.getTimeZone());
            if (hr >= 0 && hr <= 12) {
                cl.set(9, 0);
            }
            if (hr >= 13 && hr <= 23) {
                cl.set(9, 1);
            }
            cl.setLenient(false);
            if (sc != -1) {
                cl.set(13, sc);
            }
            if (mn != -1) {
                cl.set(12, mn);
            }
            if (hr != -1) {
                cl.set(11, hr);
            }
            if (dayofmn != -1) {
                cl.set(5, dayofmn);
            }
            if (mon != -1) {
                cl.set(2, mon);
            }
            return cl.getTime();
        }
        catch (Exception e) {
            return null;
        }
    }

    protected Date getTimeAfter(Date afterTime) {
        Calendar cl = Calendar.getInstance(this.getTimeZone());
        afterTime = new Date(afterTime.getTime() + 1000L);
        cl.setTime(afterTime);
        cl.set(14, 0);
        boolean gotOne = false;
        while (!gotOne) {
            boolean dayOfWSpec;
            SortedSet<Integer> st = null;
            int t = 0;
            int sec = cl.get(13);
            int min = cl.get(12);
            st = this.seconds.tailSet(new Integer(sec));
            if (st != null && st.size() != 0) {
                sec = st.first();
            } else {
                sec = (Integer)this.seconds.first();
                cl.set(12, ++min);
            }
            cl.set(13, sec);
            min = cl.get(12);
            int hr = cl.get(11);
            t = -1;
            st = this.minutes.tailSet(new Integer(min));
            if (st != null && st.size() != 0) {
                t = min;
                min = st.first();
            } else {
                min = (Integer)this.minutes.first();
                ++hr;
            }
            if (min != t) {
                cl.set(13, 0);
                cl.set(12, min);
                this.setCalendarHour(cl, hr);
                continue;
            }
            cl.set(12, min);
            hr = cl.get(11);
            int day = cl.get(5);
            t = -1;
            st = this.hours.tailSet(new Integer(hr));
            if (st != null && st.size() != 0) {
                t = hr;
                hr = st.first();
            } else {
                hr = (Integer)this.hours.first();
                ++day;
            }
            if (hr != t) {
                cl.set(13, 0);
                cl.set(12, 0);
                cl.set(5, day);
                this.setCalendarHour(cl, hr);
                continue;
            }
            cl.set(11, hr);
            day = cl.get(5);
            int mon = cl.get(2) + 1;
            t = -1;
            int tmon = mon;
            boolean dayOfMSpec = !this.daysOfMonth.contains(NO_SPEC);
            boolean bl = dayOfWSpec = !this.daysOfWeek.contains(NO_SPEC);
            if (dayOfMSpec && !dayOfWSpec) {
                int dow;
                int ldom;
                st = this.daysOfMonth.tailSet(new Integer(day));
                if (this.lastdayOfMonth) {
                    if (!this.nearestWeekday) {
                        t = day;
                        day = this.getLastDayOfMonth(mon, cl.get(1));
                    } else {
                        t = day;
                        day = this.getLastDayOfMonth(mon, cl.get(1));
                        Calendar tcal = Calendar.getInstance();
                        tcal.set(13, 0);
                        tcal.set(12, 0);
                        tcal.set(11, 0);
                        tcal.set(5, day);
                        tcal.set(2, mon - 1);
                        tcal.set(1, cl.get(1));
                        ldom = this.getLastDayOfMonth(mon, cl.get(1));
                        dow = tcal.get(7);
                        if (dow == 7 && day == 1) {
                            day += 2;
                        } else if (dow == 7) {
                            --day;
                        } else if (dow == 1 && day == ldom) {
                            day -= 2;
                        } else if (dow == 1) {
                            ++day;
                        }
                        tcal.set(13, sec);
                        tcal.set(12, min);
                        tcal.set(11, hr);
                        tcal.set(5, day);
                        tcal.set(2, mon - 1);
                        Date nTime = tcal.getTime();
                        if (nTime.before(afterTime)) {
                            day = 1;
                            ++mon;
                        }
                    }
                } else if (this.nearestWeekday) {
                    t = day;
                    day = (Integer)this.daysOfMonth.first();
                    Calendar tcal = Calendar.getInstance();
                    tcal.set(13, 0);
                    tcal.set(12, 0);
                    tcal.set(11, 0);
                    tcal.set(5, day);
                    tcal.set(2, mon - 1);
                    tcal.set(1, cl.get(1));
                    ldom = this.getLastDayOfMonth(mon, cl.get(1));
                    dow = tcal.get(7);
                    if (dow == 7 && day == 1) {
                        day += 2;
                    } else if (dow == 7) {
                        --day;
                    } else if (dow == 1 && day == ldom) {
                        day -= 2;
                    } else if (dow == 1) {
                        ++day;
                    }
                    tcal.set(13, sec);
                    tcal.set(12, min);
                    tcal.set(11, hr);
                    tcal.set(5, day);
                    tcal.set(2, mon - 1);
                    Date nTime = tcal.getTime();
                    if (nTime.before(afterTime)) {
                        day = (Integer)this.daysOfMonth.first();
                        ++mon;
                    }
                } else if (st != null && st.size() != 0) {
                    t = day;
                    day = st.first();
                } else {
                    day = (Integer)this.daysOfMonth.first();
                    ++mon;
                }
                if (day != t || mon != tmon) {
                    cl.set(13, 0);
                    cl.set(12, 0);
                    cl.set(11, 0);
                    cl.set(5, day);
                    cl.set(2, mon - 1);
                    continue;
                }
            } else if (dayOfWSpec && !dayOfMSpec) {
                int daysToAdd;
                int cDow;
                if (this.lastdayOfWeek) {
                    int lDay;
                    int dow = (Integer)this.daysOfWeek.first();
                    cDow = cl.get(7);
                    daysToAdd = 0;
                    if (cDow < dow) {
                        daysToAdd = dow - cDow;
                    }
                    if (cDow > dow) {
                        daysToAdd = dow + (7 - cDow);
                    }
                    if (day + daysToAdd > (lDay = this.getLastDayOfMonth(mon, cl.get(1)))) {
                        cl.set(13, 0);
                        cl.set(12, 0);
                        cl.set(11, 0);
                        cl.set(5, 1);
                        cl.set(2, mon);
                        continue;
                    }
                    while (day + daysToAdd + 7 <= lDay) {
                        daysToAdd += 7;
                    }
                    day += daysToAdd;
                    if (daysToAdd > 0) {
                        cl.set(13, 0);
                        cl.set(12, 0);
                        cl.set(11, 0);
                        cl.set(5, day);
                        cl.set(2, mon - 1);
                        continue;
                    }
                } else if (this.nthdayOfWeek != 0) {
                    int dow = (Integer)this.daysOfWeek.first();
                    cDow = cl.get(7);
                    daysToAdd = 0;
                    if (cDow < dow) {
                        daysToAdd = dow - cDow;
                    } else if (cDow > dow) {
                        daysToAdd = dow + (7 - cDow);
                    }
                    boolean dayShifted = false;
                    if (daysToAdd > 0) {
                        dayShifted = true;
                    }
                    int weekOfMonth = (day += daysToAdd) / 7;
                    if (day % 7 > 0) {
                        ++weekOfMonth;
                    }
                    if ((daysToAdd = (this.nthdayOfWeek - weekOfMonth) * 7) < 0 || (day += daysToAdd) > this.getLastDayOfMonth(mon, cl.get(1))) {
                        cl.set(13, 0);
                        cl.set(12, 0);
                        cl.set(11, 0);
                        cl.set(5, 1);
                        cl.set(2, mon);
                        continue;
                    }
                    if (daysToAdd > 0 || dayShifted) {
                        cl.set(13, 0);
                        cl.set(12, 0);
                        cl.set(11, 0);
                        cl.set(5, day);
                        cl.set(2, mon - 1);
                        continue;
                    }
                } else {
                    int lDay;
                    int cDow2 = cl.get(7);
                    int dow = (Integer)this.daysOfWeek.first();
                    st = this.daysOfWeek.tailSet(new Integer(cDow2));
                    if (st != null && st.size() > 0) {
                        dow = st.first();
                    }
                    daysToAdd = 0;
                    if (cDow2 < dow) {
                        daysToAdd = dow - cDow2;
                    }
                    if (cDow2 > dow) {
                        daysToAdd = dow + (7 - cDow2);
                    }
                    if (day + daysToAdd > (lDay = this.getLastDayOfMonth(mon, cl.get(1)))) {
                        cl.set(13, 0);
                        cl.set(12, 0);
                        cl.set(11, 0);
                        cl.set(5, 1);
                        cl.set(2, mon);
                        continue;
                    }
                    if (daysToAdd > 0) {
                        cl.set(13, 0);
                        cl.set(12, 0);
                        cl.set(11, 0);
                        cl.set(5, day + daysToAdd);
                        cl.set(2, mon - 1);
                        continue;
                    }
                }
            } else {
                throw new UnsupportedOperationException("Support for specifying both a day-of-week AND a day-of-month parameter is not implemented.");
            }
            cl.set(5, day);
            mon = cl.get(2) + 1;
            int year = cl.get(1);
            t = -1;
            if (year > 2099) {
                return null;
            }
            st = this.months.tailSet(new Integer(mon));
            if (st != null && st.size() != 0) {
                t = mon;
                mon = st.first();
            } else {
                mon = (Integer)this.months.first();
                ++year;
            }
            if (mon != t) {
                cl.set(13, 0);
                cl.set(12, 0);
                cl.set(11, 0);
                cl.set(5, 1);
                cl.set(2, mon - 1);
                cl.set(1, year);
                continue;
            }
            cl.set(2, mon - 1);
            year = cl.get(1);
            t = -1;
            st = this.years.tailSet(new Integer(year));
            if (st == null || st.size() == 0) {
                return null;
            }
            t = year;
            year = st.first();
            if (year != t) {
                cl.set(13, 0);
                cl.set(12, 0);
                cl.set(11, 0);
                cl.set(5, 1);
                cl.set(2, 0);
                cl.set(1, year);
                continue;
            }
            cl.set(1, year);
            gotOne = true;
        }
        return cl.getTime();
    }

    protected void setCalendarHour(Calendar cal, int hour) {
        cal.set(11, hour);
        if (cal.get(11) != hour && hour != 24) {
            cal.set(11, hour + 1);
        }
    }

    protected Date getTimeBefore(Date endTime) {
        return null;
    }

    protected boolean isLeapYear(int year) {
        return year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
    }

    protected int getLastDayOfMonth(int monthNum, int year) {
        switch (monthNum) {
            case 1: {
                return 31;
            }
            case 2: {
                return this.isLeapYear(year) ? 29 : 28;
            }
            case 3: {
                return 31;
            }
            case 4: {
                return 30;
            }
            case 5: {
                return 31;
            }
            case 6: {
                return 30;
            }
            case 7: {
                return 31;
            }
            case 8: {
                return 31;
            }
            case 9: {
                return 30;
            }
            case 10: {
                return 31;
            }
            case 11: {
                return 30;
            }
            case 12: {
                return 31;
            }
        }
        throw new IllegalArgumentException("Illegal month number: " + monthNum);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        try {
            this.buildExpression(this.cronExpression);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Object clone() {
        CronExpression copy = null;
        try {
            copy = new CronExpression(this.getCronExpression());
            copy.setTimeZone(this.getTimeZone());
        }
        catch (ParseException ex) {
            throw new IncompatibleClassChangeError("Not Cloneable.");
        }
        return copy;
    }

    static {
        monthMap.put("JAN", new Integer(0));
        monthMap.put("FEB", new Integer(1));
        monthMap.put("MAR", new Integer(2));
        monthMap.put("APR", new Integer(3));
        monthMap.put("MAY", new Integer(4));
        monthMap.put("JUN", new Integer(5));
        monthMap.put("JUL", new Integer(6));
        monthMap.put("AUG", new Integer(7));
        monthMap.put("SEP", new Integer(8));
        monthMap.put("OCT", new Integer(9));
        monthMap.put("NOV", new Integer(10));
        monthMap.put("DEC", new Integer(11));
        dayMap.put("SUN", new Integer(1));
        dayMap.put("MON", new Integer(2));
        dayMap.put("TUE", new Integer(3));
        dayMap.put("WED", new Integer(4));
        dayMap.put("THU", new Integer(5));
        dayMap.put("FRI", new Integer(6));
        dayMap.put("SAT", new Integer(7));
    }
}

