/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.annotations.wb;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CompositeKey<T, U> {
    private KeyRef<T, U> weakPart;
    private U[] rest;

    protected CompositeKey(T weakPart, U[] rest) {
        if (weakPart == null) {
            throw new IllegalArgumentException("Null weak part.");
        }
        if (rest == null) {
            throw new IllegalArgumentException("Null rest");
        }
        this.weakPart = new KeyRef(this, weakPart, this.getReferenceQueue());
        this.rest = rest;
    }

    protected abstract ReferenceQueue<T> getReferenceQueue();

    protected static int safeWeakHaskHode(WeakReference wr) {
        Object weak = wr.get();
        return weak != null ? weak.hashCode() : 0;
    }

    protected int getWeakPartHashCode() {
        return CompositeKey.safeWeakHaskHode(this.weakPart);
    }

    protected int getRestHashCode() {
        int hash = 0;
        for (U u : this.rest) {
            hash += 3 * u.hashCode();
        }
        return hash;
    }

    public int hashCode() {
        return this.getWeakPartHashCode() + this.getRestHashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CompositeKey)) {
            return false;
        }
        CompositeKey ck = (CompositeKey)obj;
        Object wp = this.weakPart.get();
        Object otherWP = ck.weakPart.get();
        if (wp == null || otherWP == null) {
            this.cleanKeyRefs();
            return false;
        }
        if (!wp.equals(otherWP)) {
            return false;
        }
        if (this.rest.length != ck.rest.length) {
            return false;
        }
        for (U u : this.rest) {
            boolean match = false;
            for (U ou : ck.rest) {
                if (!u.equals(ou)) continue;
                match = true;
                break;
            }
            if (match) continue;
            return false;
        }
        return true;
    }

    protected boolean shouldCleanKeyRefs() {
        return true;
    }

    private void cleanKeyRefs() {
        Reference<T> ref;
        ReferenceQueue<T> queue = this.getReferenceQueue();
        while ((ref = queue.poll()) != null) {
            ((KeyRef)ref).nullifyKey();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class KeyRef<T, U>
    extends WeakReference<T> {
        private CompositeKey<T, U> key;

        private KeyRef(CompositeKey<T, U> key, T referent, ReferenceQueue<? super T> q) {
            super(referent, q);
            this.key = key;
        }

        public CompositeKey<T, U> getKey() {
            return this.key;
        }

        public void nullifyKey() {
            this.key = null;
        }
    }
}

