/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.metadata.SimpleMetaData;
import org.jboss.aop.metadata.ThreadMetaData;
import org.jboss.logging.Logger;

public abstract class EJBInvocation
implements Invocation {
    private static final Logger log = Logger.getLogger(EJBInvocation.class);
    protected transient Interceptor[] interceptors;
    protected long methodHash;
    protected transient int currentInterceptor = 0;
    protected transient Method method;
    protected Object[] arguments;
    protected SimpleMetaData metadata = null;
    protected transient Map responseContextInfo = null;

    protected EJBInvocation(Method method, long methodHash, Object[] arguments, Interceptor[] interceptors) {
        this.method = method;
        this.methodHash = methodHash;
        this.arguments = arguments;
        this.interceptors = interceptors;
    }

    protected EJBInvocation() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeNext() throws Throwable {
        if (this.currentInterceptor < this.interceptors.length) {
            try {
                Object object = this.interceptors[this.currentInterceptor++].invoke((Invocation)this);
                return object;
            }
            finally {
                --this.currentInterceptor;
            }
        }
        try {
            return this.method.invoke(this.getTargetObject(), this.getArguments());
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    public Method getMethod() {
        return this.method;
    }

    public long getMethodHash() {
        return this.methodHash;
    }

    public Interceptor[] getInterceptors() {
        return this.interceptors;
    }

    public void setInterceptors(Interceptor[] interceptors) {
        this.interceptors = interceptors;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public void setArguments(Object[] args) {
        this.arguments = args;
    }

    public Object getMetaData(Object key, Object attr) {
        Object value = null;
        if (this.metadata != null) {
            value = this.metadata.getMetaData(key, attr);
        }
        if (value != null) {
            return value;
        }
        value = ThreadMetaData.instance().getMetaData(key, attr);
        return value;
    }

    public Map getResponseContextInfo() {
        return this.responseContextInfo;
    }

    public void setResponseContextInfo(Map responseContextInfo) {
        this.responseContextInfo = responseContextInfo;
    }

    public void addResponseAttachment(Object key, Object val) {
        if (this.responseContextInfo == null) {
            this.responseContextInfo = new HashMap();
        }
        this.responseContextInfo.put(key, val);
    }

    public Object getResponseAttachment(Object key) {
        if (this.responseContextInfo == null) {
            return null;
        }
        return this.responseContextInfo.get(key);
    }

    public SimpleMetaData getMetaData() {
        if (this.metadata == null) {
            this.metadata = new SimpleMetaData();
        }
        return this.metadata;
    }

    public void setMetaData(SimpleMetaData data) {
        this.metadata = data;
    }

    public Object invokeNext(Interceptor[] newInterceptors) throws Throwable {
        throw new RuntimeException("NOT IMPLEMENTED");
    }
}

