/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.connectionmanager;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Set;
import javax.management.Notification;
import javax.management.ObjectName;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterAssociation;
import javax.security.auth.Subject;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.logging.Logger;
import org.jboss.metadata.MetaData;
import org.jboss.resource.connectionmanager.RARDeploymentMBean;
import org.jboss.resource.deployment.ConfigProperty;
import org.jboss.resource.deployment.ConfigPropertyHandler;
import org.jboss.resource.metadata.ConfigPropertyMetaData;
import org.jboss.resource.metadata.ConnectionDefinitionMetaData;
import org.jboss.resource.metadata.ConnectorMetaData;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.util.Classes;
import org.jboss.util.NestedRuntimeException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RARDeployment
extends ServiceMBeanSupport
implements RARDeploymentMBean,
ManagedConnectionFactory {
    static final long serialVersionUID = -294341806721616790L;
    public static final String MCF_ATTRIBUTE_CHANGED_NOTIFICATION = "jboss.mcfattributechangednotification";
    private Logger log = Logger.getLogger(this.getClass());
    private ObjectName oldRarDeployment;
    private String rarName;
    private String connectionDefinition;
    private String vendorName;
    private String specVersion;
    private String eisType;
    private String version;
    private String managedConnectionFactoryClass;
    private String connectionFactoryInterface;
    private String connectionFactoryImplClass;
    private String connectionInterface;
    private String connectionImplClass;
    private String transactionSupport;
    private Element managedConnectionFactoryProperties;
    private String authenticationMechanismType;
    private String credentialInterface;
    private boolean reauthenticationSupport;
    private Class mcfClass;
    private ManagedConnectionFactory mcf;
    private ConfigPropertyHandler configPropertyHandler;

    @Override
    public ObjectName getOldRarDeployment() {
        return this.oldRarDeployment;
    }

    @Override
    public void setOldRarDeployment(ObjectName oldRarDeployment) {
        this.oldRarDeployment = oldRarDeployment;
    }

    @Override
    public String getRARName() {
        return this.rarName;
    }

    @Override
    public void setRARName(String rarName) {
        this.rarName = rarName;
    }

    @Override
    public String getConnectionDefinition() {
        return this.connectionDefinition;
    }

    @Override
    public void setConnectionDefinition(String connectionDefinition) {
        this.connectionDefinition = connectionDefinition;
    }

    @Override
    public String getVendorName() {
        return this.vendorName;
    }

    @Override
    public void setVendorName(String vendorName) {
        this.vendorName = vendorName;
    }

    @Override
    public String getSpecVersion() {
        return this.specVersion;
    }

    @Override
    public void setSpecVersion(String specVersion) {
        this.specVersion = specVersion;
    }

    @Override
    public String getEisType() {
        return this.eisType;
    }

    @Override
    public void setEisType(String eisType) {
        this.eisType = eisType;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public String getManagedConnectionFactoryClass() {
        return this.managedConnectionFactoryClass;
    }

    @Override
    public void setManagedConnectionFactoryClass(String managedConnectionFactoryClass) {
        this.managedConnectionFactoryClass = managedConnectionFactoryClass;
    }

    @Override
    public String getConnectionFactoryInterface() {
        return this.connectionFactoryInterface;
    }

    @Override
    public void setConnectionFactoryInterface(String connectionFactoryInterface) {
        this.connectionFactoryInterface = connectionFactoryInterface;
    }

    @Override
    public String getConnectionFactoryImplClass() {
        return this.connectionFactoryImplClass;
    }

    @Override
    public void setConnectionFactoryImplClass(String connectionFactoryImplClass) {
        this.connectionFactoryImplClass = connectionFactoryImplClass;
    }

    @Override
    public String getConnectionInterface() {
        return this.connectionInterface;
    }

    @Override
    public void setConnectionInterface(String connectionInterface) {
        this.connectionInterface = connectionInterface;
    }

    @Override
    public String getConnectionImplClass() {
        return this.connectionImplClass;
    }

    @Override
    public void setConnectionImplClass(String connectionImplClass) {
        this.connectionImplClass = connectionImplClass;
    }

    @Override
    public String getTransactionSupport() {
        return this.transactionSupport;
    }

    @Override
    public void setTransactionSupport(String transactionSupport) {
        this.transactionSupport = transactionSupport;
    }

    @Override
    public Element getManagedConnectionFactoryProperties() {
        return this.managedConnectionFactoryProperties;
    }

    @Override
    public void setManagedConnectionFactoryProperties(Element managedConnectionFactoryProperties) {
        this.managedConnectionFactoryProperties = managedConnectionFactoryProperties;
    }

    @Override
    public String getAuthenticationMechanismType() {
        return this.authenticationMechanismType;
    }

    @Override
    public void setAuthenticationMechanismType(String authenticationMechanismType) {
        this.authenticationMechanismType = authenticationMechanismType;
    }

    @Override
    public String getCredentialInterface() {
        return this.credentialInterface;
    }

    @Override
    public void setCredentialInterface(String credentialInterface) {
        this.credentialInterface = credentialInterface;
    }

    @Override
    public boolean isReauthenticationSupport() {
        return this.reauthenticationSupport;
    }

    @Override
    public void setReauthenticationSupport(boolean reauthenticationSupport) {
        this.reauthenticationSupport = reauthenticationSupport;
    }

    @Override
    public ManagedConnectionFactory getMcfInstance() {
        return this.mcf;
    }

    protected void startService() throws Exception {
        if (this.mcf != null) {
            throw new DeploymentException("Stop the RARDeployment before restarting it");
        }
        ConnectorMetaData cmd = null;
        ConnectionDefinitionMetaData cdmd = null;
        ResourceAdapter resourceAdapter = null;
        if (this.oldRarDeployment != null) {
            try {
                resourceAdapter = (ResourceAdapter)this.getServer().getAttribute(this.oldRarDeployment, "ResourceAdapter");
                cmd = (ConnectorMetaData)this.getServer().getAttribute(this.oldRarDeployment, "MetaData");
                cdmd = cmd.getConnectionDefinition(this.connectionDefinition);
                if (cdmd == null) {
                    throw new DeploymentException("ConnectionDefinition '" + this.connectionDefinition + "' not found in rar '" + this.rarName + "'");
                }
                this.setManagedConnectionFactoryClass(cdmd.getManagedConnectionFactoryClass());
                this.setReauthenticationSupport(cmd.getReauthenticationSupport());
            }
            catch (Exception e) {
                throw new DeploymentException("couldn't get oldRarDeployment! " + this.oldRarDeployment, (Throwable)e);
            }
        }
        try {
            this.mcfClass = Thread.currentThread().getContextClassLoader().loadClass(this.managedConnectionFactoryClass);
        }
        catch (ClassNotFoundException cnfe) {
            this.log.error((Object)("Could not find ManagedConnectionFactory class: " + this.managedConnectionFactoryClass), (Throwable)cnfe);
            throw new DeploymentException("Could not find ManagedConnectionFactory class: " + this.managedConnectionFactoryClass);
        }
        try {
            this.mcf = (ManagedConnectionFactory)this.mcfClass.newInstance();
        }
        catch (Exception e) {
            this.log.error((Object)("Could not instantiate ManagedConnectionFactory: " + this.managedConnectionFactoryClass), (Throwable)e);
            throw new DeploymentException("Could not instantiate ManagedConnectionFactory: " + this.managedConnectionFactoryClass);
        }
        if (cmd != null) {
            this.setMcfProperties(cmd.getProperties(), false);
            this.setMcfProperties(cdmd.getProperties(), true);
        }
        this.setMcfProperties(this.managedConnectionFactoryProperties);
        if (resourceAdapter != null && this.mcf instanceof ResourceAdapterAssociation) {
            ResourceAdapterAssociation raa = (ResourceAdapterAssociation)this.mcf;
            raa.setResourceAdapter(resourceAdapter);
        }
    }

    protected void stopService() {
        this.mcf = null;
        this.mcfClass = null;
    }

    @Override
    public void setManagedConnectionFactoryAttribute(String name, Class clazz, Object value) {
        this.setManagedConnectionFactoryAttribute(name, clazz, value, false);
    }

    protected void setManagedConnectionFactoryAttribute(String name, Class clazz, Object value, boolean mustExist) {
        try {
            this.getConfigPropertyHandler().handle(new ConfigProperty(name, clazz, value), mustExist);
        }
        catch (Exception e) {
            String error = "Unable to set property '" + name + "' " + "on object '" + this.mcf + "'";
            if (e instanceof InvocationTargetException) {
                throw new NestedRuntimeException(error, ((InvocationTargetException)e).getCause());
            }
            throw new NestedRuntimeException(error, (Throwable)e);
        }
        this.sendNotification(new Notification(MCF_ATTRIBUTE_CHANGED_NOTIFICATION, this.getServiceName(), this.getNextNotificationSequenceNumber()));
    }

    @Override
    public Object getManagedConnectionFactoryAttribute(String name) {
        Method getter;
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Null or empty attribute name " + name);
        }
        String getterName = "get" + Character.toUpperCase(name.charAt(0));
        if (name.length() > 1) {
            getterName = getterName.concat(name.substring(1));
        }
        try {
            getter = this.mcfClass.getMethod(getterName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            String msg = "The class '" + this.mcfClass + "' has no getter(" + getterName + ") for config property '" + name + "'";
            this.log.debug((Object)msg, (Throwable)e);
            throw new IllegalArgumentException(msg);
        }
        try {
            Object value = getter.invoke((Object)this.mcf, new Object[0]);
            this.log.debug((Object)("get property " + name + ": value " + value));
            return value;
        }
        catch (Exception e) {
            String error = "Unable to invoke getter method '" + getter + "' " + "on object '" + this.mcf + "'";
            this.log.debug((Object)error, (Throwable)e);
            if (e instanceof InvocationTargetException) {
                throw new NestedRuntimeException(error, ((InvocationTargetException)e).getCause());
            }
            throw new NestedRuntimeException(error, (Throwable)e);
        }
    }

    protected void setMcfProperties(Collection properties, boolean mustExist) throws DeploymentException {
        for (ConfigPropertyMetaData cpmd : properties) {
            String name = cpmd.getName();
            String value = cpmd.getValue();
            try {
                this.getConfigPropertyHandler().handle(cpmd, mustExist);
            }
            catch (Exception e) {
                String error = "Unable to set property '" + name + "' " + "on object '" + this.mcf + "'";
                if (e instanceof InvocationTargetException) {
                    throw new NestedRuntimeException(error, ((InvocationTargetException)e).getCause());
                }
                throw new NestedRuntimeException(error, (Throwable)e);
            }
            this.sendNotification(new Notification(MCF_ATTRIBUTE_CHANGED_NOTIFICATION, this.getServiceName(), this.getNextNotificationSequenceNumber()));
        }
    }

    protected void setMcfProperties(Element mcfProps) throws DeploymentException {
        if (mcfProps == null) {
            return;
        }
        NodeList props = mcfProps.getChildNodes();
        for (int i = 0; i < props.getLength(); ++i) {
            PropertyEditor pe;
            Class<?> clazz;
            Element prop;
            if (props.item(i).getNodeType() != 1 || !(prop = (Element)props.item(i)).getTagName().equals("config-property")) continue;
            String name = null;
            String type = null;
            String value = null;
            if (prop.hasAttribute("name")) {
                name = prop.getAttribute("name");
                type = prop.getAttribute("type");
                value = MetaData.getElementContent((Element)prop, null, (boolean)false);
            } else {
                name = MetaData.getElementContent((Element)MetaData.getUniqueChild((Element)prop, (String)"config-property-name"));
                type = MetaData.getElementContent((Element)MetaData.getUniqueChild((Element)prop, (String)"config-property-type"));
                value = MetaData.getElementContent((Element)MetaData.getOptionalChild((Element)prop, (String)"config-property-value"), null, (boolean)false);
            }
            if (name == null || name.length() == 0 || value == null || value.length() == 0) {
                this.log.debug((Object)("Not setting config property '" + name + "'"));
                continue;
            }
            if (type == null || type.length() == 0) {
                type = "java.lang.String";
            }
            if ((clazz = Classes.getPrimitiveTypeForName((String)type)) == null) {
                try {
                    clazz = Thread.currentThread().getContextClassLoader().loadClass(type);
                }
                catch (ClassNotFoundException cnfe) {
                    this.log.warn((Object)("Unable to find class '" + type + "' for " + "property '" + name + "' - skipping property."));
                    continue;
                }
            }
            if ((pe = PropertyEditorManager.findEditor(clazz)) == null) {
                this.log.warn((Object)("Unable to find a PropertyEditor for class '" + clazz + "' of property '" + name + "' - " + "skipping property"));
                continue;
            }
            this.log.debug((Object)("setting property: " + name + " to value " + value));
            try {
                pe.setAsText(value);
            }
            catch (IllegalArgumentException iae) {
                this.log.warn((Object)("Value '" + value + "' is not valid for property '" + name + "' of class '" + clazz + "' - skipping " + "property"));
                continue;
            }
            Object v = pe.getValue();
            this.setManagedConnectionFactoryAttribute(name, clazz, v);
        }
    }

    public Object createConnectionFactory() throws ResourceException {
        return this.mcf.createConnectionFactory();
    }

    public Object createConnectionFactory(ConnectionManager cxManager) throws ResourceException {
        return this.mcf.createConnectionFactory(cxManager);
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        return this.mcf.createManagedConnection(subject, cxRequestInfo);
    }

    public boolean equals(Object other) {
        return this.mcf.equals(other);
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.mcf.getLogWriter();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getClass().getName());
        buffer.append('@');
        buffer.append(Integer.toHexString(System.identityHashCode(this)));
        return buffer.toString();
    }

    public int hashCode() {
        return this.mcf.hashCode();
    }

    public ManagedConnection matchManagedConnections(Set connectionSet, Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        return this.mcf.matchManagedConnections(connectionSet, subject, cxRequestInfo);
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
        this.mcf.setLogWriter(out);
    }

    protected ConfigPropertyHandler getConfigPropertyHandler() {
        if (this.configPropertyHandler == null) {
            this.configPropertyHandler = new ConfigPropertyHandler(this.mcf, this.mcfClass);
        }
        return this.configPropertyHandler;
    }
}

