/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.service;

import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.FetchedData;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.JsLexer;
import com.google.caja.lexer.JsTokenQueue;
import com.google.caja.lexer.ParseException;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.Parser;
import com.google.caja.parser.quasiliteral.InnocentCodeRewriter;
import com.google.caja.parser.quasiliteral.Rewriter;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.MessageTypeInt;
import com.google.caja.service.CajolingService;
import com.google.caja.service.ContentHandler;
import com.google.caja.service.ContentHandlerArgs;
import com.google.caja.service.ContentTypeCheck;
import com.google.caja.service.ServiceMessageType;
import com.google.caja.service.UnsupportedContentTypeException;
import com.google.caja.util.Charsets;
import com.google.caja.util.Pair;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InnocentHandler
implements ContentHandler {
    @Override
    public boolean canHandle(URI uri, CajolingService.Transform transform, List<CajolingService.Directive> directives, String inputContentType, String outputContentType, ContentTypeCheck checker) {
        return CajolingService.Transform.INNOCENT.equals((Object)transform) && checker.check("text/javascript", inputContentType) && checker.check(outputContentType, "text/javascript");
    }

    @Override
    public Pair<String, String> apply(URI uri, CajolingService.Transform transform, List<CajolingService.Directive> directives, ContentHandlerArgs args, String inputContentType, String outputContentType, ContentTypeCheck checker, FetchedData input, OutputStream response, MessageQueue mq) throws UnsupportedContentTypeException {
        if (!CajolingService.Transform.INNOCENT.equals((Object)transform)) {
            return null;
        }
        try {
            OutputStreamWriter writer = new OutputStreamWriter(response, Charsets.UTF_8.name());
            this.innocentJs(uri, input.getTextualContent(), writer, mq);
            writer.flush();
        }
        catch (IOException e) {
            throw new UnsupportedContentTypeException();
        }
        return Pair.pair("text/javascript", Charsets.UTF_8.name());
    }

    private void innocentJs(URI inputUri, CharProducer cp, Appendable output, MessageQueue mq) {
        InputSource is = new InputSource(inputUri);
        try {
            JsTokenQueue tq = new JsTokenQueue(new JsLexer(cp), is);
            Block input = new Parser(tq, mq).parse();
            tq.expectEmpty();
            InnocentCodeRewriter rw = new InnocentCodeRewriter(mq, false);
            output.append(Rewriter.render(rw.expand(input)));
        }
        catch (ParseException e) {
            e.toMessageQueue(mq);
        }
        catch (IOException e) {
            mq.addMessage((MessageTypeInt)ServiceMessageType.IO_ERROR, MessagePart.Factory.valueOf(e.getMessage()));
        }
    }
}

