/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.hibernate.MappingException;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.ConditionalParenthesisFunction;
import org.hibernate.dialect.function.ConvertFunction;
import org.hibernate.dialect.function.NoArgSQLFunction;
import org.hibernate.dialect.function.NvlFunction;
import org.hibernate.dialect.function.SQLFunctionTemplate;
import org.hibernate.dialect.function.StandardJDBCEscapeFunction;
import org.hibernate.dialect.function.StandardSQLFunction;
import org.hibernate.dialect.function.VarArgsSQLFunction;
import org.hibernate.dialect.lock.LockingStrategy;
import org.hibernate.dialect.lock.SelectLockingStrategy;
import org.hibernate.dialect.lock.UpdateLockingStrategy;
import org.hibernate.exception.CacheSQLStateConverter;
import org.hibernate.exception.SQLExceptionConverter;
import org.hibernate.exception.TemplatedViolatedConstraintNameExtracter;
import org.hibernate.exception.ViolatedConstraintNameExtracter;
import org.hibernate.id.IdentityGenerator;
import org.hibernate.persister.entity.Lockable;
import org.hibernate.sql.CacheJoinFragment;
import org.hibernate.sql.JoinFragment;
import org.hibernate.util.StringHelper;

public class Cache71Dialect
extends Dialect {
    public static final ViolatedConstraintNameExtracter EXTRACTER = new TemplatedViolatedConstraintNameExtracter(){

        @Override
        public String extractConstraintName(SQLException sqle) {
            return this.extractUsingTemplate("constraint (", ") violated", sqle.getMessage());
        }
    };

    public Cache71Dialect() {
        this.commonRegistration();
        this.register71Functions();
    }

    protected final void commonRegistration() {
        this.registerColumnType(-2, "varbinary($1)");
        this.registerColumnType(-5, "BigInt");
        this.registerColumnType(-7, "bit");
        this.registerColumnType(1, "char(1)");
        this.registerColumnType(91, "date");
        this.registerColumnType(3, "decimal");
        this.registerColumnType(8, "double");
        this.registerColumnType(6, "float");
        this.registerColumnType(4, "integer");
        this.registerColumnType(-4, "longvarbinary");
        this.registerColumnType(-1, "longvarchar");
        this.registerColumnType(2, "numeric($p,$s)");
        this.registerColumnType(7, "real");
        this.registerColumnType(5, "smallint");
        this.registerColumnType(93, "timestamp");
        this.registerColumnType(92, "time");
        this.registerColumnType(-6, "tinyint");
        this.registerColumnType(-3, "longvarbinary");
        this.registerColumnType(12, "varchar($l)");
        this.registerColumnType(2004, "longvarbinary");
        this.registerColumnType(2005, "longvarchar");
        this.getDefaultProperties().setProperty("hibernate.jdbc.use_streams_for_binary", "false");
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", "15");
        this.getDefaultProperties().setProperty("hibernate.use_sql_comments", "false");
        this.registerFunction("abs", new StandardSQLFunction("abs"));
        this.registerFunction("acos", new StandardJDBCEscapeFunction("acos", Hibernate.DOUBLE));
        this.registerFunction("%alphaup", new StandardSQLFunction("%alphaup", Hibernate.STRING));
        this.registerFunction("ascii", new StandardSQLFunction("ascii", Hibernate.STRING));
        this.registerFunction("asin", new StandardJDBCEscapeFunction("asin", Hibernate.DOUBLE));
        this.registerFunction("atan", new StandardJDBCEscapeFunction("atan", Hibernate.DOUBLE));
        this.registerFunction("bit_length", new SQLFunctionTemplate(Hibernate.INTEGER, "($length(?1)*8)"));
        this.registerFunction("ceiling", new StandardSQLFunction("ceiling", Hibernate.INTEGER));
        this.registerFunction("char", new StandardJDBCEscapeFunction("char", Hibernate.CHARACTER));
        this.registerFunction("character_length", new StandardSQLFunction("character_length", Hibernate.INTEGER));
        this.registerFunction("char_length", new StandardSQLFunction("char_length", Hibernate.INTEGER));
        this.registerFunction("cos", new StandardJDBCEscapeFunction("cos", Hibernate.DOUBLE));
        this.registerFunction("cot", new StandardJDBCEscapeFunction("cot", Hibernate.DOUBLE));
        this.registerFunction("coalesce", new VarArgsSQLFunction("coalesce(", ",", ")"));
        this.registerFunction("concat", new VarArgsSQLFunction(Hibernate.STRING, "", "||", ""));
        this.registerFunction("convert", new ConvertFunction());
        this.registerFunction("curdate", new StandardJDBCEscapeFunction("curdate", Hibernate.DATE));
        this.registerFunction("current_date", new NoArgSQLFunction("current_date", Hibernate.DATE, false));
        this.registerFunction("current_time", new NoArgSQLFunction("current_time", Hibernate.TIME, false));
        this.registerFunction("current_timestamp", new ConditionalParenthesisFunction("current_timestamp", Hibernate.TIMESTAMP));
        this.registerFunction("curtime", new StandardJDBCEscapeFunction("curtime", Hibernate.TIME));
        this.registerFunction("database", new StandardJDBCEscapeFunction("database", Hibernate.STRING));
        this.registerFunction("dateadd", new VarArgsSQLFunction(Hibernate.TIMESTAMP, "dateadd(", ",", ")"));
        this.registerFunction("datediff", new VarArgsSQLFunction(Hibernate.INTEGER, "datediff(", ",", ")"));
        this.registerFunction("datename", new VarArgsSQLFunction(Hibernate.STRING, "datename(", ",", ")"));
        this.registerFunction("datepart", new VarArgsSQLFunction(Hibernate.INTEGER, "datepart(", ",", ")"));
        this.registerFunction("day", new StandardSQLFunction("day", Hibernate.INTEGER));
        this.registerFunction("dayname", new StandardJDBCEscapeFunction("dayname", Hibernate.STRING));
        this.registerFunction("dayofmonth", new StandardJDBCEscapeFunction("dayofmonth", Hibernate.INTEGER));
        this.registerFunction("dayofweek", new StandardJDBCEscapeFunction("dayofweek", Hibernate.INTEGER));
        this.registerFunction("dayofyear", new StandardJDBCEscapeFunction("dayofyear", Hibernate.INTEGER));
        this.registerFunction("%exact", new StandardSQLFunction("%exact", Hibernate.STRING));
        this.registerFunction("exp", new StandardJDBCEscapeFunction("exp", Hibernate.DOUBLE));
        this.registerFunction("%external", new StandardSQLFunction("%external", Hibernate.STRING));
        this.registerFunction("$extract", new VarArgsSQLFunction(Hibernate.INTEGER, "$extract(", ",", ")"));
        this.registerFunction("$find", new VarArgsSQLFunction(Hibernate.INTEGER, "$find(", ",", ")"));
        this.registerFunction("floor", new StandardSQLFunction("floor", Hibernate.INTEGER));
        this.registerFunction("getdate", new StandardSQLFunction("getdate", Hibernate.TIMESTAMP));
        this.registerFunction("hour", new StandardJDBCEscapeFunction("hour", Hibernate.INTEGER));
        this.registerFunction("ifnull", new VarArgsSQLFunction("ifnull(", ",", ")"));
        this.registerFunction("%internal", new StandardSQLFunction("%internal"));
        this.registerFunction("isnull", new VarArgsSQLFunction("isnull(", ",", ")"));
        this.registerFunction("isnumeric", new StandardSQLFunction("isnumeric", Hibernate.INTEGER));
        this.registerFunction("lcase", new StandardJDBCEscapeFunction("lcase", Hibernate.STRING));
        this.registerFunction("left", new StandardJDBCEscapeFunction("left", Hibernate.STRING));
        this.registerFunction("len", new StandardSQLFunction("len", Hibernate.INTEGER));
        this.registerFunction("length", new StandardSQLFunction("length", Hibernate.INTEGER));
        this.registerFunction("$length", new VarArgsSQLFunction("$length(", ",", ")"));
        this.registerFunction("$list", new VarArgsSQLFunction("$list(", ",", ")"));
        this.registerFunction("$listdata", new VarArgsSQLFunction("$listdata(", ",", ")"));
        this.registerFunction("$listfind", new VarArgsSQLFunction("$listfind(", ",", ")"));
        this.registerFunction("$listget", new VarArgsSQLFunction("$listget(", ",", ")"));
        this.registerFunction("$listlength", new StandardSQLFunction("$listlength", Hibernate.INTEGER));
        this.registerFunction("locate", new StandardSQLFunction("$FIND", Hibernate.INTEGER));
        this.registerFunction("log", new StandardJDBCEscapeFunction("log", Hibernate.DOUBLE));
        this.registerFunction("log10", new StandardJDBCEscapeFunction("log", Hibernate.DOUBLE));
        this.registerFunction("lower", new StandardSQLFunction("lower"));
        this.registerFunction("ltrim", new StandardSQLFunction("ltrim"));
        this.registerFunction("minute", new StandardJDBCEscapeFunction("minute", Hibernate.INTEGER));
        this.registerFunction("mod", new StandardJDBCEscapeFunction("mod", Hibernate.DOUBLE));
        this.registerFunction("month", new StandardJDBCEscapeFunction("month", Hibernate.INTEGER));
        this.registerFunction("monthname", new StandardJDBCEscapeFunction("monthname", Hibernate.STRING));
        this.registerFunction("now", new StandardJDBCEscapeFunction("monthname", Hibernate.TIMESTAMP));
        this.registerFunction("nullif", new VarArgsSQLFunction("nullif(", ",", ")"));
        this.registerFunction("nvl", new NvlFunction());
        this.registerFunction("%odbcin", new StandardSQLFunction("%odbcin"));
        this.registerFunction("%odbcout", new StandardSQLFunction("%odbcin"));
        this.registerFunction("%pattern", new VarArgsSQLFunction(Hibernate.STRING, "", "%pattern", ""));
        this.registerFunction("pi", new StandardJDBCEscapeFunction("pi", Hibernate.DOUBLE));
        this.registerFunction("$piece", new VarArgsSQLFunction(Hibernate.STRING, "$piece(", ",", ")"));
        this.registerFunction("position", new VarArgsSQLFunction(Hibernate.INTEGER, "position(", " in ", ")"));
        this.registerFunction("power", new VarArgsSQLFunction(Hibernate.STRING, "power(", ",", ")"));
        this.registerFunction("quarter", new StandardJDBCEscapeFunction("quarter", Hibernate.INTEGER));
        this.registerFunction("repeat", new VarArgsSQLFunction(Hibernate.STRING, "repeat(", ",", ")"));
        this.registerFunction("replicate", new VarArgsSQLFunction(Hibernate.STRING, "replicate(", ",", ")"));
        this.registerFunction("right", new StandardJDBCEscapeFunction("right", Hibernate.STRING));
        this.registerFunction("round", new VarArgsSQLFunction(Hibernate.FLOAT, "round(", ",", ")"));
        this.registerFunction("rtrim", new StandardSQLFunction("rtrim", Hibernate.STRING));
        this.registerFunction("second", new StandardJDBCEscapeFunction("second", Hibernate.INTEGER));
        this.registerFunction("sign", new StandardSQLFunction("sign", Hibernate.INTEGER));
        this.registerFunction("sin", new StandardJDBCEscapeFunction("sin", Hibernate.DOUBLE));
        this.registerFunction("space", new StandardSQLFunction("space", Hibernate.STRING));
        this.registerFunction("%sqlstring", new VarArgsSQLFunction(Hibernate.STRING, "%sqlstring(", ",", ")"));
        this.registerFunction("%sqlupper", new VarArgsSQLFunction(Hibernate.STRING, "%sqlupper(", ",", ")"));
        this.registerFunction("sqrt", new StandardJDBCEscapeFunction("SQRT", Hibernate.DOUBLE));
        this.registerFunction("%startswith", new VarArgsSQLFunction(Hibernate.STRING, "", "%startswith", ""));
        this.registerFunction("str", new SQLFunctionTemplate(Hibernate.STRING, "cast(?1 as char varying)"));
        this.registerFunction("string", new VarArgsSQLFunction(Hibernate.STRING, "string(", ",", ")"));
        this.registerFunction("%string", new VarArgsSQLFunction(Hibernate.STRING, "%string(", ",", ")"));
        this.registerFunction("substr", new VarArgsSQLFunction(Hibernate.STRING, "substr(", ",", ")"));
        this.registerFunction("substring", new VarArgsSQLFunction(Hibernate.STRING, "substring(", ",", ")"));
        this.registerFunction("sysdate", new NoArgSQLFunction("sysdate", Hibernate.TIMESTAMP, false));
        this.registerFunction("tan", new StandardJDBCEscapeFunction("tan", Hibernate.DOUBLE));
        this.registerFunction("timestampadd", new StandardJDBCEscapeFunction("timestampadd", Hibernate.DOUBLE));
        this.registerFunction("timestampdiff", new StandardJDBCEscapeFunction("timestampdiff", Hibernate.DOUBLE));
        this.registerFunction("tochar", new VarArgsSQLFunction(Hibernate.STRING, "tochar(", ",", ")"));
        this.registerFunction("to_char", new VarArgsSQLFunction(Hibernate.STRING, "to_char(", ",", ")"));
        this.registerFunction("todate", new VarArgsSQLFunction(Hibernate.STRING, "todate(", ",", ")"));
        this.registerFunction("to_date", new VarArgsSQLFunction(Hibernate.STRING, "todate(", ",", ")"));
        this.registerFunction("tonumber", new StandardSQLFunction("tonumber"));
        this.registerFunction("to_number", new StandardSQLFunction("tonumber"));
        this.registerFunction("truncate", new StandardJDBCEscapeFunction("truncate", Hibernate.STRING));
        this.registerFunction("ucase", new StandardJDBCEscapeFunction("ucase", Hibernate.STRING));
        this.registerFunction("upper", new StandardSQLFunction("upper"));
        this.registerFunction("%upper", new StandardSQLFunction("%upper"));
        this.registerFunction("user", new StandardJDBCEscapeFunction("user", Hibernate.STRING));
        this.registerFunction("week", new StandardJDBCEscapeFunction("user", Hibernate.INTEGER));
        this.registerFunction("xmlconcat", new VarArgsSQLFunction(Hibernate.STRING, "xmlconcat(", ",", ")"));
        this.registerFunction("xmlelement", new VarArgsSQLFunction(Hibernate.STRING, "xmlelement(", ",", ")"));
        this.registerFunction("year", new StandardJDBCEscapeFunction("year", Hibernate.INTEGER));
    }

    protected final void register71Functions() {
        this.registerFunction("str", new VarArgsSQLFunction(Hibernate.STRING, "str(", ",", ")"));
    }

    @Override
    public boolean hasAlterTable() {
        return true;
    }

    @Override
    public boolean qualifyIndexName() {
        return false;
    }

    @Override
    public boolean supportsUnique() {
        return true;
    }

    @Override
    public String getAddForeignKeyConstraintString(String constraintName, String[] foreignKey, String referencedTable, String[] primaryKey, boolean referencesPrimaryKey) {
        return new StringBuffer(300).append(" ADD CONSTRAINT ").append(constraintName).append(" FOREIGN KEY ").append(constraintName).append(" (").append(StringHelper.join(", ", foreignKey)).append(") REFERENCES ").append(referencedTable).append(" (").append(StringHelper.join(", ", primaryKey)).append(") ").toString();
    }

    public boolean supportsCheck() {
        return false;
    }

    @Override
    public String getAddColumnString() {
        return " add column";
    }

    @Override
    public String getCascadeConstraintsString() {
        return "";
    }

    @Override
    public boolean dropConstraints() {
        return true;
    }

    @Override
    public boolean supportsCascadeDelete() {
        return true;
    }

    @Override
    public boolean hasSelfReferentialForeignKeyBug() {
        return true;
    }

    @Override
    public boolean supportsTemporaryTables() {
        return true;
    }

    @Override
    public String generateTemporaryTableName(String baseTableName) {
        String name = super.generateTemporaryTableName(baseTableName);
        return name.length() > 25 ? name.substring(1, 25) : name;
    }

    @Override
    public String getCreateTemporaryTableString() {
        return "create global temporary table";
    }

    @Override
    public Boolean performTemporaryTableDDLInIsolation() {
        return Boolean.FALSE;
    }

    @Override
    public String getCreateTemporaryTablePostfix() {
        return "";
    }

    @Override
    public boolean dropTemporaryTableAfterUse() {
        return true;
    }

    @Override
    public boolean supportsIdentityColumns() {
        return true;
    }

    @Override
    public Class getNativeIdentifierGeneratorClass() {
        return IdentityGenerator.class;
    }

    @Override
    public boolean hasDataTypeInIdentityColumn() {
        return true;
    }

    @Override
    public String getIdentityColumnString() throws MappingException {
        return "identity";
    }

    @Override
    public String getIdentitySelectString() {
        return "SELECT LAST_IDENTITY() FROM %TSQL_sys.snf";
    }

    @Override
    public boolean supportsSequences() {
        return false;
    }

    public boolean supportsForUpdate() {
        return false;
    }

    public boolean supportsForUpdateOf() {
        return false;
    }

    public boolean supportsForUpdateNowait() {
        return false;
    }

    @Override
    public boolean supportsOuterJoinForUpdate() {
        return false;
    }

    @Override
    public LockingStrategy getLockingStrategy(Lockable lockable, LockMode lockMode) {
        if (lockMode.greaterThan(LockMode.READ)) {
            return new UpdateLockingStrategy(lockable, lockMode);
        }
        return new SelectLockingStrategy(lockable, lockMode);
    }

    @Override
    public boolean supportsLimit() {
        return true;
    }

    @Override
    public boolean supportsLimitOffset() {
        return false;
    }

    @Override
    public boolean supportsVariableLimit() {
        return true;
    }

    @Override
    public boolean bindLimitParametersFirst() {
        return true;
    }

    @Override
    public boolean useMaxForLimit() {
        return true;
    }

    @Override
    public String getLimitString(String sql, boolean hasOffset) {
        if (hasOffset) {
            throw new UnsupportedOperationException("query result offset is not supported");
        }
        int insertionPoint = sql.startsWith("select distinct") ? 15 : 6;
        return new StringBuffer(sql.length() + 8).append(sql).insert(insertionPoint, " TOP ? ").toString();
    }

    @Override
    public int registerResultSetOutParameter(CallableStatement statement, int col) throws SQLException {
        return col;
    }

    @Override
    public ResultSet getResultSet(CallableStatement ps) throws SQLException {
        ps.execute();
        return (ResultSet)ps.getObject(1);
    }

    @Override
    public String getLowercaseFunction() {
        return "lower";
    }

    @Override
    public String getNullColumnString() {
        return " null";
    }

    @Override
    public JoinFragment createOuterJoinFragment() {
        return new CacheJoinFragment();
    }

    @Override
    public String getNoColumnsInsertString() {
        return " default values";
    }

    @Override
    public SQLExceptionConverter buildSQLExceptionConverter() {
        return new CacheSQLStateConverter(EXTRACTER);
    }

    @Override
    public boolean supportsEmptyInList() {
        return false;
    }

    @Override
    public boolean areStringComparisonsCaseInsensitive() {
        return true;
    }

    @Override
    public boolean supportsResultSetPositionQueryMethodsOnForwardOnlyCursor() {
        return false;
    }
}

