/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast.exec;

import antlr.RecognitionException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.engine.QueryParameters;
import org.hibernate.engine.RowSelection;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.hql.ast.HqlSqlWalker;
import org.hibernate.hql.ast.QuerySyntaxException;
import org.hibernate.hql.ast.SqlGenerator;
import org.hibernate.hql.ast.exec.AbstractStatementExecutor;
import org.hibernate.param.ParameterSpecification;
import org.hibernate.persister.entity.Queryable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicExecutor
extends AbstractStatementExecutor {
    private static final Logger log = LoggerFactory.getLogger(BasicExecutor.class);
    private final Queryable persister;
    private final String sql;
    private final List parameterSpecifications;

    public BasicExecutor(HqlSqlWalker walker, Queryable persister) {
        super(walker, log);
        this.persister = persister;
        try {
            SqlGenerator gen = new SqlGenerator(this.getFactory());
            gen.statement(walker.getAST());
            this.sql = gen.getSQL();
            gen.getParseErrorHandler().throwQueryException();
            this.parameterSpecifications = gen.getCollectedParameters();
        }
        catch (RecognitionException e) {
            throw QuerySyntaxException.convert(e);
        }
    }

    @Override
    public String[] getSqlStatements() {
        return new String[]{this.sql};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int execute(QueryParameters parameters, SessionImplementor session) throws HibernateException {
        int n;
        block8: {
            this.coordinateSharedCacheCleanup(session);
            PreparedStatement st = null;
            RowSelection selection = parameters.getRowSelection();
            try {
                st = session.getBatcher().prepareStatement(this.sql);
                Iterator parameterSpecifications = this.parameterSpecifications.iterator();
                int pos = 1;
                while (parameterSpecifications.hasNext()) {
                    ParameterSpecification paramSpec = (ParameterSpecification)parameterSpecifications.next();
                    pos += paramSpec.bind(st, parameters, session, pos);
                }
                if (selection != null && selection.getTimeout() != null) {
                    st.setQueryTimeout(selection.getTimeout());
                }
                n = st.executeUpdate();
                if (st == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (st != null) {
                        session.getBatcher().closeStatement(st);
                    }
                    throw throwable;
                }
                catch (SQLException sqle) {
                    throw JDBCExceptionHelper.convert(this.getFactory().getSQLExceptionConverter(), sqle, "could not execute update query", this.sql);
                }
            }
            session.getBatcher().closeStatement(st);
        }
        return n;
    }

    @Override
    protected Queryable[] getAffectedQueryables() {
        return new Queryable[]{this.persister};
    }
}

