/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id.enhanced;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import org.hibernate.HibernateException;
import org.hibernate.id.IdentifierGeneratorFactory;
import org.hibernate.id.enhanced.AccessCallback;
import org.hibernate.id.enhanced.Optimizer;
import org.hibernate.util.ReflectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptimizerFactory {
    private static final Logger log = LoggerFactory.getLogger(OptimizerFactory.class);
    public static final String NONE = "none";
    public static final String HILO = "hilo";
    public static final String POOL = "pooled";
    private static Class[] CTOR_SIG = new Class[]{Class.class, Integer.TYPE};

    public static Optimizer buildOptimizer(String type, Class returnClass, int incrementSize) {
        String optimizerClassName = NONE.equals(type) ? NoopOptimizer.class.getName() : (HILO.equals(type) ? HiLoOptimizer.class.getName() : (POOL.equals(type) ? PooledOptimizer.class.getName() : type));
        try {
            Class optimizerClass = ReflectHelper.classForName(optimizerClassName);
            Constructor ctor = optimizerClass.getConstructor(CTOR_SIG);
            return (Optimizer)ctor.newInstance(returnClass, new Integer(incrementSize));
        }
        catch (Throwable ignore) {
            return new NoopOptimizer(returnClass, incrementSize);
        }
    }

    public static Optimizer buildOptimizer(String type, Class returnClass, int incrementSize, long explicitInitialValue) {
        Optimizer optimizer = OptimizerFactory.buildOptimizer(type, returnClass, incrementSize);
        if (InitialValueAwareOptimizer.class.isInstance(optimizer)) {
            ((InitialValueAwareOptimizer)((Object)optimizer)).injectInitialValue(explicitInitialValue);
        }
        return optimizer;
    }

    public static class PooledOptimizer
    extends OptimizerSupport
    implements InitialValueAwareOptimizer {
        private long value;
        private long hiValue = -1L;
        private long initialValue = -1L;

        public PooledOptimizer(Class returnClass, int incrementSize) {
            super(returnClass, incrementSize);
            if (incrementSize < 1) {
                throw new HibernateException("increment size cannot be less than 1");
            }
            if (log.isTraceEnabled()) {
                log.trace("creating pooled optimizer with [incrementSize=" + incrementSize + "; returnClass=" + returnClass.getName() + "]");
            }
        }

        @Override
        public synchronized Serializable generate(AccessCallback callback) {
            if (this.hiValue < 0L) {
                this.value = callback.getNextValue();
                if (this.value < 1L) {
                    log.info("pooled optimizer source reported [" + this.value + "] as the initial value; use of 1 or greater highly recommended");
                }
                if (this.initialValue == -1L && this.value < (long)this.incrementSize || this.value == this.initialValue) {
                    this.hiValue = callback.getNextValue();
                } else {
                    this.hiValue = this.value;
                    this.value = this.hiValue - (long)this.incrementSize;
                }
            } else if (this.value >= this.hiValue) {
                this.hiValue = callback.getNextValue();
                this.value = this.hiValue - (long)this.incrementSize;
            }
            return this.make(this.value++);
        }

        @Override
        public long getLastSourceValue() {
            return this.hiValue;
        }

        @Override
        public boolean applyIncrementSizeToSourceValues() {
            return true;
        }

        public long getLastValue() {
            return this.value - 1L;
        }

        @Override
        public void injectInitialValue(long initialValue) {
            this.initialValue = initialValue;
        }
    }

    public static class HiLoOptimizer
    extends OptimizerSupport {
        private long lastSourceValue = -1L;
        private long value;
        private long hiValue;

        public HiLoOptimizer(Class returnClass, int incrementSize) {
            super(returnClass, incrementSize);
            if (incrementSize < 1) {
                throw new HibernateException("increment size cannot be less than 1");
            }
            if (log.isTraceEnabled()) {
                log.trace("creating hilo optimizer with [incrementSize=" + incrementSize + "; returnClass=" + returnClass.getName() + "]");
            }
        }

        @Override
        public synchronized Serializable generate(AccessCallback callback) {
            if (this.lastSourceValue < 0L) {
                this.lastSourceValue = callback.getNextValue();
                while (this.lastSourceValue <= 0L) {
                    this.lastSourceValue = callback.getNextValue();
                }
                this.hiValue = this.lastSourceValue * (long)this.incrementSize + 1L;
                this.value = this.hiValue - (long)this.incrementSize;
            } else if (this.value >= this.hiValue) {
                this.lastSourceValue = callback.getNextValue();
                this.hiValue = this.lastSourceValue * (long)this.incrementSize + 1L;
            }
            return this.make(this.value++);
        }

        @Override
        public long getLastSourceValue() {
            return this.lastSourceValue;
        }

        @Override
        public boolean applyIncrementSizeToSourceValues() {
            return false;
        }

        public long getLastValue() {
            return this.value - 1L;
        }

        public long getHiValue() {
            return this.hiValue;
        }
    }

    public static class NoopOptimizer
    extends OptimizerSupport {
        private long lastSourceValue = -1L;

        public NoopOptimizer(Class returnClass, int incrementSize) {
            super(returnClass, incrementSize);
        }

        @Override
        public Serializable generate(AccessCallback callback) {
            if (this.lastSourceValue == -1L) {
                while (this.lastSourceValue <= 0L) {
                    this.lastSourceValue = callback.getNextValue();
                }
            } else {
                this.lastSourceValue = callback.getNextValue();
            }
            return this.make(this.lastSourceValue);
        }

        @Override
        public long getLastSourceValue() {
            return this.lastSourceValue;
        }

        @Override
        public boolean applyIncrementSizeToSourceValues() {
            return false;
        }
    }

    public static abstract class OptimizerSupport
    implements Optimizer {
        protected final Class returnClass;
        protected final int incrementSize;

        protected OptimizerSupport(Class returnClass, int incrementSize) {
            if (returnClass == null) {
                throw new HibernateException("return class is required");
            }
            this.returnClass = returnClass;
            this.incrementSize = incrementSize;
        }

        protected final Serializable make(long value) {
            return IdentifierGeneratorFactory.createNumber(value, this.returnClass);
        }

        public final Class getReturnClass() {
            return this.returnClass;
        }

        @Override
        public final int getIncrementSize() {
            return this.incrementSize;
        }
    }

    public static interface InitialValueAwareOptimizer {
        public void injectInitialValue(long var1);
    }
}

