/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import org.hibernate.MappingException;
import org.hibernate.engine.Mapping;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.PrimaryKey;

public abstract class IdentifierCollection
extends Collection {
    public static final String DEFAULT_IDENTIFIER_COLUMN_NAME = "id";
    private KeyValue identifier;

    public IdentifierCollection(PersistentClass owner) {
        super(owner);
    }

    public KeyValue getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(KeyValue identifier) {
        this.identifier = identifier;
    }

    @Override
    public final boolean isIdentified() {
        return true;
    }

    @Override
    void createPrimaryKey() {
        if (!this.isOneToMany()) {
            PrimaryKey pk = new PrimaryKey();
            pk.addColumns(this.getIdentifier().getColumnIterator());
            this.getCollectionTable().setPrimaryKey(pk);
        }
    }

    @Override
    public void validate(Mapping mapping) throws MappingException {
        super.validate(mapping);
        if (!this.getIdentifier().isValid(mapping)) {
            throw new MappingException("collection id mapping has wrong number of columns: " + this.getRole() + " type: " + this.getIdentifier().getType().getName());
        }
    }
}

