/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Comparator;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Environment;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.type.MutableType;
import org.hibernate.type.VersionType;

public abstract class AbstractBynaryType
extends MutableType
implements VersionType,
Comparator {
    protected abstract Object toExternalFormat(byte[] var1);

    protected abstract byte[] toInternalFormat(Object var1);

    @Override
    public void set(PreparedStatement st, Object value, int index) throws HibernateException, SQLException {
        byte[] internalValue = this.toInternalFormat(value);
        if (Environment.useStreamsForBinary()) {
            st.setBinaryStream(index, (InputStream)new ByteArrayInputStream(internalValue), internalValue.length);
        } else {
            st.setBytes(index, internalValue);
        }
    }

    @Override
    public Object get(ResultSet rs, String name) throws HibernateException, SQLException {
        if (Environment.useStreamsForBinary()) {
            InputStream inputStream = rs.getBinaryStream(name);
            if (inputStream == null) {
                return this.toExternalFormat(null);
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream(2048);
            byte[] buffer = new byte[2048];
            try {
                int amountRead;
                while ((amountRead = inputStream.read(buffer)) != -1) {
                    outputStream.write(buffer, 0, amountRead);
                }
                inputStream.close();
                outputStream.close();
            }
            catch (IOException ioe) {
                throw new HibernateException("IOException occurred reading a binary value", ioe);
            }
            return this.toExternalFormat(outputStream.toByteArray());
        }
        return this.toExternalFormat(rs.getBytes(name));
    }

    @Override
    public int sqlType() {
        return -3;
    }

    @Override
    public Object seed(SessionImplementor session) {
        return null;
    }

    @Override
    public Object next(Object current, SessionImplementor session) {
        return current;
    }

    @Override
    public Comparator getComparator() {
        return this;
    }

    public int compare(Object o1, Object o2) {
        return this.compare(o1, o2, null);
    }

    @Override
    public boolean isEqual(Object x, Object y) {
        return x == y || x != null && y != null && Arrays.equals(this.toInternalFormat(x), this.toInternalFormat(y));
    }

    @Override
    public int getHashCode(Object x, EntityMode entityMode) {
        byte[] bytes = this.toInternalFormat(x);
        int hashCode = 1;
        for (int j = 0; j < bytes.length; ++j) {
            hashCode = 31 * hashCode + bytes[j];
        }
        return hashCode;
    }

    @Override
    public int compare(Object x, Object y, EntityMode entityMode) {
        byte[] ybytes;
        byte[] xbytes = this.toInternalFormat(x);
        if (xbytes.length < (ybytes = this.toInternalFormat(y)).length) {
            return -1;
        }
        if (xbytes.length > ybytes.length) {
            return 1;
        }
        for (int i = 0; i < xbytes.length; ++i) {
            if (xbytes[i] < ybytes[i]) {
                return -1;
            }
            if (xbytes[i] <= ybytes[i]) continue;
            return 1;
        }
        return 0;
    }

    @Override
    public abstract String getName();

    @Override
    public String toString(Object val) {
        byte[] bytes = this.toInternalFormat(val);
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            String hexStr = Integer.toHexString(bytes[i] - -128);
            if (hexStr.length() == 1) {
                buf.append('0');
            }
            buf.append(hexStr);
        }
        return buf.toString();
    }

    @Override
    public Object deepCopyNotNull(Object value) {
        byte[] bytes = this.toInternalFormat(value);
        byte[] result = new byte[bytes.length];
        System.arraycopy(bytes, 0, result, 0, bytes.length);
        return this.toExternalFormat(result);
    }

    @Override
    public Object fromStringValue(String xml) throws HibernateException {
        if (xml == null) {
            return null;
        }
        if (xml.length() % 2 != 0) {
            throw new IllegalArgumentException("The string is not a valid xml representation of a binary content.");
        }
        byte[] bytes = new byte[xml.length() / 2];
        for (int i = 0; i < bytes.length; ++i) {
            String hexStr = xml.substring(i * 2, (i + 1) * 2);
            bytes[i] = (byte)(Integer.parseInt(hexStr, 16) + -128);
        }
        return this.toExternalFormat(bytes);
    }
}

