/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.type.ImmutableType;
import org.hibernate.util.ReflectHelper;

public class ClassType
extends ImmutableType {
    @Override
    public Object get(ResultSet rs, String name) throws HibernateException, SQLException {
        String str = (String)Hibernate.STRING.get(rs, name);
        if (str == null) {
            return null;
        }
        try {
            return ReflectHelper.classForName(str);
        }
        catch (ClassNotFoundException cnfe) {
            throw new HibernateException("Class not found: " + str);
        }
    }

    @Override
    public void set(PreparedStatement st, Object value, int index) throws HibernateException, SQLException {
        Hibernate.STRING.set(st, ((Class)value).getName(), index);
    }

    @Override
    public int sqlType() {
        return Hibernate.STRING.sqlType();
    }

    @Override
    public String toString(Object value) throws HibernateException {
        return ((Class)value).getName();
    }

    @Override
    public Class getReturnedClass() {
        return Class.class;
    }

    @Override
    public String getName() {
        return "class";
    }

    @Override
    public Object fromStringValue(String xml) throws HibernateException {
        try {
            return ReflectHelper.classForName(xml);
        }
        catch (ClassNotFoundException cnfe) {
            throw new HibernateException("could not parse xml", cnfe);
        }
    }
}

