/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Comparator;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.type.DiscriminatorType;
import org.hibernate.type.PrimitiveType;
import org.hibernate.type.VersionType;
import org.hibernate.util.ComparableComparator;

public class IntegerType
extends PrimitiveType
implements DiscriminatorType,
VersionType {
    private static final Integer ZERO = 0;

    @Override
    public Serializable getDefaultValue() {
        return ZERO;
    }

    @Override
    public Object get(ResultSet rs, String name) throws SQLException {
        return new Integer(rs.getInt(name));
    }

    @Override
    public Class getPrimitiveClass() {
        return Integer.TYPE;
    }

    @Override
    public Class getReturnedClass() {
        return Integer.class;
    }

    @Override
    public void set(PreparedStatement st, Object value, int index) throws SQLException {
        st.setInt(index, (Integer)value);
    }

    @Override
    public int sqlType() {
        return 4;
    }

    @Override
    public String getName() {
        return "integer";
    }

    @Override
    public String objectToSQLString(Object value, Dialect dialect) throws Exception {
        return value.toString();
    }

    @Override
    public Object stringToObject(String xml) throws Exception {
        return new Integer(xml);
    }

    @Override
    public Object next(Object current, SessionImplementor session) {
        return new Integer((Integer)current + 1);
    }

    @Override
    public Object seed(SessionImplementor session) {
        return ZERO;
    }

    @Override
    public Comparator getComparator() {
        return ComparableComparator.INSTANCE;
    }

    @Override
    public Object fromStringValue(String xml) {
        return new Integer(xml);
    }
}

