/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Comparator;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.type.DiscriminatorType;
import org.hibernate.type.PrimitiveType;
import org.hibernate.type.VersionType;
import org.hibernate.util.ComparableComparator;

public class LongType
extends PrimitiveType
implements DiscriminatorType,
VersionType {
    private static final Long ZERO = new Long(0L);

    @Override
    public Serializable getDefaultValue() {
        return ZERO;
    }

    @Override
    public Object get(ResultSet rs, String name) throws SQLException {
        return new Long(rs.getLong(name));
    }

    @Override
    public Class getPrimitiveClass() {
        return Long.TYPE;
    }

    @Override
    public Class getReturnedClass() {
        return Long.class;
    }

    @Override
    public void set(PreparedStatement st, Object value, int index) throws SQLException {
        st.setLong(index, (Long)value);
    }

    @Override
    public int sqlType() {
        return -5;
    }

    @Override
    public String getName() {
        return "long";
    }

    @Override
    public Object stringToObject(String xml) throws Exception {
        return new Long(xml);
    }

    @Override
    public Object next(Object current, SessionImplementor session) {
        return new Long((Long)current + 1L);
    }

    @Override
    public Object seed(SessionImplementor session) {
        return ZERO;
    }

    @Override
    public Comparator getComparator() {
        return ComparableComparator.INSTANCE;
    }

    @Override
    public String objectToSQLString(Object value, Dialect dialect) throws Exception {
        return value.toString();
    }

    @Override
    public Object fromStringValue(String xml) {
        return new Long(xml);
    }
}

