/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.on.embedded.ui;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.on.embedded.manager.ResourceManagerFactory;
import org.jboss.on.embedded.ui.BootstrapAction;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;

@Scope(value=ScopeType.APPLICATION)
@Name(value="discoveryAction")
public class DiscoveryAction {
    private final Log log = LogFactory.getLog(this.getClass());
    private static final int DEFAULT_MINIMUM_SCAN_INTERVAL = 60000;
    @In
    private BootstrapAction bootstrapAction;
    private volatile long lastDiscoveryTime;
    private int scanPeriod = 60000;

    public int getScanPeriod() {
        return this.scanPeriod;
    }

    public void setScanPeriod(int scanPeriod) {
        this.scanPeriod = scanPeriod;
    }

    public void checkAutodiscovery() {
        if (this.bootstrapAction.isInitialized() && System.currentTimeMillis() - this.lastDiscoveryTime > 60000L) {
            this.tryAutodiscovery();
        }
    }

    private synchronized void tryAutodiscovery() {
        this.log.trace((Object)"Checking if service discovery scan is needed...");
        if (System.currentTimeMillis() - this.lastDiscoveryTime > 60000L) {
            this.lastDiscoveryTime = System.currentTimeMillis();
            this.log.trace((Object)"Performing service discovery scan...");
            ResourceManagerFactory.resourceManager().discoverServicesAsync();
        }
    }
}

