/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bsf.util;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JavaUtils {
    private static Log logger = LogFactory.getLog((String)JavaUtils.class.getName());

    public static boolean JDKcompile(String fileName, String classPath) {
        String option = logger.isDebugEnabled() ? "-g" : "-O";
        String[] args = new String[]{"javac", option, "-classpath", classPath, fileName};
        logger.debug((Object)("JavaEngine: Compiling " + fileName));
        logger.debug((Object)("JavaEngine: Classpath is " + classPath));
        try {
            Process p = Runtime.getRuntime().exec(args);
            p.waitFor();
            return p.exitValue() != 0;
        }
        catch (IOException e) {
            logger.error((Object)"ERROR: IO exception during exec(javac).", (Throwable)e);
        }
        catch (SecurityException e) {
            logger.error((Object)"ERROR: Unable to create subprocess to exec(javac).", (Throwable)e);
        }
        catch (InterruptedException e) {
            logger.error((Object)"ERROR: Wait for exec(javac) was interrupted.", (Throwable)e);
        }
        return false;
    }
}

