/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.copy;

import java.io.File;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.spi.TempStore;

public class MkdirTempStore
implements TempStore {
    private TempStore delegate;

    public MkdirTempStore(TempStore delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException("Null delegate");
        }
        this.delegate = delegate;
    }

    protected void assertMkdir(File dir) {
        if (!dir.mkdir()) {
            throw new IllegalArgumentException("Cannot create directory: " + dir);
        }
    }

    public File createTempFolder(VirtualFile file) {
        File dir = this.delegate.createTempFolder(file);
        this.assertMkdir(dir);
        return dir;
    }

    public File createTempFolder(String outerName, String innerName) {
        File dir = this.delegate.createTempFolder(outerName, innerName);
        this.assertMkdir(dir);
        return dir;
    }

    public void clear() {
        this.delegate.clear();
    }
}

