/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.plugins.context;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jboss.metadata.spi.context.MetaDataContext;
import org.jboss.metadata.spi.retrieval.AnnotationItem;
import org.jboss.metadata.spi.retrieval.AnnotationsItem;
import org.jboss.metadata.spi.retrieval.MetaDataItem;
import org.jboss.metadata.spi.retrieval.MetaDataRetrieval;
import org.jboss.metadata.spi.retrieval.MetaDatasItem;
import org.jboss.metadata.spi.retrieval.ValidTime;
import org.jboss.metadata.spi.retrieval.cummulative.CummulativeAnnotationsItem;
import org.jboss.metadata.spi.retrieval.cummulative.CummulativeMetaDatasItem;
import org.jboss.metadata.spi.scope.Scope;
import org.jboss.metadata.spi.scope.ScopeKey;
import org.jboss.metadata.spi.scope.ScopeLevel;
import org.jboss.metadata.spi.signature.Signature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractMetaDataContext
implements MetaDataContext {
    private List<MetaDataRetrieval> retrievals;
    private MetaDataContext parent;
    private volatile ScopeKey scopeKey;

    public AbstractMetaDataContext(MetaDataRetrieval retrieval) {
        this(null, retrieval);
    }

    public AbstractMetaDataContext(MetaDataContext parent, MetaDataRetrieval retrieval) {
        this(parent, Collections.singletonList(retrieval));
    }

    public AbstractMetaDataContext(MetaDataContext parent, List<MetaDataRetrieval> retrievals) {
        if (retrievals == null) {
            throw new IllegalArgumentException("Null retrievals");
        }
        if (retrievals.isEmpty()) {
            throw new IllegalArgumentException("Must have at least one retrieval");
        }
        for (MetaDataRetrieval retrieval : retrievals) {
            if (retrieval != null) continue;
            throw new IllegalArgumentException("Null retrieval");
        }
        this.parent = parent;
        this.retrievals = retrievals;
    }

    @Override
    public ScopeKey getScope() {
        if (this.scopeKey == null) {
            ScopeKey key = new ScopeKey();
            for (MetaDataRetrieval retrieval : this.getRetrievals()) {
                ScopeKey retrievalKey = retrieval.getScope();
                Collection<Scope> scopes = retrievalKey.getScopes();
                for (Scope scope : scopes) {
                    key.addScope(scope);
                }
            }
            this.scopeKey = key;
        }
        return this.scopeKey;
    }

    @Override
    public ValidTime getValidTime() {
        ValidTime result = null;
        long resultLong = Long.MIN_VALUE;
        if (this.parent != null) {
            result = this.parent.getValidTime();
            resultLong = result.getValidTime();
        }
        for (MetaDataRetrieval retrieval : this.retrievals) {
            ValidTime temp = retrieval.getValidTime();
            long tempLong = temp.getValidTime();
            if (tempLong <= resultLong && result != null) continue;
            result = temp;
            resultLong = tempLong;
        }
        return result;
    }

    @Override
    public MetaDataContext getParent() {
        return this.parent;
    }

    @Override
    public List<MetaDataRetrieval> getRetrievals() {
        if (this.parent == null) {
            return this.retrievals;
        }
        ArrayList<MetaDataRetrieval> result = new ArrayList<MetaDataRetrieval>(this.retrievals);
        result.add(this.parent);
        return result;
    }

    @Override
    public List<MetaDataRetrieval> getLocalRetrievals() {
        return this.retrievals;
    }

    @Override
    public void append(MetaDataRetrieval retrieval) {
        if (retrieval == null) {
            throw new IllegalArgumentException("Null retrieval");
        }
        if (!(this.retrievals instanceof CopyOnWriteArrayList)) {
            this.retrievals = new CopyOnWriteArrayList<MetaDataRetrieval>(this.retrievals);
        }
        this.retrievals.add(retrieval);
        this.scopeKey = null;
    }

    @Override
    public void prepend(MetaDataRetrieval retrieval) {
        if (retrieval == null) {
            throw new IllegalArgumentException("Null retrieval");
        }
        if (!(this.retrievals instanceof CopyOnWriteArrayList)) {
            this.retrievals = new CopyOnWriteArrayList<MetaDataRetrieval>(this.retrievals);
        }
        this.retrievals.add(0, retrieval);
        this.scopeKey = null;
    }

    @Override
    public void remove(MetaDataRetrieval retrieval) {
        if (retrieval == null) {
            throw new IllegalArgumentException("Null retrieval");
        }
        if (this.retrievals.size() == 1) {
            throw new IllegalStateException("Must have at least one retrieval");
        }
        this.retrievals.remove(retrieval);
        this.scopeKey = null;
    }

    @Override
    public AnnotationsItem retrieveAnnotations() {
        return new CummulativeAnnotationsItem(this, true);
    }

    @Override
    public AnnotationsItem retrieveLocalAnnotations() {
        return new CummulativeAnnotationsItem(this, false);
    }

    @Override
    public <T extends Annotation> AnnotationItem<T> retrieveAnnotation(Class<T> annotationType) {
        for (MetaDataRetrieval retrieval : this.retrievals) {
            AnnotationItem<T> item = retrieval.retrieveAnnotation(annotationType);
            if (item == null) continue;
            return item;
        }
        if (this.parent != null) {
            return this.parent.retrieveAnnotation(annotationType);
        }
        return null;
    }

    @Override
    public MetaDatasItem retrieveMetaData() {
        return new CummulativeMetaDatasItem(this, true);
    }

    @Override
    public MetaDatasItem retrieveLocalMetaData() {
        return new CummulativeMetaDatasItem(this, false);
    }

    @Override
    public <T> MetaDataItem<T> retrieveMetaData(Class<T> type) {
        for (MetaDataRetrieval retrieval : this.retrievals) {
            MetaDataItem<T> item = retrieval.retrieveMetaData(type);
            if (item == null) continue;
            return item;
        }
        if (this.parent != null) {
            return this.parent.retrieveMetaData(type);
        }
        return null;
    }

    @Override
    public MetaDataItem<?> retrieveMetaData(String name) {
        for (MetaDataRetrieval retrieval : this.retrievals) {
            MetaDataItem<?> item = retrieval.retrieveMetaData(name);
            if (item == null) continue;
            return item;
        }
        if (this.parent != null) {
            return this.parent.retrieveMetaData(name);
        }
        return null;
    }

    @Override
    public MetaDataRetrieval getComponentMetaDataRetrieval(Signature signature) {
        if (signature == null) {
            return null;
        }
        ArrayList<MetaDataRetrieval> componentRetrievals = null;
        for (MetaDataRetrieval retrieval : this.retrievals) {
            if ((retrieval = retrieval.getComponentMetaDataRetrieval(signature)) == null) continue;
            if (componentRetrievals == null) {
                componentRetrievals = new ArrayList<MetaDataRetrieval>();
            }
            componentRetrievals.add(retrieval);
        }
        MetaDataContext parentComponent = null;
        if (this.parent != null) {
            parentComponent = (MetaDataContext)this.parent.getComponentMetaDataRetrieval(signature);
        }
        if (componentRetrievals == null) {
            return parentComponent;
        }
        return new AbstractMetaDataContext(parentComponent, componentRetrievals);
    }

    @Override
    public boolean isEmpty() {
        for (MetaDataRetrieval retrieval : this.retrievals) {
            if (retrieval.isEmpty()) continue;
            return false;
        }
        return this.parent == null || this.parent.isEmpty();
    }

    @Override
    public MetaDataRetrieval getScopedRetrieval(ScopeLevel level) {
        ArrayList<MetaDataRetrieval> matchingRetrievals = new ArrayList<MetaDataRetrieval>();
        List<MetaDataRetrieval> localRetrievals = this.getLocalRetrievals();
        for (MetaDataRetrieval localRetrieval : localRetrievals) {
            ScopeKey scopeKey = localRetrieval.getScope();
            if (scopeKey.getScopeLevel(level) == null) continue;
            matchingRetrievals.add(localRetrieval);
        }
        if (!matchingRetrievals.isEmpty()) {
            if (matchingRetrievals.size() > 1) {
                return new AbstractMetaDataContext(null, matchingRetrievals);
            }
            return (MetaDataRetrieval)matchingRetrievals.get(0);
        }
        return null;
    }
}

