/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas5.deploy;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.URI;
import java.util.Collection;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.deployers.spi.management.KnownDeploymentTypes;
import org.jboss.deployers.spi.management.ManagementView;
import org.jboss.deployers.spi.management.deploy.DeploymentManager;
import org.jboss.managed.api.ManagedDeployment;
import org.jboss.profileservice.spi.ProfileKey;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.content.PackageDetailsKey;
import org.rhq.core.domain.content.transfer.ResourcePackageDetails;
import org.rhq.core.domain.resource.CreateResourceStatus;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pluginapi.inventory.CreateResourceReport;
import org.rhq.core.util.MessageDigestGenerator;
import org.rhq.plugins.jbossas5.connection.ProfileServiceConnection;
import org.rhq.plugins.jbossas5.deploy.Deployer;
import org.rhq.plugins.jbossas5.util.ConversionUtils;
import org.rhq.plugins.jbossas5.util.DeploymentUtils;

public abstract class AbstractDeployer
implements Deployer {
    private static final ProfileKey FARM_PROFILE_KEY = new ProfileKey("farm");
    private static final ProfileKey APPLICATIONS_PROFILE_KEY = new ProfileKey("applications");
    public static final String DEPLOYMENT_NAME_PROPERTY = "deploymentName";
    private final Log log = LogFactory.getLog(this.getClass());
    private ProfileServiceConnection profileServiceConnection;

    protected AbstractDeployer(ProfileServiceConnection profileService) {
        this.profileServiceConnection = profileService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy(CreateResourceReport createResourceReport, ResourceType resourceType) {
        String archiveName;
        ResourcePackageDetails details;
        File archiveFile;
        block21: {
            archiveFile = null;
            details = createResourceReport.getPackageDetails();
            PackageDetailsKey key = details.getKey();
            archiveFile = this.prepareArchive(key, resourceType);
            archiveName = key.getName();
            if (DeploymentUtils.hasCorrectExtension(archiveName, resourceType)) break block21;
            createResourceReport.setStatus(CreateResourceStatus.FAILURE);
            createResourceReport.setErrorMessage("Incorrect extension specified on filename [" + archiveName + "]");
            if (archiveFile != null) {
                this.destroyArchive(archiveFile);
            }
            return;
        }
        try {
            this.abortIfApplicationAlreadyDeployed(resourceType, archiveFile);
            Configuration deployTimeConfig = details.getDeploymentTimeConfiguration();
            boolean deployExploded = deployTimeConfig.getSimple("deployExploded").getBooleanValue();
            DeploymentManager deploymentManager = this.profileServiceConnection.getDeploymentManager();
            boolean deployFarmed = deployTimeConfig.getSimple("deployFarmed").getBooleanValue();
            if (deployFarmed) {
                Collection profileKeys = deploymentManager.getProfiles();
                boolean farmSupported = false;
                for (ProfileKey profileKey : profileKeys) {
                    if (!profileKey.getName().equals(FARM_PROFILE_KEY.getName())) continue;
                    farmSupported = true;
                    break;
                }
                if (!farmSupported) {
                    throw new IllegalStateException("This application server instance is not a node in a cluster, so it does not support farmed deployments. Supported deployment profiles are " + profileKeys + ".");
                }
                if (deployExploded) {
                    throw new IllegalArgumentException("Deploying farmed applications in exploded form is not supported by the Profile Service.");
                }
                deploymentManager.loadProfile(FARM_PROFILE_KEY);
            }
            try {
                DeploymentUtils.deployArchive(deploymentManager, archiveFile, deployExploded);
            }
            finally {
                if (deployFarmed) {
                    deploymentManager.loadProfile(APPLICATIONS_PROFILE_KEY);
                }
            }
            if (deployExploded) {
                new MessageDigestGenerator("SHA-256");
                String shaString = MessageDigestGenerator.getDigestString((File)archiveFile);
                String deploymentName = deployTimeConfig.getSimple(DEPLOYMENT_NAME_PROPERTY).getStringValue();
                URI deployePackageURI = URI.create(deploymentName);
                String path = deployePackageURI.getPath();
                File location = new File(path);
                if (location != null && location.isDirectory()) {
                    Manifest manifest;
                    File manifestFile = new File(location, "META-INF/MANIFEST.MF");
                    if (manifestFile.exists()) {
                        FileInputStream inputStream = new FileInputStream(manifestFile);
                        manifest = new Manifest(inputStream);
                        inputStream.close();
                    } else {
                        manifest = new Manifest();
                    }
                    Attributes attribs = manifest.getMainAttributes();
                    attribs.putValue("RHQ-Sha256", shaString);
                    FileOutputStream outputStream = new FileOutputStream(manifestFile);
                    manifest.write(outputStream);
                    outputStream.close();
                }
            }
            createResourceReport.setResourceName(archiveName);
            createResourceReport.setResourceKey(archiveName);
            createResourceReport.setStatus(CreateResourceStatus.SUCCESS);
            if (archiveFile != null) {
                this.destroyArchive(archiveFile);
            }
        }
        catch (Throwable t) {
            try {
                this.log.error((Object)("Error deploying application for request [" + createResourceReport + "]."), t);
                createResourceReport.setStatus(CreateResourceStatus.FAILURE);
                createResourceReport.setException(t);
                if (archiveFile != null) {
                    this.destroyArchive(archiveFile);
                }
            }
            catch (Throwable throwable) {
                if (archiveFile != null) {
                    this.destroyArchive(archiveFile);
                }
                throw throwable;
            }
        }
    }

    protected Log getLog() {
        return this.log;
    }

    protected ProfileServiceConnection getProfileServiceConnection() {
        return this.profileServiceConnection;
    }

    protected abstract File prepareArchive(PackageDetailsKey var1, ResourceType var2);

    protected abstract void destroyArchive(File var1);

    private void abortIfApplicationAlreadyDeployed(ResourceType resourceType, File archiveFile) throws Exception {
        String archiveFileName = archiveFile.getName();
        KnownDeploymentTypes deploymentType = ConversionUtils.getDeploymentType(resourceType);
        String deploymentTypeString = deploymentType.getType();
        ManagementView managementView = this.profileServiceConnection.getManagementView();
        managementView.load();
        Set managedDeployments = managementView.getDeploymentsForType(deploymentTypeString);
        for (ManagedDeployment managedDeployment : managedDeployments) {
            if (!managedDeployment.getSimpleName().equals(archiveFileName)) continue;
            throw new IllegalArgumentException("An application named '" + archiveFileName + "' is already deployed.");
        }
    }
}

