/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.pojo.memory;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class PersistentReference {
    static final int REFERENCE_WEAK = 1;
    public static final int REFERENCE_SOFT = 2;
    private static final Log log = LogFactory.getLog(PersistentReference.class);
    private static final boolean isDebug = log.isDebugEnabled();
    private WeakReference classReference;
    private Reference referencedObject;
    private int referenceType = 0;

    public PersistentReference(Class clazz, Object referencedObject, int referenceType) {
        this.referenceType = referenceType;
        if (clazz != null) {
            this.classReference = new WeakReference<Class>(clazz);
        }
        this.buildReference(referencedObject);
    }

    Object internalGet() {
        if (this.referencedObject == null) {
            return null;
        }
        return this.referencedObject.get();
    }

    public Object get() {
        if (this.referencedObject == null) {
            return null;
        }
        Object returnValue = this.referencedObject.get();
        if (returnValue == null) {
            try {
                if (isDebug) {
                    log.debug((Object)("Reference on " + this.getClass().getName() + " being rebuilt"));
                }
                return this.rebuildReference();
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return returnValue;
    }

    protected abstract Object rebuildReference() throws Exception;

    void buildReference(Object obj) {
        this.referencedObject = obj == null ? null : (this.referenceType == 1 ? new WeakReference<Object>(obj) : new SoftReference<Object>(obj));
    }

    Class getMappedClass() {
        if (this.classReference == null) {
            return null;
        }
        Class returnClass = (Class)this.classReference.get();
        if (returnClass == null) {
            throw new RuntimeException("Class was already unloaded");
        }
        return returnClass;
    }
}

