/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.loading;

import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandlerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegatingClassLoader
extends URLClassLoader {
    public static final URL[] EMPTY_URL_ARRAY = new URL[0];
    protected boolean standard = false;
    private ClassLoader parent = null;

    public DelegatingClassLoader(ClassLoader parent) {
        super(EMPTY_URL_ARRAY, parent);
        if (parent == null) {
            throw new IllegalArgumentException("No parent");
        }
        this.parent = parent;
    }

    public DelegatingClassLoader(ClassLoader parent, URLStreamHandlerFactory factory) {
        super(EMPTY_URL_ARRAY, parent, factory);
        if (parent == null) {
            throw new IllegalArgumentException("No parent");
        }
        this.parent = parent;
    }

    @Override
    protected Class<?> loadClass(String className, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz;
        block4: {
            if (this.standard) {
                return super.loadClass(className, resolve);
            }
            clazz = null;
            try {
                clazz = this.parent.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                clazz = this.findLoadedClass(className);
                if (clazz != null) break block4;
                throw e;
            }
        }
        if (resolve) {
            this.resolveClass(clazz);
        }
        return clazz;
    }
}

