/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxws.spi;

import java.net.URI;
import java.net.URISyntaxException;
import java.security.Permission;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.Executor;
import javax.xml.transform.Source;
import javax.xml.ws.Binding;
import javax.xml.ws.Endpoint;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServicePermission;
import javax.xml.ws.http.HTTPBinding;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import javax.xml.ws.wsaddressing.W3CEndpointReferenceBuilder;
import org.jboss.logging.Logger;
import org.jboss.ws.core.jaxws.binding.BindingProviderImpl;
import org.jboss.ws.core.jaxws.wsaddressing.EndpointReferenceUtil;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.http.HttpContext;
import org.jboss.wsf.spi.http.HttpServer;
import org.jboss.wsf.spi.http.HttpServerFactory;
import org.jboss.wsf.spi.management.ServerConfig;
import org.jboss.wsf.spi.management.ServerConfigFactory;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointImpl
extends Endpoint {
    private final Logger log = Logger.getLogger(EndpointImpl.class);
    private static final WebServicePermission ENDPOINT_PUBLISH_PERMISSION = new WebServicePermission("publishEndpoint");
    private Object implementor;
    private Executor executor;
    private List<Source> metadata;
    private BindingProviderImpl bindingProvider;
    private Map<String, Object> properties = new HashMap<String, Object>();
    private HttpContext serverContext;
    private boolean isPublished;
    private boolean isDestroyed;
    private URI address;

    public EndpointImpl(String bindingId, Object implementor) {
        this.log.debug((Object)("new EndpointImpl(bindingId=" + bindingId + ",implementor=" + implementor + ")"));
        if (implementor == null) {
            throw new IllegalArgumentException("Implementor cannot be null");
        }
        this.implementor = implementor;
        this.bindingProvider = new BindingProviderImpl(bindingId);
    }

    public Binding getBinding() {
        return this.bindingProvider.getBinding();
    }

    public Object getImplementor() {
        return this.implementor;
    }

    public void publish(String addr) {
        this.log.debug((Object)("publish: " + addr));
        try {
            this.address = new URI(addr);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid address: " + addr);
        }
        this.checkPublishEndpointPermission();
        SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
        HttpServer httpServer = ((HttpServerFactory)spiProvider.getSPI(HttpServerFactory.class)).getHttpServer();
        httpServer.setProperties(this.properties);
        httpServer.start();
        String path = this.address.getPath();
        String contextRoot = "/" + new StringTokenizer(path, "/").nextToken();
        HttpContext context = httpServer.createContext(contextRoot);
        this.publish(context);
    }

    public void publish(Object context) {
        this.log.debug((Object)("publish: " + context));
        if (this.isDestroyed) {
            throw new IllegalStateException("Endpoint already destroyed");
        }
        this.checkPublishEndpointPermission();
        if (context instanceof HttpContext) {
            this.serverContext = (HttpContext)context;
            this.address = EndpointImpl.getAddressFromConfigAndContext(this.serverContext);
            HttpServer httpServer = this.serverContext.getHttpServer();
            httpServer.publish(this.serverContext, (Endpoint)this);
            this.isPublished = true;
        }
    }

    private static URI getAddressFromConfigAndContext(HttpContext context) {
        try {
            SPIProvider provider = SPIProviderResolver.getInstance().getProvider();
            ServerConfigFactory spi = (ServerConfigFactory)provider.getSPI(ServerConfigFactory.class);
            ServerConfig serverConfig = spi.getServerConfig();
            String host = serverConfig.getWebServiceHost();
            int port = serverConfig.getWebServicePort();
            String hostAndPort = host + (port > 0 ? ":" + port : "");
            return new URI("http://" + hostAndPort + context.getContextRoot());
        }
        catch (URISyntaxException e) {
            throw new WebServiceException("Error while getting endpoint address from context!", (Throwable)e);
        }
    }

    public void stop() {
        this.log.debug((Object)"stop");
        if (this.serverContext == null || !this.isPublished) {
            this.log.error((Object)"Endpoint not published");
        }
        try {
            if (this.serverContext != null) {
                HttpServer httpServer = this.serverContext.getHttpServer();
                httpServer.destroy(this.serverContext, (Endpoint)this);
            }
        }
        catch (Exception ex) {
            this.log.error((Object)"Cannot stop endpoint", (Throwable)ex);
        }
        this.isPublished = false;
        this.isDestroyed = true;
    }

    public boolean isPublished() {
        return this.isPublished;
    }

    public List<Source> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(List<Source> list) {
        this.log.info((Object)"Ignore metadata, not implemented");
        this.metadata = list;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        this.log.info((Object)"Ignore executor, not implemented");
        this.executor = executor;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> map) {
        this.properties = map;
    }

    private void checkPublishEndpointPermission() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)ENDPOINT_PUBLISH_PERMISSION);
        }
    }

    public EndpointReference getEndpointReference(Element ... referenceParameters) {
        return this.getEndpointReference(W3CEndpointReference.class, referenceParameters);
    }

    public <T extends EndpointReference> T getEndpointReference(Class<T> clazz, Element ... referenceParameters) {
        if (this.isDestroyed || !this.isPublished) {
            throw new WebServiceException("Cannot get EPR for an unpubblished or already destroyed endpoint!");
        }
        if (this.getBinding() instanceof HTTPBinding) {
            throw new UnsupportedOperationException("Cannot get epr when using the XML/HTTP binding");
        }
        W3CEndpointReferenceBuilder builder = new W3CEndpointReferenceBuilder();
        builder.address(this.address.toString());
        builder.wsdlDocumentLocation(this.address.toString() + "?wsdl");
        if (referenceParameters != null && W3CEndpointReference.class.getName().equals(clazz.getName())) {
            for (Element el : referenceParameters) {
                builder.referenceParameter(el);
            }
        }
        return EndpointReferenceUtil.transform(clazz, (EndpointReference)builder.build());
    }
}

