/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.evt;

import com.ctc.wstx.evt.WEvent;
import com.ctc.wstx.io.TextEscaper;
import java.io.IOException;
import java.io.Writer;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.Characters;

public class WCharacters
extends WEvent
implements Characters {
    final String mContent;
    final boolean mIsCData;
    final boolean mIgnorableWS;
    boolean mWhitespaceChecked = false;
    boolean mIsWhitespace = false;

    public WCharacters(Location loc, String content, boolean cdata) {
        super(loc);
        this.mContent = content;
        this.mIsCData = cdata;
        this.mIgnorableWS = false;
    }

    private WCharacters(Location loc, String content, boolean cdata, boolean allWS, boolean ignorableWS) {
        super(loc);
        this.mContent = content;
        this.mIsCData = cdata;
        this.mIsWhitespace = allWS;
        if (allWS) {
            this.mWhitespaceChecked = true;
            this.mIgnorableWS = ignorableWS;
        } else {
            this.mWhitespaceChecked = false;
            this.mIgnorableWS = false;
        }
    }

    public static final WCharacters createIgnorableWS(Location loc, String content) {
        return new WCharacters(loc, content, false, true, true);
    }

    public static final WCharacters createNonIgnorableWS(Location loc, String content) {
        return new WCharacters(loc, content, false, true, false);
    }

    @Override
    public Characters asCharacters() {
        return this;
    }

    @Override
    public int getEventType() {
        return this.mIsCData ? 12 : 4;
    }

    @Override
    public boolean isCharacters() {
        return true;
    }

    @Override
    public void writeAsEncodedUnicode(Writer w) throws XMLStreamException {
        try {
            if (this.mIsCData) {
                w.write("<![CDATA[");
                w.write(this.mContent);
                w.write("]]>");
            } else {
                TextEscaper.writeEscapedXMLText(w, this.mContent);
            }
        }
        catch (IOException ie) {
            this.throwFromIOE(ie);
        }
    }

    @Override
    public void writeUsing(XMLStreamWriter w) throws XMLStreamException {
        if (this.mIsCData) {
            w.writeCData(this.mContent);
        } else {
            w.writeCharacters(this.mContent);
        }
    }

    @Override
    public String getData() {
        return this.mContent;
    }

    @Override
    public boolean isCData() {
        return this.mIsCData;
    }

    @Override
    public boolean isIgnorableWhiteSpace() {
        return this.mIgnorableWS;
    }

    @Override
    public boolean isWhiteSpace() {
        if (!this.mWhitespaceChecked) {
            int i;
            this.mWhitespaceChecked = true;
            String str = this.mContent;
            int len = str.length();
            for (i = 0; i < len && str.charAt(i) <= ' '; ++i) {
            }
            this.mIsWhitespace = i == len;
        }
        return this.mIsWhitespace;
    }

    public void setWhitespaceStatus(boolean status) {
        this.mWhitespaceChecked = true;
        this.mIsWhitespace = status;
    }
}

