/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.wireformat;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import org.jboss.jms.delegate.BrowserEndpoint;
import org.jboss.jms.wireformat.BrowserNextMessageBlockResponse;
import org.jboss.jms.wireformat.Dispatcher;
import org.jboss.jms.wireformat.RequestSupport;
import org.jboss.jms.wireformat.ResponseSupport;

public class BrowserNextMessageBlockRequest
extends RequestSupport {
    private int maxMessages;

    public BrowserNextMessageBlockRequest() {
    }

    public BrowserNextMessageBlockRequest(String objectId, byte version, int maxMessages) {
        super(objectId, 503, version);
        this.maxMessages = maxMessages;
    }

    public void read(DataInputStream is) throws Exception {
        super.read(is);
        this.maxMessages = is.readInt();
    }

    public ResponseSupport serverInvoke() throws Exception {
        BrowserEndpoint endpoint = (BrowserEndpoint)Dispatcher.instance.getTarget(this.objectId);
        if (endpoint == null) {
            throw new IllegalStateException("Cannot find object in dispatcher with id " + this.objectId);
        }
        return new BrowserNextMessageBlockResponse(endpoint.nextMessageBlock(this.maxMessages));
    }

    public void write(DataOutputStream os) throws Exception {
        super.write(os);
        os.writeInt(this.maxMessages);
        os.flush();
    }
}

