/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.clientapi.util.units;

import java.text.ParseException;
import org.rhq.core.clientapi.util.units.BinaryFormatter;
import org.rhq.core.clientapi.util.units.ParseSpecifics;
import org.rhq.core.clientapi.util.units.ScaleConstants;
import org.rhq.core.clientapi.util.units.UnitNumber;
import org.rhq.core.clientapi.util.units.UnitsConstants;

public class BitRateFormatter
extends BinaryFormatter {
    protected String getTagName() {
        return "b";
    }

    protected UnitNumber parseTag(double number, String tag, int tagIdx, ParseSpecifics specifics) throws ParseException {
        ScaleConstants scale;
        if (tag.equalsIgnoreCase("b") || tag.equalsIgnoreCase("b/sec")) {
            scale = ScaleConstants.SCALE_NONE;
        } else if (tag.equalsIgnoreCase("k") || tag.equalsIgnoreCase("kb") || tag.equalsIgnoreCase("kb/sec")) {
            scale = ScaleConstants.SCALE_KILO;
        } else if (tag.equalsIgnoreCase("m") || tag.equalsIgnoreCase("mb") || tag.equalsIgnoreCase("mb/sec")) {
            scale = ScaleConstants.SCALE_MEGA;
        } else if (tag.equalsIgnoreCase("g") || tag.equalsIgnoreCase("gb") || tag.equalsIgnoreCase("gb/sec")) {
            scale = ScaleConstants.SCALE_GIGA;
        } else if (tag.equalsIgnoreCase("t") || tag.equalsIgnoreCase("tb") || tag.equalsIgnoreCase("tb/sec")) {
            scale = ScaleConstants.SCALE_TERA;
        } else if (tag.equalsIgnoreCase("p") || tag.equalsIgnoreCase("pb") || tag.equalsIgnoreCase("pb/sec")) {
            scale = ScaleConstants.SCALE_PETA;
        } else {
            throw new ParseException("Unknown bitrate type '" + tag + "'", tagIdx);
        }
        return new UnitNumber(number, UnitsConstants.UNIT_BITS, scale);
    }
}

