/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.soap;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import org.jboss.ws.core.soap.SOAPContentElement;
import org.jboss.ws.core.soap.SOAPElementImpl;
import org.jboss.wsf.common.DOMUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class SOAPHeaderElementImpl
extends SOAPContentElement
implements SOAPHeaderElement {
    public SOAPHeaderElementImpl(Name name) {
        super(name);
    }

    public SOAPHeaderElementImpl(QName qname) {
        super(qname);
    }

    public SOAPHeaderElementImpl(SOAPElementImpl element) {
        super(element);
    }

    public String getRole() {
        String headerURI = this.getParentElement().getNamespaceURI();
        if ("http://schemas.xmlsoap.org/soap/envelope/".equals(headerURI)) {
            throw new UnsupportedOperationException("SOAP 1.1 does not support the concept of Role");
        }
        Attr roleAttr = this.getAttributeNodeNS(headerURI, "role");
        return roleAttr != null ? roleAttr.getValue() : null;
    }

    public void setRole(String roleURI) {
        SOAPElement header = this.getParentElement();
        String headerURI = header.getNamespaceURI();
        if ("http://schemas.xmlsoap.org/soap/envelope/".equals(headerURI)) {
            throw new UnsupportedOperationException("SOAP 1.1 does not support the concept of Role");
        }
        this.setAttributeNS(headerURI, header.getPrefix() + ":" + "role", roleURI);
    }

    public boolean getRelay() {
        String headerURI = this.getParentElement().getNamespaceURI();
        if ("http://schemas.xmlsoap.org/soap/envelope/".equals(headerURI)) {
            throw new UnsupportedOperationException("SOAP 1.1 does not support the concept of Role");
        }
        return DOMUtils.getAttributeValueAsBoolean((Element)((Object)this), (QName)new QName(headerURI, "relay"));
    }

    public void setRelay(boolean relay) {
        SOAPElement header = this.getParentElement();
        String headerURI = header.getNamespaceURI();
        if ("http://schemas.xmlsoap.org/soap/envelope/".equals(headerURI)) {
            throw new UnsupportedOperationException("SOAP 1.1 does not support the concept of Role");
        }
        this.setAttributeNS(headerURI, header.getPrefix() + ":" + "relay", Boolean.toString(relay));
    }

    public String getActor() {
        String headerURI = this.getParentElement().getNamespaceURI();
        if (!"http://schemas.xmlsoap.org/soap/envelope/".equals(headerURI)) {
            return this.getRole();
        }
        Attr actorAttr = this.getAttributeNodeNS(headerURI, "actor");
        return actorAttr != null ? actorAttr.getValue() : null;
    }

    public void setActor(String actorURI) {
        SOAPElement header = this.getParentElement();
        String headerURI = header.getNamespaceURI();
        if ("http://schemas.xmlsoap.org/soap/envelope/".equals(headerURI)) {
            this.setAttributeNS(headerURI, header.getPrefix() + ":" + "actor", actorURI);
        } else {
            this.setRole(actorURI);
        }
    }

    public boolean getMustUnderstand() {
        String headerURI = this.getParentElement().getNamespaceURI();
        return DOMUtils.getAttributeValueAsBoolean((Element)((Object)this), (QName)new QName(headerURI, "mustUnderstand"));
    }

    public void setMustUnderstand(boolean mustUnderstand) {
        SOAPElement header = this.getParentElement();
        String headerURI = header.getNamespaceURI();
        this.setAttributeNS(headerURI, header.getPrefix() + ":" + "mustUnderstand", mustUnderstand ? "1" : "0");
    }

    public void setParentElement(SOAPElement parent) throws SOAPException {
        if (parent == null) {
            throw new SOAPException("Invalid null parent element");
        }
        if (!(parent instanceof SOAPHeader)) {
            throw new SOAPException("Invalid parent element: " + parent.getElementName());
        }
        super.setParentElement(parent);
    }

    public void writeElement(Writer writer) throws IOException {
        String xmlns2;
        String nsURI;
        String prefix;
        StringWriter strwr = new StringWriter(256);
        super.writeElement(strwr);
        SOAPHeader soapHeader = (SOAPHeader)this.getParentElement();
        SOAPEnvelope soapEnvelope = (SOAPEnvelope)soapHeader.getParentElement();
        ArrayList<String> knownNamespaces = new ArrayList<String>();
        Iterator prefixes = soapEnvelope.getNamespacePrefixes();
        while (prefixes.hasNext()) {
            prefix = (String)prefixes.next();
            nsURI = soapEnvelope.getNamespaceURI(prefix);
            xmlns2 = " xmlns:" + prefix + "='" + nsURI + "'";
            knownNamespaces.add(xmlns2);
        }
        prefixes = soapHeader.getNamespacePrefixes();
        while (prefixes.hasNext()) {
            prefix = (String)prefixes.next();
            nsURI = soapHeader.getNamespaceURI(prefix);
            xmlns2 = " xmlns:" + prefix + "='" + nsURI + "'";
            knownNamespaces.add(xmlns2);
        }
        String xmlFragment = strwr.toString();
        for (String xmlns2 : knownNamespaces) {
            int start = xmlFragment.indexOf(xmlns2);
            while (start > 0) {
                int end = start + xmlns2.length();
                xmlFragment = xmlFragment.substring(0, start) + xmlFragment.substring(end);
                start = xmlFragment.indexOf(xmlns2);
            }
        }
        writer.write(xmlFragment);
    }
}

