/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.deployers;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.helpers.AbstractSimpleRealDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.ejb.deployers.CreateDestination;
import org.jboss.kernel.spi.deployment.KernelDeployment;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeansMetaData;
import org.jboss.metadata.ejb.jboss.JBossMessageDrivenBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.system.metadata.ServiceMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateDestinationDeployer
extends AbstractSimpleRealDeployer<JBossMetaData> {
    private List<CreateDestination> factories = new CopyOnWriteArrayList<CreateDestination>();

    public CreateDestinationDeployer() {
        super(JBossMetaData.class);
        this.setOutput(JBossMetaData.class);
        this.setOutput(ServiceMetaData.class);
        this.setOutput(KernelDeployment.class);
    }

    public void addCreateDestination(CreateDestination factory) {
        if (factory == null) {
            throw new IllegalArgumentException("Null factory");
        }
        this.factories.add(factory);
    }

    public void removeCreateDestination(CreateDestination factory) {
        if (factory == null) {
            throw new IllegalArgumentException("Null factory");
        }
        this.factories.add(factory);
    }

    public void deploy(DeploymentUnit unit, JBossMetaData deployment) throws DeploymentException {
        if (this.factories.isEmpty()) {
            return;
        }
        JBossEnterpriseBeansMetaData beans = deployment.getEnterpriseBeans();
        if (beans != null && !beans.isEmpty()) {
            ArrayList<JBossMessageDrivenBeanMetaData> deployed = new ArrayList<JBossMessageDrivenBeanMetaData>();
            for (JBossEnterpriseBeanMetaData bean : beans) {
                if (!bean.isMessageDriven()) continue;
                try {
                    JBossMessageDrivenBeanMetaData messageDriven = (JBossMessageDrivenBeanMetaData)bean;
                    if (!this.isCreateDestination(unit, messageDriven)) continue;
                    this.deploy(unit, messageDriven);
                    deployed.add(messageDriven);
                }
                catch (Exception e) {
                    if (!deployed.isEmpty()) {
                        for (JBossMessageDrivenBeanMetaData messageDriven : deployed) {
                            try {
                                this.undeploy(unit, messageDriven);
                            }
                            catch (Exception t) {
                                this.log.warn((Object)("Error undeploying destination: " + messageDriven.getName()), (Throwable)t);
                            }
                        }
                    }
                    throw DeploymentException.rethrowAsDeploymentException((String)("Error deploying destination" + bean.getName()), (Throwable)e);
                }
            }
        }
    }

    public void undeploy(DeploymentUnit unit, JBossMetaData deployment) {
        if (this.factories.isEmpty()) {
            return;
        }
        JBossEnterpriseBeansMetaData beans = deployment.getEnterpriseBeans();
        if (beans != null && !beans.isEmpty()) {
            for (JBossEnterpriseBeanMetaData bean : beans) {
                if (!bean.isMessageDriven()) continue;
                try {
                    JBossMessageDrivenBeanMetaData messageDriven = (JBossMessageDrivenBeanMetaData)bean;
                    if (!this.isCreateDestination(unit, messageDriven)) continue;
                    this.undeploy(unit, messageDriven);
                }
                catch (Exception e) {
                    this.log.warn((Object)("Error undeploying destination" + bean.getName()), (Throwable)e);
                }
            }
        }
    }

    protected void deploy(DeploymentUnit unit, JBossMessageDrivenBeanMetaData mdb) throws DeploymentException {
        for (CreateDestination createDestination : this.factories) {
            Object attachment;
            if (!createDestination.getMatcher().isMatch(unit, mdb) || (attachment = createDestination.getFactory().create(unit, mdb)) == null) continue;
            unit.addAttachment(this.getAttachmentName(unit, mdb), attachment);
            return;
        }
    }

    protected void undeploy(DeploymentUnit unit, JBossMessageDrivenBeanMetaData mdb) throws DeploymentException {
        unit.removeAttachment(this.getAttachmentName(unit, mdb));
    }

    protected boolean isCreateDestination(DeploymentUnit unit, JBossMessageDrivenBeanMetaData mdb) throws DeploymentException {
        return mdb.isCreateDestination();
    }

    protected String getAttachmentName(DeploymentUnit unit, JBossMessageDrivenBeanMetaData mdb) {
        return mdb.getName() + "##Create_Destination";
    }
}

