/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.deployers;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.security.CodeSource;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipFile;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.LinkRef;
import org.apache.InstanceManager;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.Valve;
import org.apache.catalina.core.StandardContext;
import org.apache.tomcat.util.modeler.Registry;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.logging.Logger;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.naming.NonSerializableFactory;
import org.jboss.security.SecurityUtil;
import org.jboss.virtual.VirtualFile;
import org.jboss.web.WebApplication;
import org.jboss.web.deployers.AbstractWarDeployment;
import org.jboss.web.tomcat.security.JaccContextValve;
import org.jboss.web.tomcat.security.RunAsListener;
import org.jboss.web.tomcat.security.SecurityAssociationValve;
import org.jboss.web.tomcat.security.SecurityContextEstablishmentValve;
import org.jboss.web.tomcat.service.TomcatInjectionContainer;
import org.jboss.web.tomcat.service.WebCtxLoader;
import org.jboss.web.tomcat.service.deployers.DeployerConfig;
import org.jboss.web.tomcat.service.deployers.JBossContextConfig;
import org.jboss.web.tomcat.service.deployers.SecurityActions;
import org.jboss.web.tomcat.service.request.ActiveRequestResponseCacheValve;
import org.jboss.web.tomcat.service.session.AbstractJBossManager;
import org.jboss.web.tomcat.service.session.distributedcache.spi.ClusteringNotSupportedException;
import org.omg.CORBA.ORB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TomcatDeployment
extends AbstractWarDeployment {
    private static final Logger log = Logger.getLogger(TomcatDeployment.class);
    private static final String CONTEXT_CONFIG_FILE = "WEB-INF/context.xml";
    private DeployerConfig config;
    private final String[] javaVMs = new String[]{" jboss.management.local:J2EEServer=Local,j2eeType=JVM,name=localhost"};
    private final String serverName = "jboss";
    private final HashMap vhostToHostNames = new HashMap();
    private ORB orb = null;

    public ORB getORB() {
        return this.orb;
    }

    public void setORB(ORB orb) {
        this.orb = orb;
    }

    public void init(Object containerConfig) throws Exception {
        this.config = (DeployerConfig)containerConfig;
        super.setJava2ClassLoadingCompliance(this.config.isJava2ClassLoadingCompliance());
        super.setUnpackWars(this.config.isUnpackWars());
        super.setLenientEjbLink(this.config.isLenientEjbLink());
        super.setDefaultSecurityDomain(this.config.getDefaultSecurityDomain());
    }

    protected void performDeploy(WebApplication webApp, String warUrl) throws Exception {
        warUrl = URLDecoder.decode(warUrl, "UTF-8");
        webApp.setDomain(this.config.getCatalinaDomain());
        JBossWebMetaData metaData = webApp.getMetaData();
        String hostName = null;
        List vhostNames = metaData.getVirtualHosts();
        Iterator hostNames = this.mapVirtualHosts(vhostNames);
        if (hostNames.hasNext()) {
            hostName = hostNames.next().toString();
        } else {
            hostNames = this.getDefaultHosts();
            if (hostNames.hasNext()) {
                hostName = hostNames.next().toString();
            }
        }
        this.performDeployInternal(webApp, hostName, warUrl);
        while (hostNames.hasNext()) {
            String additionalHostName = hostNames.next().toString();
            this.performDeployInternal(webApp, additionalHostName, warUrl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performDeployInternal(WebApplication webApp, String hostName, String warUrlStr) throws Exception {
        Engine engine;
        JBossWebMetaData metaData = webApp.getMetaData();
        String ctxPath = metaData.getContextRoot();
        if (ctxPath.equals("/") || ctxPath.equals("/ROOT") || ctxPath.equals("")) {
            log.debug((Object)("deploy root context=" + ctxPath));
            ctxPath = "/";
            metaData.setContextRoot(ctxPath);
        }
        log.info((Object)("deploy, ctxPath=" + ctxPath));
        URL warUrl = new URL(warUrlStr);
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        metaData.setContextLoader(loader);
        StandardContext context = (StandardContext)Class.forName(this.config.getContextClassName()).newInstance();
        DeploymentUnit depUnit = webApp.getDeploymentUnit();
        TomcatInjectionContainer injectionContainer = new TomcatInjectionContainer(webApp, depUnit, (Context)context, this.getPersistenceUnitDependencyResolver());
        Loader webLoader = (Loader)depUnit.getAttachment(Loader.class);
        if (webLoader == null) {
            webLoader = this.getWebLoader(depUnit, metaData, loader, warUrl, injectionContainer);
        }
        webApp.setName(warUrl.getPath());
        webApp.setClassLoader(loader);
        webApp.setURL(warUrl);
        String objectNameS = this.config.getCatalinaDomain() + ":j2eeType=WebModule,name=//" + (hostName == null ? "localhost" : hostName) + ctxPath + ",J2EEApplication=none,J2EEServer=none";
        ObjectName objectName = new ObjectName(objectNameS);
        if (Registry.getRegistry(null, null).getMBeanServer().isRegistered(objectName)) {
            throw new DeploymentException("Web mapping already exists for deployment URL " + warUrlStr);
        }
        Registry.getRegistry(null, null).registerComponent((Object)context, objectName, this.config.getContextClassName());
        context.setConfigFile(CONTEXT_CONFIG_FILE);
        context.setInstanceManager((InstanceManager)injectionContainer);
        context.setDefaultContextXml("context.xml");
        context.setDefaultWebXml("conf/web.xml");
        context.setPublicId(metaData.getPublicID());
        String docBase = (String)depUnit.getAttachment("org.jboss.web.explicitDocBase", String.class);
        if (docBase == null) {
            docBase = warUrl.getFile();
        }
        context.setDocBase(docBase);
        if (metaData.getAlternativeDD() != null) {
            log.debug((Object)("Setting altDDName to: " + metaData.getAlternativeDD()));
            context.setAltDDName(metaData.getAlternativeDD());
        }
        context.setJavaVMs(this.javaVMs);
        context.setServer("jboss");
        context.setSaveConfig(false);
        if (webLoader != null) {
            context.setLoader(webLoader);
        } else {
            context.setParentClassLoader(loader);
        }
        context.setDelegate(webApp.getJava2ClassLoadingCompliance());
        String[] jspCP = this.getCompileClasspath(loader);
        StringBuffer classpath = new StringBuffer();
        for (int u = 0; u < jspCP.length; ++u) {
            String repository = jspCP[u];
            if (repository == null) continue;
            if (repository.startsWith("file://")) {
                repository = repository.substring(7);
            } else {
                if (!repository.startsWith("file:")) continue;
                repository = repository.substring(5);
            }
            if (repository == null) continue;
            File fp = new File(repository);
            if (!fp.isDirectory()) {
                try {
                    if (fp.getName().toLowerCase().endsWith(".xml")) continue;
                    ZipFile zip = new ZipFile(fp);
                    zip.close();
                }
                catch (IOException e) {
                    continue;
                }
            }
            if (u > 0) {
                classpath.append(File.pathSeparator);
            }
            classpath.append(repository);
        }
        context.setCompilerClasspath(classpath.toString());
        switch (metaData.getSessionCookies()) {
            case 1: {
                context.setCookies(true);
                log.debug((Object)"Enabling session cookies");
                break;
            }
            case 2: {
                context.setCookies(false);
                log.debug((Object)"Disabling session cookies");
                break;
            }
            default: {
                log.debug((Object)"Using session cookies default setting");
            }
        }
        String metaDataSecurityDomain = metaData.getSecurityDomain();
        if (metaDataSecurityDomain != null) {
            metaDataSecurityDomain = metaDataSecurityDomain.trim();
        }
        if ((engine = this.getCatalinaEngine((Context)context)) != null) {
            ActiveRequestResponseCacheValve activeReqValve = new ActiveRequestResponseCacheValve();
            engine.getPipeline().addValve((Valve)activeReqValve);
        }
        SecurityContextEstablishmentValve scevalve = new SecurityContextEstablishmentValve(metaDataSecurityDomain, SecurityUtil.unprefixSecurityDomain((String)this.config.getDefaultSecurityDomain()), SecurityActions.loadClass(this.config.getSecurityContextClassName()), this.getSecurityManagement());
        context.addValve((Valve)scevalve);
        Certificate[] certs = null;
        CodeSource cs = new CodeSource(warUrl, certs);
        JaccContextValve jaccValve = new JaccContextValve(metaData, cs);
        context.addValve((Valve)jaccValve);
        context.setConfigClass("org.jboss.web.tomcat.service.deployers.JBossContextConfig");
        context.addLifecycleListener((LifecycleListener)new EncListener(loader, webLoader, injectionContainer, webApp));
        RunAsListener.metaDataLocal.set(metaData);
        JBossContextConfig.metaDataLocal.set(metaData);
        JBossContextConfig.metaDataShared.set(this.config.getSharedMetaData());
        JBossContextConfig.deployerConfig.set(this.config);
        JBossContextConfig.kernelLocal.set(this.kernel);
        JBossContextConfig.deploymentUnitLocal.set(this.unit);
        try {
            context.start();
        }
        catch (Exception e) {
            context.destroy();
            DeploymentException.rethrowAsDeploymentException((String)("URL " + warUrlStr + " deployment failed"), (Throwable)e);
        }
        finally {
            RunAsListener.metaDataLocal.set(null);
            JBossContextConfig.metaDataLocal.set(null);
            JBossContextConfig.metaDataShared.set(null);
            JBossContextConfig.deployerConfig.set(null);
            JBossContextConfig.kernelLocal.set(null);
            JBossContextConfig.deploymentUnitLocal.set(null);
        }
        if (context.getState() != 1) {
            context.destroy();
            throw new DeploymentException("URL " + warUrlStr + " deployment failed");
        }
        if (this.config.getOverrideDistributableManager() && metaData.getDistributable() != null) {
            try {
                AbstractJBossManager manager = null;
                String managerClassName = this.config.getManagerClass();
                Class<?> managerClass = Thread.currentThread().getContextClassLoader().loadClass(managerClassName);
                manager = (AbstractJBossManager)managerClass.newInstance();
                String name = "//" + (hostName == null ? "localhost" : hostName) + ctxPath;
                manager.init(name, metaData);
                this.server.setAttribute(objectName, new Attribute("manager", manager));
                log.debug((Object)("Enabled clustering support for ctxPath=" + ctxPath));
            }
            catch (ClusteringNotSupportedException e) {
                log.warn((Object)("Failed to setup clustering, clustering disabled. ClusteringNotSupportedException: " + e.getMessage()));
            }
            catch (NoClassDefFoundError ncdf) {
                log.debug((Object)"Classes needed for clustered webapp unavailable", (Throwable)ncdf);
                log.warn((Object)("Failed to setup clustering, clustering disabled. NoClassDefFoundError: " + ncdf.getMessage()));
            }
            catch (Throwable t) {
                log.error((Object)"Failed to setup clustering, clustering disabled. Exception: ", t);
            }
        }
        SecurityAssociationValve valve = new SecurityAssociationValve(metaData, this.config.getSecurityManagerService());
        valve.setSubjectAttributeName(this.config.getSubjectAttributeName());
        this.server.invoke(objectName, "addValve", new Object[]{valve}, new String[]{"org.apache.catalina.Valve"});
        webApp.setAppData((Object)objectName);
        log.debug((Object)("Initialized: " + webApp + " " + objectName));
    }

    public Loader getWebLoader(DeploymentUnit unit, JBossWebMetaData metaData, ClassLoader loader, URL rl, TomcatInjectionContainer injectionContainer) throws MalformedURLException {
        ArrayList<URL> classpath = (ArrayList<URL>)unit.getAttachment("org.jboss.web.expandedWarClasspath", List.class);
        if (classpath == null && unit instanceof VFSDeploymentUnit) {
            VFSDeploymentUnit vfsUnit = (VFSDeploymentUnit)unit;
            try {
                VirtualFile classes = vfsUnit.getFile("WEB-INF/classes");
                URL vfsURL = classes.toURL();
                String vfsurl = vfsURL.toString();
                if (vfsurl.startsWith("vfs")) {
                    vfsURL = new URL(vfsurl.substring(3));
                }
                classpath = new ArrayList<URL>();
                classpath.add(vfsURL);
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        WebCtxLoader jbossLoader = new WebCtxLoader(loader, injectionContainer);
        if (classpath != null) {
            jbossLoader.setClasspath((List<URL>)classpath);
        }
        WebCtxLoader webLoader = jbossLoader;
        return webLoader;
    }

    protected void performUndeploy(WebApplication warInfo, String warUrl) throws Exception {
        if (warInfo == null) {
            log.debug((Object)("performUndeploy, no WebApplication found for URL " + warUrl));
            return;
        }
        log.info((Object)("undeploy, ctxPath=" + warInfo.getMetaData().getContextRoot()));
        JBossWebMetaData metaData = warInfo.getMetaData();
        String hostName = null;
        List vhostNames = metaData.getVirtualHosts();
        Iterator hostNames = this.mapVirtualHosts(vhostNames);
        if (hostNames.hasNext()) {
            hostName = hostNames.next().toString();
        } else {
            hostNames = this.getDefaultHosts();
            if (hostNames.hasNext()) {
                hostName = hostNames.next().toString();
            }
        }
        this.performUndeployInternal(warInfo, hostName, warUrl);
        while (hostNames.hasNext()) {
            String additionalHostName = hostNames.next().toString();
            this.performUndeployInternal(warInfo, additionalHostName, warUrl);
        }
    }

    protected void performUndeployInternal(WebApplication warInfo, String hostName, String warUrlStr) throws Exception {
        JBossWebMetaData metaData = warInfo.getMetaData();
        String ctxPath = metaData.getContextRoot();
        MBeanServer server = MBeanServerLocator.locateJBoss();
        if (server == null) {
            return;
        }
        ObjectName objectName = new ObjectName(this.config.getCatalinaDomain() + ":j2eeType=WebModule,name=//" + (hostName == null ? "localhost" : hostName) + ctxPath + ",J2EEApplication=none,J2EEServer=none");
        if (server.isRegistered(objectName)) {
            server.invoke(objectName, "destroy", new Object[0], new String[0]);
        }
    }

    protected synchronized Iterator mapVirtualHosts(List<String> vhostNames) throws Exception {
        if (this.vhostToHostNames.size() == 0) {
            String hostQuery = this.config.getCatalinaDomain() + ":type=Host,*";
            ObjectName query = new ObjectName(hostQuery);
            Set<ObjectName> hosts = this.server.queryNames(query, null);
            for (ObjectName host : hosts) {
                String name = host.getKeyProperty("host");
                if (name == null) continue;
                this.vhostToHostNames.put(name, name);
                String[] aliases = (String[])this.server.invoke(host, "findAliases", null, null);
                int count = aliases != null ? aliases.length : 0;
                for (int n = 0; n < count; ++n) {
                    this.vhostToHostNames.put(aliases[n], name);
                }
            }
        }
        HashSet<String> hosts = new HashSet<String>();
        if (vhostNames != null) {
            for (String vhost : vhostNames) {
                String host = (String)this.vhostToHostNames.get(vhost);
                if (host == null) {
                    log.warn((Object)("Failed to map vhost: " + vhost));
                    host = vhost;
                }
                hosts.add(host);
            }
        }
        return hosts.iterator();
    }

    protected synchronized Iterator getDefaultHosts() throws Exception {
        HashSet<String> defaultHosts = new HashSet<String>();
        String engineQuery = this.config.getCatalinaDomain() + ":type=Engine,*";
        ObjectName query = new ObjectName(engineQuery);
        Set<ObjectName> engines = this.server.queryNames(query, null);
        for (ObjectName engine : engines) {
            String defaultHost = (String)this.server.getAttribute(engine, "defaultHost");
            if (defaultHost == null) continue;
            defaultHosts.add(defaultHost);
        }
        return defaultHosts.iterator();
    }

    private Engine getCatalinaEngine(Context context) {
        Container parentContainer;
        for (parentContainer = context.getParent(); parentContainer != null && !(parentContainer instanceof Engine); parentContainer = parentContainer.getParent()) {
        }
        return (Engine)parentContainer;
    }

    public class EncListener
    implements LifecycleListener {
        protected ClassLoader loader;
        protected Loader webLoader;
        protected WebApplication webApp;
        protected JBossWebMetaData metaData;
        protected DeploymentUnit unit;
        protected TomcatInjectionContainer injectionContainer;

        public EncListener(ClassLoader loader, Loader webLoader, TomcatInjectionContainer injectionContainer, WebApplication webApp) {
            this.loader = loader;
            this.webLoader = webLoader;
            this.injectionContainer = injectionContainer;
            this.webApp = webApp;
            this.metaData = webApp.getMetaData();
            this.unit = webApp.getDeploymentUnit();
        }

        public void lifecycleEvent(LifecycleEvent event) {
            if (event.getType().equals("after_start")) {
                this.metaData.setContextLoader(this.webLoader.getClassLoader());
                Thread currentThread = Thread.currentThread();
                ClassLoader currentLoader = currentThread.getContextClassLoader();
                try {
                    log.debug((Object)("Creating ENC using ClassLoader: " + this.loader));
                    for (ClassLoader parent = this.loader.getParent(); parent != null; parent = parent.getParent()) {
                        log.debug((Object)(".." + parent));
                    }
                    currentThread.setContextClassLoader(this.webLoader.getClassLoader());
                    this.metaData.setENCLoader(this.webLoader.getClassLoader());
                    InitialContext iniCtx = new InitialContext();
                    javax.naming.Context envCtx = (javax.naming.Context)iniCtx.lookup("java:comp");
                    ORB orb = null;
                    try {
                        ObjectName ORB_NAME = new ObjectName("jboss:service=CorbaORB");
                        orb = (ORB)TomcatDeployment.this.server.getAttribute(ORB_NAME, "ORB");
                        if (orb != null) {
                            NonSerializableFactory.rebind((javax.naming.Context)envCtx, (String)"ORB", (Object)orb);
                            log.debug((Object)"Bound java:comp/ORB");
                        }
                    }
                    catch (Throwable t) {
                        log.debug((Object)("Unable to retrieve orb: " + t.toString()));
                    }
                    envCtx.bind("TransactionSynchronizationRegistry", (Object)new LinkRef("java:TransactionSynchronizationRegistry"));
                    log.debug((Object)"Linked java:comp/TransactionSynchronizationRegistry to JNDI name: java:TransactionSynchronizationRegistry");
                    envCtx.bind("UserTransaction", (Object)new LinkRef("UserTransaction"));
                    log.debug((Object)"Linked java:comp/UserTransaction to JNDI name: UserTransaction");
                    envCtx = envCtx.createSubcontext("env");
                    this.injectionContainer.populateEnc(this.webLoader.getClassLoader());
                    currentThread.setContextClassLoader(this.webLoader.getClassLoader());
                    String securityDomain = this.metaData.getSecurityDomain();
                    log.debug((Object)"linkSecurityDomain");
                    TomcatDeployment.this.linkSecurityDomain(securityDomain, envCtx);
                }
                catch (Throwable t) {
                    log.error((Object)"ENC setup failed", t);
                    throw new RuntimeException(t);
                }
                finally {
                    currentThread.setContextClassLoader(currentLoader);
                    log.debug((Object)"injectionContainer enabled and processing beginning");
                    this.injectionContainer.setClassLoader(this.webLoader.getClassLoader());
                    this.injectionContainer.processMetadata();
                }
            }
        }
    }
}

