/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.client.delegate;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.jms.JMSException;
import org.jboss.aop.Advised;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.ClassInstanceAdvisor;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.MethodInfo;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.instrument.Untransformable;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.InvocationBase;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.jms.client.container.JMSClientVMIdentifier;
import org.jboss.jms.client.delegate.ClientConnectionFactoryDelegate;
import org.jboss.jms.client.delegate.DelegateSupport;
import org.jboss.jms.client.plugin.LoadBalancingPolicy;
import org.jboss.jms.client.remoting.ConnectionFactoryCallbackHandler;
import org.jboss.jms.client.remoting.JMSRemotingConnection;
import org.jboss.jms.delegate.ConnectionFactoryDelegate;
import org.jboss.jms.delegate.CreateConnectionResult;
import org.jboss.jms.delegate.IDBlock;
import org.jboss.jms.delegate.TopologyResult;
import org.jboss.jms.exception.MessagingNetworkFailureException;
import org.jboss.jms.wireformat.ConnectionFactoryAddCallbackRequest;
import org.jboss.jms.wireformat.ConnectionFactoryGetTopologyRequest;
import org.jboss.jms.wireformat.ConnectionFactoryGetTopologyResponse;
import org.jboss.jms.wireformat.ConnectionFactoryRemoveCallbackRequest;
import org.jboss.logging.Logger;
import org.jboss.messaging.util.Version;
import org.jboss.messaging.util.WeakHashSet;

public class ClientClusteredConnectionFactoryDelegate
extends DelegateSupport
implements Serializable,
ConnectionFactoryDelegate,
Advised {
    private static final long serialVersionUID = 8286850860206289277L;
    private static final Logger log;
    private static boolean trace;
    private transient JMSRemotingConnection remoting;
    private transient ClientConnectionFactoryDelegate currentDelegate;
    private String uniqueName;
    private ClientConnectionFactoryDelegate[] delegates;
    private Map failoverMap;
    private LoadBalancingPolicy loadBalancingPolicy;
    private boolean supportsFailover;
    private boolean supportsLoadBalancing;
    private boolean enableOrderingGroup;
    private String defaultOrderingGroupName;
    static FinalizerShutdownHook finalizerHook;
    private static /* synthetic */ ClassAdvisor aop$classAdvisor$aop;
    protected transient /* synthetic */ ClassInstanceAdvisor _instanceAdvisor;
    private static /* synthetic */ WeakReference aop$MethodInfo_getClientAOPStack7161396531404689859;
    private static /* synthetic */ WeakReference aop$MethodInfo_createConnectionDelegate_N_3019492359065420858;
    private static /* synthetic */ WeakReference aop$MethodInfo_getTopology7611120934159013485;

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.establishCallback(false);
    }

    public synchronized void establishCallback(boolean isConnFailure) {
        log.debug((Object)" Establishing CFCallback\n");
        for (int server = this.delegates.length - 1; server >= 0; --server) {
            if (trace) {
                log.trace((Object)"Closing current callback");
            }
            this.closeCallback(isConnFailure);
            if (trace) {
                log.trace((Object)("Trying communication on server(" + server + ")=" + this.delegates[server].getServerLocatorURI()));
            }
            try {
                this.remoting = new JMSRemotingConnection(this.delegates[server].getServerLocatorURI(), true, this.delegates[server].getStrictTck(), this.delegates[server].isSendAcksAsync());
                this.remoting.start();
                this.currentDelegate = this.delegates[server];
                if (trace) {
                    log.trace((Object)"Adding callback");
                }
                this.addCallback(this.delegates[server]);
                if (trace) {
                    log.trace((Object)"Getting topology");
                }
                TopologyResult topology = this.getTopology();
                if (trace) {
                    log.trace((Object)("delegates.size = " + topology.getDelegates().length));
                }
                this.addShutdownHook();
                break;
            }
            catch (Throwable e) {
                log.debug((Object)("Server communication to server[" + server + "] (" + this.delegates[server].getServerLocatorURI() + ") during establishCallback was broken, " + "trying the next one"), e);
                if (this.remoting == null) continue;
                this.remoting.stop();
                this.remoting = null;
                this.currentDelegate = null;
                continue;
            }
        }
    }

    private void addCallback(ClientConnectionFactoryDelegate delegate) throws Throwable {
        this.remoting.getCallbackManager().setConnectionfactoryCallbackHandler(new ConnectionFactoryCallbackHandler(this, this.remoting));
        ConnectionFactoryAddCallbackRequest request = new ConnectionFactoryAddCallbackRequest(JMSClientVMIdentifier.instance, this.remoting.getRemotingClient().getSessionId(), delegate.getID(), Version.instance().getProviderIncrementingVersion());
        this.remoting.getRemotingClient().invoke((Object)request, null);
    }

    private void addShutdownHook() {
        finalizerHook.addDelegate(this);
    }

    private void removeCallback() throws Throwable {
        ConnectionFactoryRemoveCallbackRequest request = new ConnectionFactoryRemoveCallbackRequest(JMSClientVMIdentifier.instance, this.remoting.getRemotingClient().getSessionId(), this.currentDelegate.getID(), Version.instance().getProviderIncrementingVersion());
        this.remoting.getRemotingClient().invoke((Object)request, null);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.closeCallback(false);
    }

    public void closeCallback(boolean isConnFailure) {
        if (this.remoting != null) {
            try {
                this.removeCallback();
            }
            catch (Throwable warn) {
                log.debug((Object)warn, warn);
            }
            try {
                this.remoting.removeConnectionListener();
                if (isConnFailure) {
                    this.remoting.setFailed();
                } else {
                    this.remoting.stop();
                }
                this.currentDelegate = null;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.remoting = null;
        }
    }

    public ClientClusteredConnectionFactoryDelegate(String uniqueName, ClientConnectionFactoryDelegate[] delegates, Map failoverMap, LoadBalancingPolicy loadBalancingPolicy, boolean supportsFailover, boolean enableOrderingGroup, String defaultOrderingGroupName) {
        this.uniqueName = uniqueName;
        this.delegates = delegates;
        this.failoverMap = failoverMap;
        this.loadBalancingPolicy = loadBalancingPolicy;
        this.supportsFailover = supportsFailover;
        this.setEnableOrderingGroup(enableOrderingGroup);
        this.setDefaultOrderingGroupName(defaultOrderingGroupName);
    }

    public synchronized /* synthetic */ byte[] org$jboss$jms$client$delegate$ClientClusteredConnectionFactoryDelegate$getClientAOPStack$aop() throws JMSException {
        log.trace((Object)("Getting AOP stack, there are " + this.delegates.length + " delegates to choose from"));
        for (int server = 0; server < this.delegates.length; ++server) {
            try {
                ClientConnectionFactoryDelegate aopStackProvider = this.delegates[server];
                log.trace((Object)("getting AOP stack from " + aopStackProvider));
                return aopStackProvider.getClientAOPStack();
            }
            catch (MessagingNetworkFailureException e) {
                log.debug((Object)("Server" + server + " was broken, loading AOP from next delegate"), (Throwable)((Object)e));
                continue;
            }
        }
        throw new MessagingNetworkFailureException("Failed to download and/or install client side AOP stack");
    }

    public /* synthetic */ CreateConnectionResult org$jboss$jms$client$delegate$ClientClusteredConnectionFactoryDelegate$createConnectionDelegate$aop(String username, String password, int failedNodeID) throws JMSException {
        throw new IllegalStateException("This invocation should not be handled here!");
    }

    public IDBlock getIdBlock(int size) throws JMSException {
        throw new IllegalStateException("This invocation should not be handled here!");
    }

    public ClientConnectionFactoryDelegate[] getDelegates() {
        return this.delegates;
    }

    public void setDelegates(ClientConnectionFactoryDelegate[] dels) {
        this.delegates = dels;
        this.loadBalancingPolicy.updateView(dels);
    }

    public Map getFailoverMap() {
        return this.failoverMap;
    }

    public void setFailoverMap(Map failoverMap) {
        this.failoverMap = failoverMap;
    }

    public LoadBalancingPolicy getLoadBalancingPolicy() {
        return this.loadBalancingPolicy;
    }

    public boolean isSupportsFailover() {
        return this.supportsFailover;
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    public /* synthetic */ TopologyResult org$jboss$jms$client$delegate$ClientClusteredConnectionFactoryDelegate$getTopology$aop() throws JMSException {
        try {
            ConnectionFactoryGetTopologyRequest request = new ConnectionFactoryGetTopologyRequest(this.currentDelegate.getID());
            ConnectionFactoryGetTopologyResponse response = (ConnectionFactoryGetTopologyResponse)this.remoting.getRemotingClient().invoke((Object)request, null);
            TopologyResult topology = (TopologyResult)response.getResponse();
            this.updateFailoverInfo(topology.getDelegates(), topology.getFailoverMap());
            return topology;
        }
        catch (Throwable e) {
            throw this.handleThrowable(e);
        }
    }

    public void setSupportsFailover(boolean failover) {
        this.supportsFailover = failover;
    }

    public synchronized void updateFailoverInfo(ClientConnectionFactoryDelegate[] delegates, Map newFailoverMap) {
        log.trace((Object)("Updating failover info " + delegates.length + " map " + newFailoverMap));
        this.delegates = delegates;
        this.failoverMap.putAll(newFailoverMap);
        this.loadBalancingPolicy.updateView(delegates);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ClusteredConnectionFactoryDelegate[");
        if (this.delegates == null) {
            sb.append("-]");
        } else {
            sb.append("SIDs={");
            for (int i = 0; i < this.delegates.length; ++i) {
                sb.append(this.delegates[i].getServerID());
                if (i >= this.delegates.length - 1) continue;
                sb.append(',');
            }
            sb.append("}]");
        }
        return sb.toString();
    }

    public void setEnableOrderingGroup(boolean enableOrderingGroup) {
        this.enableOrderingGroup = enableOrderingGroup;
    }

    public boolean isEnableOrderingGroup() {
        return this.enableOrderingGroup;
    }

    public void setDefaultOrderingGroupName(String defaultOrderingGroupName) {
        this.defaultOrderingGroupName = defaultOrderingGroupName;
    }

    public String getDefaultOrderingGroupName() {
        return this.defaultOrderingGroupName;
    }

    static {
        aop$classAdvisor$aop = AspectManager.instance(Class.forName("org.jboss.jms.client.delegate.ClientClusteredConnectionFactoryDelegate")).getAdvisor(Class.forName("org.jboss.jms.client.delegate.ClientClusteredConnectionFactoryDelegate"));
        log = Logger.getLogger(ClientClusteredConnectionFactoryDelegate.class);
        trace = log.isTraceEnabled();
        finalizerHook = new FinalizerShutdownHook();
        Runtime.getRuntime().addShutdownHook(finalizerHook);
    }

    public /* synthetic */ Advisor _getAdvisor() {
        return aop$classAdvisor$aop;
    }

    public /* synthetic */ InstanceAdvisor _getInstanceAdvisor() {
        ClientClusteredConnectionFactoryDelegate clientClusteredConnectionFactoryDelegate = this;
        synchronized (clientClusteredConnectionFactoryDelegate) {
            if (this._instanceAdvisor == null) {
                this._instanceAdvisor = new ClassInstanceAdvisor((Object)this);
            }
            return this._instanceAdvisor;
        }
    }

    public /* synthetic */ void _setInstanceAdvisor(InstanceAdvisor instanceAdvisor) {
        ClientClusteredConnectionFactoryDelegate clientClusteredConnectionFactoryDelegate = this;
        synchronized (clientClusteredConnectionFactoryDelegate) {
            this._instanceAdvisor = (ClassInstanceAdvisor)instanceAdvisor;
        }
    }

    public synchronized byte[] getClientAOPStack() throws JMSException {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_getClientAOPStack7161396531404689859.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            getClientAOPStack_7161396531404689859 getClientAOPStack_71613965314046898592 = new getClientAOPStack_7161396531404689859(methodInfo, interceptorArray);
            getClientAOPStack_71613965314046898592.setTargetObject(this);
            getClientAOPStack_71613965314046898592.typedTargetObject = this;
            getClientAOPStack_71613965314046898592.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (byte[])getClientAOPStack_71613965314046898592.invokeNext();
        }
        return this.org$jboss$jms$client$delegate$ClientClusteredConnectionFactoryDelegate$getClientAOPStack$aop();
    }

    public CreateConnectionResult createConnectionDelegate(String string, String string2, int n) throws JMSException {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_createConnectionDelegate_N_3019492359065420858.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            createConnectionDelegate_N3019492359065420858 createConnectionDelegate_N30194923590654208582 = new createConnectionDelegate_N3019492359065420858(methodInfo, interceptorArray);
            createConnectionDelegate_N30194923590654208582.arg0 = string;
            createConnectionDelegate_N30194923590654208582.arg1 = string2;
            createConnectionDelegate_N30194923590654208582.arg2 = n;
            createConnectionDelegate_N30194923590654208582.setTargetObject(this);
            createConnectionDelegate_N30194923590654208582.typedTargetObject = this;
            createConnectionDelegate_N30194923590654208582.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (CreateConnectionResult)createConnectionDelegate_N30194923590654208582.invokeNext();
        }
        return this.org$jboss$jms$client$delegate$ClientClusteredConnectionFactoryDelegate$createConnectionDelegate$aop(string, string2, n);
    }

    public TopologyResult getTopology() throws JMSException {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_getTopology7611120934159013485.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            getTopology_7611120934159013485 getTopology_76111209341590134852 = new getTopology_7611120934159013485(methodInfo, interceptorArray);
            getTopology_76111209341590134852.setTargetObject(this);
            getTopology_76111209341590134852.typedTargetObject = this;
            getTopology_76111209341590134852.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (TopologyResult)getTopology_76111209341590134852.invokeNext();
        }
        return this.org$jboss$jms$client$delegate$ClientClusteredConnectionFactoryDelegate$getTopology$aop();
    }

    static class FinalizerShutdownHook
    extends Thread {
        Set<ClientClusteredConnectionFactoryDelegate> delegates = Collections.synchronizedSet(new WeakHashSet());

        public void addDelegate(ClientClusteredConnectionFactoryDelegate delegate) {
            this.delegates.add(delegate);
        }

        public void run() {
            for (ClientClusteredConnectionFactoryDelegate delegate : this.delegates) {
                try {
                    delegate.finalize();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public static class getClientAOPStack_7161396531404689859
    extends MethodInvocation
    implements Untransformable {
        public ClientClusteredConnectionFactoryDelegate typedTargetObject;

        public getClientAOPStack_7161396531404689859(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public getClientAOPStack_7161396531404689859(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public getClientAOPStack_7161396531404689859(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public getClientAOPStack_7161396531404689859() {
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[0];
            return this.arguments;
        }

        final void enforceArgsConsistency() {
        }

        public Object invokeTarget() throws Throwable {
            this.enforceArgsConsistency();
            return this.typedTargetObject.org$jboss$jms$client$delegate$ClientClusteredConnectionFactoryDelegate$getClientAOPStack$aop();
        }

        public Invocation copy() {
            getClientAOPStack_7161396531404689859 getClientAOPStack_71613965314046898592 = new getClientAOPStack_7161396531404689859(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            getClientAOPStack_71613965314046898592.arguments = this.arguments;
            ((InvocationBase)getClientAOPStack_71613965314046898592).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)getClientAOPStack_71613965314046898592).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)getClientAOPStack_71613965314046898592).instanceResolver = ((InvocationBase)this).instanceResolver;
            getClientAOPStack_71613965314046898592.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)getClientAOPStack_71613965314046898592).targetObject = ((InvocationBase)this).targetObject;
            return getClientAOPStack_71613965314046898592;
        }
    }

    public static class createConnectionDelegate_N3019492359065420858
    extends MethodInvocation
    implements Untransformable {
        boolean inconsistentArgs = false;
        public String arg0;
        public String arg1;
        public int arg2;
        public ClientClusteredConnectionFactoryDelegate typedTargetObject;

        public createConnectionDelegate_N3019492359065420858(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public createConnectionDelegate_N3019492359065420858(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public createConnectionDelegate_N3019492359065420858(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public createConnectionDelegate_N3019492359065420858() {
        }

        public Object[] getArguments() {
            this.inconsistentArgs = true;
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[3];
            this.arguments[0] = this.arg0;
            this.arguments[1] = this.arg1;
            new Integer(this.arg2);
            return this.arguments;
        }

        public void setArguments(Object[] objectArray) {
            this.inconsistentArgs = true;
            this.arguments = objectArray;
        }

        final void enforceArgsConsistency() {
            if (this.inconsistentArgs) {
                this.arg0 = (String)this.arguments[0];
                this.arg1 = (String)this.arguments[1];
                this.arg2 = (Integer)this.arguments[2];
            }
        }

        public Object invokeTarget() throws Throwable {
            this.enforceArgsConsistency();
            return this.typedTargetObject.org$jboss$jms$client$delegate$ClientClusteredConnectionFactoryDelegate$createConnectionDelegate$aop(this.arg0, this.arg1, this.arg2);
        }

        public Invocation copy() {
            createConnectionDelegate_N3019492359065420858 createConnectionDelegate_N30194923590654208582 = new createConnectionDelegate_N3019492359065420858(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            createConnectionDelegate_N30194923590654208582.arguments = this.arguments;
            ((InvocationBase)createConnectionDelegate_N30194923590654208582).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)createConnectionDelegate_N30194923590654208582).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)createConnectionDelegate_N30194923590654208582).instanceResolver = ((InvocationBase)this).instanceResolver;
            createConnectionDelegate_N30194923590654208582.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)createConnectionDelegate_N30194923590654208582).targetObject = ((InvocationBase)this).targetObject;
            createConnectionDelegate_N30194923590654208582.arg0 = this.arg0;
            createConnectionDelegate_N30194923590654208582.arg1 = this.arg1;
            createConnectionDelegate_N30194923590654208582.arg2 = this.arg2;
            return createConnectionDelegate_N30194923590654208582;
        }
    }

    public static class getTopology_7611120934159013485
    extends MethodInvocation
    implements Untransformable {
        public ClientClusteredConnectionFactoryDelegate typedTargetObject;

        public getTopology_7611120934159013485(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public getTopology_7611120934159013485(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public getTopology_7611120934159013485(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public getTopology_7611120934159013485() {
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[0];
            return this.arguments;
        }

        final void enforceArgsConsistency() {
        }

        public Object invokeTarget() throws Throwable {
            this.enforceArgsConsistency();
            return this.typedTargetObject.org$jboss$jms$client$delegate$ClientClusteredConnectionFactoryDelegate$getTopology$aop();
        }

        public Invocation copy() {
            getTopology_7611120934159013485 getTopology_76111209341590134852 = new getTopology_7611120934159013485(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            getTopology_76111209341590134852.arguments = this.arguments;
            ((InvocationBase)getTopology_76111209341590134852).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)getTopology_76111209341590134852).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)getTopology_76111209341590134852).instanceResolver = ((InvocationBase)this).instanceResolver;
            getTopology_76111209341590134852.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)getTopology_76111209341590134852).targetObject = ((InvocationBase)this).targetObject;
            return getTopology_76111209341590134852;
        }
    }
}

