/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.client.remoting;

import java.lang.ref.WeakReference;
import org.jboss.jms.client.delegate.ClientClusteredConnectionFactoryDelegate;
import org.jboss.jms.client.remoting.JMSRemotingConnection;
import org.jboss.jms.wireformat.ConnectionFactoryUpdate;
import org.jboss.logging.Logger;
import org.jboss.remoting.Client;
import org.jboss.remoting.ConnectionListener;

public class ConnectionFactoryCallbackHandler {
    private static final Logger log = Logger.getLogger(ConnectionFactoryCallbackHandler.class);
    private WeakReference<ClientClusteredConnectionFactoryDelegate> delegateRef;
    private JMSRemotingConnection remotingConnection;
    private static boolean trace = log.isTraceEnabled();

    public ConnectionFactoryCallbackHandler(ClientClusteredConnectionFactoryDelegate cfDelegate, JMSRemotingConnection remotingConnection) {
        this.delegateRef = new WeakReference<ClientClusteredConnectionFactoryDelegate>(cfDelegate);
        this.remotingConnection = remotingConnection;
        this.remotingConnection.addPlainConnectionListener(new CallbackConnectionListener());
    }

    public void handleMessage(Object message) {
        if (trace) {
            log.trace((Object)(this + " handling " + message));
        }
        ConnectionFactoryUpdate viewChange = (ConnectionFactoryUpdate)message;
        ClientClusteredConnectionFactoryDelegate delegate = (ClientClusteredConnectionFactoryDelegate)this.delegateRef.get();
        if (delegate != null) {
            delegate.updateFailoverInfo(viewChange.getTopology().getDelegates(), viewChange.getTopology().getFailoverMap());
        }
    }

    public String toString() {
        return "ConnectionFactoryCallbackHandler[" + this.delegateRef.get() + "]";
    }

    class CallbackConnectionListener
    implements ConnectionListener {
        CallbackConnectionListener() {
        }

        public void handleConnectionException(Throwable throwable, Client client) {
            ClientClusteredConnectionFactoryDelegate delegate = (ClientClusteredConnectionFactoryDelegate)ConnectionFactoryCallbackHandler.this.delegateRef.get();
            if (delegate != null) {
                delegate.establishCallback(true);
            }
        }
    }
}

