/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.server.plugin;

import javax.transaction.TransactionManager;
import org.jboss.jms.server.plugin.JDBCJMSUserManager;
import org.jboss.jms.server.plugin.contract.JMSUserManager;
import org.jboss.messaging.core.contract.MessagingComponent;
import org.jboss.messaging.core.jmx.JDBCServiceSupport;
import org.jboss.messaging.util.ExceptionUtil;

public class JDBCJMSUserManagerService
extends JDBCServiceSupport {
    private JMSUserManager userManager;
    private boolean started;

    public MessagingComponent getInstance() {
        return this.userManager;
    }

    protected synchronized void startService() throws Exception {
        if (this.started) {
            throw new IllegalStateException("Service is already started");
        }
        super.startService();
        try {
            TransactionManager tm = this.getTransactionManagerReference();
            this.userManager = new JDBCJMSUserManager(this.ds, tm, this.sqlProperties, this.createTablesOnStartup, this.maxRetry, this.retryInterval, this.retryOnConnectionFailure);
            this.userManager.start();
            this.started = true;
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMXInvocation(t, (Object)((Object)this) + " startService");
        }
    }

    protected void stopService() throws Exception {
        if (!this.started) {
            throw new IllegalStateException("Service is not started");
        }
        super.stopService();
        try {
            this.userManager.stop();
            this.started = false;
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMXInvocation(t, (Object)((Object)this) + " startService");
        }
    }
}

