/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.wireformat;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import org.jboss.jms.delegate.ConnectionEndpoint;
import org.jboss.jms.wireformat.Dispatcher;
import org.jboss.jms.wireformat.RequestSupport;
import org.jboss.jms.wireformat.ResponseSupport;

public class ConnectionSetClientIDRequest
extends RequestSupport {
    private String clientID;

    public ConnectionSetClientIDRequest() {
    }

    public ConnectionSetClientIDRequest(String objectId, byte version, String clientID) {
        super(objectId, 203, version);
        this.clientID = clientID;
    }

    public void read(DataInputStream is) throws Exception {
        super.read(is);
        this.clientID = is.readUTF();
    }

    public ResponseSupport serverInvoke() throws Exception {
        ConnectionEndpoint endpoint = (ConnectionEndpoint)Dispatcher.instance.getTarget(this.objectId);
        if (endpoint == null) {
            throw new IllegalStateException("Cannot find object in dispatcher with id " + this.objectId);
        }
        endpoint.setClientID(this.clientID);
        return null;
    }

    public void write(DataOutputStream os) throws Exception {
        super.write(os);
        os.writeUTF(this.clientID);
        os.flush();
    }
}

