/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.impl.tx;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.transaction.xa.Xid;
import org.jboss.logging.Logger;
import org.jboss.messaging.core.contract.Binding;
import org.jboss.messaging.core.contract.Delivery;
import org.jboss.messaging.core.contract.Message;
import org.jboss.messaging.core.contract.MessageReference;
import org.jboss.messaging.core.contract.MessageStore;
import org.jboss.messaging.core.contract.MessagingComponent;
import org.jboss.messaging.core.contract.PersistenceManager;
import org.jboss.messaging.core.contract.PostOffice;
import org.jboss.messaging.core.contract.Queue;
import org.jboss.messaging.core.impl.RotatingID;
import org.jboss.messaging.core.impl.SimpleDelivery;
import org.jboss.messaging.core.impl.tx.PreparedTxInfo;
import org.jboss.messaging.core.impl.tx.Transaction;
import org.jboss.messaging.core.impl.tx.TransactionException;
import org.jboss.messaging.core.impl.tx.TxCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionRepository
implements MessagingComponent {
    private static final Logger log = Logger.getLogger(TransactionRepository.class);
    private boolean trace = log.isTraceEnabled();
    private Map map;
    private PersistenceManager persistenceManager;
    protected MessageStore messageStore;
    private PostOffice postOffice;
    private RotatingID txID;

    public TransactionRepository(PersistenceManager persistenceManager, MessageStore store, int nodeID) {
        this.persistenceManager = persistenceManager;
        this.messageStore = store;
        this.map = new ConcurrentHashMap();
        this.txID = new RotatingID(nodeID);
    }

    public void injectPostOffice(PostOffice po) {
        this.postOffice = po;
    }

    @Override
    public void start() throws Exception {
    }

    @Override
    public void stop() throws Exception {
    }

    public synchronized List recoverPreparedTransactions() {
        if (this.trace) {
            log.trace((Object)(this + " recoverPreparedTransactions()"));
        }
        ArrayList<Xid> prepared = new ArrayList<Xid>();
        for (Transaction tx : this.map.values()) {
            if (tx.getXid() == null || tx.getState() != 1) continue;
            try {
                if (this.trace) {
                    log.trace((Object)("Loading and handling refs and acks to the Tx " + tx));
                }
                if (tx.isRecoveredFromStorage()) {
                    tx.loadState();
                }
            }
            catch (Exception e) {
                log.warn((Object)("Failed to replay transaction (XID: " + tx.getXid() + ", LocalID: " + tx.getId() + ") during recovery."), (Throwable)e);
            }
            prepared.add(tx.getXid());
        }
        if (this.trace) {
            log.trace((Object)("Returning " + prepared.size() + " transactions"));
        }
        return prepared;
    }

    public void loadPreparedTransactions() throws Exception {
        if (this.trace) {
            log.trace((Object)"load prepared transactions...");
        }
        List prepared = null;
        prepared = this.persistenceManager.retrievePreparedTransactions();
        if (this.trace) {
            log.trace((Object)("found " + prepared.size() + " transactions in prepared state"));
        }
        if (prepared != null) {
            for (PreparedTxInfo txInfo : prepared) {
                if (!this.map.containsKey(txInfo.getXid())) {
                    Transaction tx = this.createTransaction(txInfo);
                    this.persistenceManager.addTransaction(tx);
                    tx.setState(1);
                    tx.setRecoveredFromStorage(true);
                    if (!this.trace) continue;
                    log.trace((Object)("reinstating TX(XID: " + txInfo.getXid() + ", LocalId " + txInfo.getTxId() + ")"));
                    continue;
                }
                if (!this.trace) continue;
                log.trace((Object)"Not adding to map since it's already in map");
            }
        }
    }

    public List getPreparedTransactions() {
        return new ArrayList(this.map.keySet());
    }

    public Transaction getPreparedTx(Xid xid) throws Exception {
        Transaction tx = (Transaction)this.map.get(xid);
        if (tx == null) {
            throw new TransactionException("Cannot find entry for xid:" + xid);
        }
        if (tx.getState() != 1) {
            throw new TransactionException("Transaction with xid " + xid + " is not in prepared state");
        }
        return tx;
    }

    public void deleteTransaction(Transaction transaction) throws Exception {
        Xid id = transaction.getXid();
        int state = transaction.getState();
        if (id == null) {
            throw new IllegalArgumentException("DeleteTransaction was called for non XA transaction");
        }
        if (state != 2 && state != 3) {
            throw new TransactionException("Transaction with xid " + id + " can't be removed as it's not yet commited or rolledback: (Current state is " + Transaction.stateToString(state));
        }
        this.map.remove(id);
    }

    public Transaction createTransaction(Xid xid) throws Exception {
        if (this.map.containsKey(xid)) {
            throw new TransactionException("There is already an entry for xid " + xid);
        }
        Transaction tx = new Transaction(this.txID.getID(), xid, this);
        if (this.trace) {
            log.trace((Object)("created transaction " + tx));
        }
        this.map.put(xid, tx);
        return tx;
    }

    public Transaction createTransaction() throws Exception {
        Transaction tx = new Transaction(this.txID.getID());
        if (this.trace) {
            log.trace((Object)("created transaction " + tx));
        }
        return tx;
    }

    public boolean removeTransaction(Xid xid) {
        return this.map.remove(xid) != null;
    }

    public int getNumberOfRegisteredTransactions() {
        return this.map.size();
    }

    void handleReferences(Transaction tx) throws Exception {
        if (this.trace) {
            log.trace((Object)("Handle references for TX(XID: " + tx.getXid() + ", LocalID: " + tx.getId() + "):"));
        }
        long txId = tx.getId();
        List pairs = this.persistenceManager.getMessageChannelPairRefsForTx(txId);
        if (this.trace) {
            log.trace((Object)("Found " + pairs.size() + " unhandled references."));
        }
        for (PersistenceManager.MessageChannelPair pair : pairs) {
            Message msg = pair.getMessage();
            long channelID = pair.getChannelId();
            MessageReference ref = this.messageStore.reference(msg);
            ref.getMessage().setPersisted(true);
            Binding binding = this.postOffice.getBindingForChannelID(channelID);
            if (binding == null) {
                throw new IllegalStateException("Cannot find binding for channel id " + channelID);
            }
            Queue queue = binding.queue;
            if (this.trace) {
                log.trace((Object)("Destination for message[ID=" + ref.getMessage().getMessageID() + "] is: " + queue));
            }
            boolean deactivate = false;
            if (!queue.isActive()) {
                queue.activate();
                deactivate = true;
            }
            queue.handle(null, ref, tx);
            if (!deactivate) continue;
            queue.deactivate();
        }
    }

    void handleAcks(Transaction tx) throws Exception {
        long txId = tx.getId();
        List pairs = this.persistenceManager.getMessageChannelPairAcksForTx(txId);
        if (this.trace) {
            log.trace((Object)("Found " + pairs.size() + " unhandled acks."));
        }
        ArrayList<SimpleDelivery> dels = new ArrayList<SimpleDelivery>();
        for (PersistenceManager.MessageChannelPair pair : pairs) {
            Message msg = pair.getMessage();
            long channelID = pair.getChannelId();
            MessageReference ref = null;
            ref = this.messageStore.reference(msg);
            ref.getMessage().setPersisted(true);
            Binding binding = this.postOffice.getBindingForChannelID(channelID);
            if (binding == null) {
                throw new IllegalStateException("Cannot find binding for channel id " + channelID);
            }
            Queue queue = binding.queue;
            if (this.trace) {
                log.trace((Object)("Destination for message[ID=" + ref.getMessage().getMessageID() + "] is: " + queue));
            }
            SimpleDelivery del = new SimpleDelivery(queue, ref, true, true);
            if (this.trace) {
                log.trace((Object)"Acknowledging..");
            }
            try {
                boolean deactivate = false;
                if (!queue.isActive()) {
                    queue.activate();
                    deactivate = true;
                }
                del.acknowledge(tx);
                if (deactivate) {
                    queue.deactivate();
                }
            }
            catch (Throwable t) {
                log.error((Object)("Failed to acknowledge " + del + " during recovery"), t);
            }
            dels.add(del);
        }
        if (!dels.isEmpty()) {
            tx.addCallback(new CancelCallback(dels), this);
        }
    }

    private Transaction createTransaction(PreparedTxInfo txInfo) throws Exception {
        if (this.map.containsKey(txInfo.getXid())) {
            throw new TransactionException("There is already an entry for xid " + txInfo.getXid());
        }
        Transaction tx = new Transaction(txInfo.getTxId(), txInfo.getXid(), this, txInfo.getCreationTime());
        if (this.trace) {
            log.trace((Object)("created transaction " + tx));
        }
        this.map.put(txInfo.getXid(), tx);
        return tx;
    }

    public boolean commitPreparedTransaction(Long txid) {
        Iterator itv = this.map.values().iterator();
        boolean result = false;
        while (itv.hasNext()) {
            Transaction tx = (Transaction)itv.next();
            try {
                if (tx.getId() != txid.longValue()) continue;
                tx.commit();
                result = true;
                break;
            }
            catch (Exception e) {
                log.warn((Object)("Failed to manually commit transaction " + tx), (Throwable)e);
            }
        }
        return result;
    }

    public boolean rollbackPreparedTransaction(Long txid) {
        Iterator itv = this.map.values().iterator();
        boolean result = false;
        while (itv.hasNext()) {
            Transaction tx = (Transaction)itv.next();
            try {
                if (tx.getId() != txid.longValue()) continue;
                tx.rollback();
                result = true;
                break;
            }
            catch (Exception e) {
                log.warn((Object)("Failed to manually rollback transaction " + tx), (Throwable)e);
            }
        }
        return result;
    }

    public List<Transaction> listPreparedTransactions() {
        ArrayList<Transaction> list = new ArrayList<Transaction>(this.map.size());
        for (Xid txid : this.map.keySet()) {
            Transaction tx = (Transaction)this.map.get(txid);
            list.add(tx);
        }
        return list;
    }

    public List<Transaction> listPreparedTransactions(Long age) throws Exception {
        return this.listPreparedTransactions(age, Long.MAX_VALUE);
    }

    private List<Transaction> listPreparedTransactions(Long lower, Long upper) throws Exception {
        if (!this.persistenceManager.supportsTxAge()) {
            throw new Exception("PersistenceManage doesn't support transaction age attribute.");
        }
        ArrayList<Transaction> list = new ArrayList<Transaction>(this.map.size());
        for (Xid txid : this.map.keySet()) {
            Transaction tx = (Transaction)this.map.get(txid);
            long age = tx.getAge();
            if (age < lower || age > upper) continue;
            list.add(tx);
        }
        return list;
    }

    private class CancelCallback
    implements TxCallback {
        private List toCancel;

        private CancelCallback(List toCancel) {
            this.toCancel = toCancel;
        }

        public void afterCommit(boolean onePhase) throws Exception {
        }

        public void afterPrepare() throws Exception {
        }

        public void afterRollback(boolean onePhase) throws Exception {
            for (int i = this.toCancel.size() - 1; i >= 0; --i) {
                Delivery del = (Delivery)this.toCancel.get(i);
                try {
                    del.cancel();
                    continue;
                }
                catch (Throwable t) {
                    log.error((Object)"Failed to cancel delivery", t);
                    throw new TransactionException(t.getMessage(), t);
                }
            }
        }

        public void beforeCommit(boolean onePhase) throws Exception {
        }

        public void beforePrepare() throws Exception {
        }

        public void beforeRollback(boolean onePhase) throws Exception {
        }
    }
}

