/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jaxb.intros.handlers;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.xml.bind.annotation.XmlElement;
import org.jboss.jaxb.intros.ConfigurationException;
import org.jboss.jaxb.intros.configmodel.XmlElementIntro;
import org.jboss.jaxb.intros.handlers.ClassValue;

public class XmlElementHandler
implements InvocationHandler {
    private XmlElementIntro xmlElementIntro;

    private XmlElementHandler(XmlElementIntro xmlElementIntro) {
        this.xmlElementIntro = xmlElementIntro;
    }

    public static Annotation createProxy(XmlElementIntro xmlElementIntro) {
        return (Annotation)Proxy.newProxyInstance(XmlElementIntro.class.getClassLoader(), new Class[]{XmlElement.class, ClassValue.class}, (InvocationHandler)new XmlElementHandler(xmlElementIntro));
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        String string = method.getName();
        if (string.equals("getClassValue")) {
            string = (String)objectArray[1];
        }
        if (string.equals("namespace")) {
            return this.xmlElementIntro.getNamespace();
        }
        if (string.equals("name")) {
            return this.xmlElementIntro.getName();
        }
        if (string.equals("nillable")) {
            return this.xmlElementIntro.isNillable();
        }
        if (string.equals("required")) {
            return this.xmlElementIntro.isRequired();
        }
        if (string.equals("defaultValue")) {
            String string2 = this.xmlElementIntro.getDefaultValue();
            return string2 != null ? string2 : "\u0000";
        }
        if (string.equals("type")) {
            if (this.xmlElementIntro.getType() != null) {
                try {
                    return Class.forName(this.xmlElementIntro.getType());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new ConfigurationException("Bad 'XmlElement.type' config value '" + this.xmlElementIntro.getType() + "' in JAXB Annotation Introduction config.  Class not found.");
                }
            }
            return XmlElement.DEFAULT.class;
        }
        if (string.equals("annotationType")) {
            return XmlElement.class;
        }
        return null;
    }
}

