/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jaxb.intros.handlers;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.jaxb.intros.ConfigurationException;
import org.jboss.jaxb.intros.configmodel.XmlTypeIntro;
import org.jboss.jaxb.intros.handlers.ClassValue;

public class XmlTypeHandler
implements InvocationHandler {
    private static final Log logger = LogFactory.getLog(XmlTypeHandler.class);
    private XmlTypeIntro xmlTypeIntro;

    private XmlTypeHandler(XmlTypeIntro xmlTypeIntro) {
        this.xmlTypeIntro = xmlTypeIntro;
    }

    public static Annotation createProxy(XmlTypeIntro xmlTypeIntro) {
        return (Annotation)Proxy.newProxyInstance(XmlTypeIntro.class.getClassLoader(), new Class[]{XmlType.class, ClassValue.class}, (InvocationHandler)new XmlTypeHandler(xmlTypeIntro));
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        String string = method.getName();
        if (string.equals("getClassValue")) {
            string = (String)objectArray[1];
        }
        if (string.equals("namespace")) {
            return this.xmlTypeIntro.getNamespace();
        }
        if (string.equals("name")) {
            return this.xmlTypeIntro.getName();
        }
        if (string.equals("propOrder")) {
            try {
                String[] stringArray = this.xmlTypeIntro.getPropOrder().split(",");
                for (int i = 0; i < stringArray.length; ++i) {
                    String string2 = stringArray[i];
                    stringArray[i] = string2.trim();
                }
                return stringArray;
            }
            catch (Exception exception) {
                logger.warn((Object)("Bad 'XmlType.propOrder' config value '" + this.xmlTypeIntro.getPropOrder() + "' in JAXB Annotation Introduction config.  Must be a CSV String."));
            }
        } else {
            if (string.equals("factoryClass")) {
                if (this.xmlTypeIntro.getFactoryClass() != null) {
                    try {
                        return Class.forName(this.xmlTypeIntro.getFactoryClass());
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new ConfigurationException("Bad 'XmlType.factoryClass' config value '" + this.xmlTypeIntro.getFactoryClass() + "' in JAXB Annotation Introduction config.  Class not found.");
                    }
                }
                return XmlType.DEFAULT.class;
            }
            if (string.equals("factoryMethod")) {
                return this.xmlTypeIntro.getFactoryMethod();
            }
        }
        return null;
    }
}

