/*
 * Decompiled with CFR 0.152.
 */
package javax.management.remote.rmi;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.MalformedURLException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.rmi.RMIIIOPServerImpl;
import javax.management.remote.rmi.RMIJRMPServerImpl;
import javax.management.remote.rmi.RMIServer;
import javax.management.remote.rmi.RMIServerImpl;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.logging.Logger;
import org.jboss.util.Base64;

public class RMIConnectorServer
extends JMXConnectorServer {
    public static final String JNDI_REBIND_ATTRIBUTE = "jmx.remote.jndi.rebind";
    public static final String RMI_CLIENT_SOCKET_FACTORY_ATTRIBUTE = "jmx.remote.rmi.client.socket.factory";
    public static final String RMI_SERVER_SOCKET_FACTORY_ATTRIBUTE = "jmx.remote.rmi.server.socket.factory";
    private JMXServiceURL serviceURL = null;
    private Map environment = Collections.EMPTY_MAP;
    private RMIServerImpl serverImpl = null;
    private boolean isActive = false;
    private boolean isStopped = false;
    protected static Logger log = Logger.getLogger((String)RMIConnectorServer.class.getName());

    public RMIConnectorServer(JMXServiceURL url, Map environment) throws IOException {
        this(url, environment, null);
    }

    public RMIConnectorServer(JMXServiceURL url, Map environment, MBeanServer mbeanServer) throws IOException {
        this(url, environment, null, mbeanServer);
    }

    public RMIConnectorServer(JMXServiceURL url, Map environment, RMIServerImpl rmiServerImpl, MBeanServer mbeanServer) throws IOException {
        super(mbeanServer);
        this.validateServiceURL(url);
        this.serviceURL = url;
        if (environment != null) {
            this.environment = Collections.unmodifiableMap(environment);
        }
        this.serverImpl = rmiServerImpl;
    }

    private void validateServiceURL(JMXServiceURL url) throws MalformedURLException {
        if (url != null) {
            String protocol = url.getProtocol();
            if (protocol == null || !protocol.equalsIgnoreCase("rmi") && !protocol.equalsIgnoreCase("iiop")) {
                throw new MalformedURLException("Protocol for JMXServiceURL is " + protocol + ".  Must be either rmi or iiop.");
            }
        } else {
            throw new IllegalArgumentException("JMXServiceURL can not be null");
        }
    }

    public JMXConnector toJMXConnector(Map env) throws IOException {
        return null;
    }

    public void start() throws IOException {
        if (this.isActive()) {
            return;
        }
        if (this.isStopped) {
            throw new IOException("RMIConnectorServer can not be started once stopped.");
        }
        if (this.serverImpl == null) {
            this.serverImpl = this.createServer(this.getAddress(), this.getAttributes());
        }
        ClassLoader classLoader = this.findClassLoader(this.getAttributes(), this.getMBeanServer());
        this.serverImpl.setRMIConnectorServer(this);
        this.serverImpl.setMBeanServer(this.getMBeanServer());
        this.serverImpl.setDefaultClassLoader(classLoader);
        this.serverImpl.export();
        RMIServer stub = (RMIServer)this.serverImpl.toStub();
        JMXServiceURL url = this.getAddress();
        String jndiPathKey = "/jndi/";
        String jndiPathKey2 = ";jndi/";
        if (url != null && url.getURLPath() != null && (url.getURLPath().startsWith("/jndi/") || url.getURLPath().startsWith(";jndi/"))) {
            String jndiPath = url.getURLPath().substring("/jndi/".length());
            boolean rebind = false;
            String srebind = (String)this.environment.get(JNDI_REBIND_ATTRIBUTE);
            if (Boolean.getBoolean(srebind)) {
                rebind = true;
            }
            InitialContext ctx = null;
            try {
                ctx = new InitialContext(new Hashtable(this.environment));
                if (rebind) {
                    ctx.rebind(jndiPath, (Object)stub);
                } else {
                    ctx.bind(jndiPath, (Object)stub);
                }
                log.debug((Object)("Bound rmi connector stub (" + stub + ") into jndi with path: " + jndiPath));
            }
            catch (NamingException ne) {
                log.error((Object)"Error binding rmi connector stub", (Throwable)ne);
                throw new IOException(ne.getMessage());
            }
            finally {
                try {
                    if (ctx != null) {
                        ctx.close();
                    }
                }
                catch (NamingException ne) {
                    log.debug((Object)"Error closing InitialContext.", (Throwable)ne);
                }
            }
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(stub);
        oos.flush();
        oos.close();
        byte[] bytes = baos.toByteArray();
        String encoded = Base64.encodeBytes((byte[])bytes);
        String path = "/stub/" + encoded;
        this.serviceURL = new JMXServiceURL(url.getProtocol(), url.getHost(), url.getPort(), path);
        this.isActive(true);
        log.debug((Object)("RMIConnectorServer started at service url: " + this.getAddress()));
    }

    private ClassLoader findClassLoader(Map environment, MBeanServer server) throws IllegalArgumentException {
        ClassLoader classLoader = null;
        if (environment != null) {
            Object loaderObjectName;
            Object loaderInstance = environment.get("jmx.remote.default.class.loader");
            if (loaderInstance != null && loaderInstance instanceof ClassLoader) {
                classLoader = (ClassLoader)loaderInstance;
            }
            if ((loaderObjectName = environment.get("jmx.remote.default.class.loader.name")) != null) {
                if (classLoader != null) {
                    throw new IllegalArgumentException("Can not specify class loader using both the jmx.remote.default.class.loader and jmx.remote.default.class.loader.name keys.  Only one of the two can be supplied.");
                }
                if (!(loaderObjectName instanceof ObjectName)) {
                    throw new IllegalArgumentException("The value specified for jmx.remote.default.class.loader.name is not of type " + ObjectName.class.getName());
                }
                ObjectName objectName = (ObjectName)loaderObjectName;
                try {
                    classLoader = server.getClassLoader(objectName);
                }
                catch (InstanceNotFoundException e) {
                    throw new IllegalArgumentException("The ObjectName specified by jmx.remote.default.class.loader.name was not found within the MBeanServer.");
                }
            }
        }
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        return classLoader;
    }

    private RMIServerImpl createServer(JMXServiceURL address, Map environment) throws IOException {
        RMIServerImpl impl = null;
        String protocol = address.getProtocol();
        if ("iiop".equalsIgnoreCase(protocol)) {
            impl = new RMIIIOPServerImpl(environment);
        } else if (protocol == null || protocol.length() == 0 || "rmi".equalsIgnoreCase("rmi")) {
            int port = address.getPort();
            RMIClientSocketFactory clientSocketFactory = (RMIClientSocketFactory)environment.get(RMI_CLIENT_SOCKET_FACTORY_ATTRIBUTE);
            RMIServerSocketFactory serverSocketFactory = (RMIServerSocketFactory)environment.get(RMI_SERVER_SOCKET_FACTORY_ATTRIBUTE);
            impl = new RMIJRMPServerImpl(port, clientSocketFactory, serverSocketFactory, environment);
        } else {
            throw new MalformedURLException("Can not create connector server.  Protocol must be either 'rmi', 'iiop', or null.");
        }
        return impl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws IOException {
        if (this.isStopped) {
            return;
        }
        this.isActive = false;
        this.isStopped = true;
        if (this.serverImpl != null) {
            this.serverImpl.close();
        }
        JMXServiceURL url = this.getAddress();
        String jndiPathKey = "/jndi/";
        String jndiPathKey2 = ";jndi/";
        if (url != null && url.getURLPath() != null && (url.getURLPath().startsWith("/jndi/") || url.getURLPath().startsWith(";jndi/"))) {
            String jndiPath = url.getURLPath().substring("/jndi/".length());
            InitialContext ctx = null;
            try {
                ctx = new InitialContext(new Hashtable(this.environment));
                ctx.unbind(jndiPath);
            }
            catch (NamingException ne) {
                log.error((Object)"Error unbinding rmi connector stub", (Throwable)ne);
            }
            finally {
                try {
                    if (ctx != null) {
                        ctx.close();
                    }
                }
                catch (NamingException ne) {
                    log.debug((Object)"Error closing InitialContext.", (Throwable)ne);
                }
            }
        }
    }

    public boolean isActive() {
        return this.isActive;
    }

    private void isActive(boolean active) {
        this.isActive = active;
    }

    public JMXServiceURL getAddress() {
        return this.serviceURL;
    }

    public Map getAttributes() {
        return this.environment;
    }

    protected void connectionOpened(String connectionId, String message, Object userData) {
        super.connectionOpened(connectionId, message, userData);
    }

    protected void connectionClosed(String connectionId, String message, Object userData) {
        super.connectionClosed(connectionId, message, userData);
    }

    protected void connectionFailed(String connectionId, String message, Object userData) {
    }
}

