/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.remoting;

import java.util.HashMap;
import java.util.Map;
import javax.management.NotificationFilter;
import javax.management.ObjectName;

public class ClientListener {
    final ObjectName objectName;
    final Object listener;
    final NotificationFilter filter;
    final Object handback;
    final String sessionId;
    private static final Map listeners = new HashMap();

    private ClientListener(String sessionId, ObjectName objectName, Object listener, NotificationFilter filter, Object handback) {
        this.sessionId = sessionId;
        this.objectName = objectName;
        this.listener = listener;
        this.filter = filter;
        this.handback = handback;
    }

    public String toString() {
        return "ClientListener [sessionid:" + this.sessionId + ",objectName:" + this.objectName + ",listener:" + this.listener + ",filter:" + this.filter + ",handback:" + this.handback + "]";
    }

    public static boolean hasListeners() {
        return !listeners.isEmpty();
    }

    public static Object makeId(String sessionId, ObjectName objectName, Object listener) {
        return sessionId + "/" + objectName + "/" + listener;
    }

    public static synchronized ClientListener remove(Object id) {
        return (ClientListener)listeners.remove(id);
    }

    public static synchronized ClientListener remove(String sessionId, ObjectName objectName, Object listener) {
        Object id = null;
        id = listener instanceof ClientListener ? ClientListener.makeId(sessionId, objectName, ((ClientListener)listener).listener) : ClientListener.makeId(sessionId, objectName, listener);
        return (ClientListener)listeners.remove(id);
    }

    public static synchronized Object register(String sessionId, ObjectName objectName, Object listener, NotificationFilter filter, Object handback) {
        ClientListener l = new ClientListener(sessionId, objectName, listener, filter, handback);
        Object id = ClientListener.makeId(sessionId, objectName, listener);
        listeners.put(id, l);
        return id;
    }

    public static synchronized ClientListener get(Object id) {
        return (ClientListener)listeners.get(id);
    }

    static synchronized String dump() {
        return listeners.toString();
    }
}

