/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.remoting;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServer;
import org.jboss.logging.Logger;
import org.jboss.mx.remoting.MBeanServerClientInvokerProxy;
import org.jboss.remoting.InvokerLocator;

public class MBeanServerRegistry {
    private static final Logger log = Logger.getLogger((String)MBeanServerRegistry.class.getName());
    private static final Map serversById = Collections.synchronizedMap(new HashMap());
    private static final Map serversByLocator = Collections.synchronizedMap(new HashMap());

    public static final boolean isMBeanServerRegistered(String id) {
        return MBeanServerRegistry.getMBeanServerFor(id) != null;
    }

    public static final MBeanServer getMBeanServerFor(String id) {
        return (MBeanServer)serversById.get(id);
    }

    public static final boolean isMBeanServerRegistered(InvokerLocator locator) {
        return MBeanServerRegistry.getMBeanServerFor(locator) != null;
    }

    public static final MBeanServer getMBeanServerFor(InvokerLocator locator) {
        return (MBeanServer)serversByLocator.get(locator);
    }

    static synchronized void register(MBeanServer server, MBeanServerClientInvokerProxy proxy) {
        String serverid = proxy.getServerId();
        serversById.put(serverid, server);
        serversByLocator.put(proxy.getLocator(), server);
        if (log.isTraceEnabled()) {
            log.trace((Object)("register called with proxy: " + proxy + " and serverid: " + serverid));
        }
    }

    static synchronized void unregister(MBeanServerClientInvokerProxy proxy) {
        String serverid = proxy.getServerId();
        serversById.remove(serverid);
        serversByLocator.remove(proxy.getLocator());
        if (log.isTraceEnabled()) {
            log.trace((Object)("unregister called with proxy: " + proxy + " and serverid: " + serverid));
        }
    }
}

