/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins.managed;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.BeanMetaDataFactory;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.managed.ManagedObjectCreator;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.kernel.spi.deployment.KernelDeployment;
import org.jboss.logging.Logger;
import org.jboss.managed.api.Fields;
import org.jboss.managed.api.ManagedObject;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.managed.api.MutableManagedObject;
import org.jboss.managed.api.factory.ManagedObjectFactory;
import org.jboss.managed.plugins.DefaultFieldsImpl;
import org.jboss.managed.plugins.ManagedObjectImpl;
import org.jboss.managed.plugins.ManagedPropertyImpl;
import org.jboss.managed.plugins.factory.AbstractManagedObjectFactory;
import org.jboss.metadata.spi.MetaData;
import org.jboss.metatype.api.types.CollectionMetaType;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.values.CollectionValueSupport;
import org.jboss.metatype.api.values.GenericValue;
import org.jboss.metatype.api.values.GenericValueSupport;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.profileservice.spi.types.ControllerStateMetaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KernelDeploymentManagedObjectCreator
implements ManagedObjectCreator {
    private static Logger log = Logger.getLogger(KernelDeploymentManagedObjectCreator.class);
    private ManagedObjectFactory mof;

    public KernelDeploymentManagedObjectCreator(ManagedObjectFactory mof) {
        if (mof == null) {
            throw new IllegalArgumentException("Null ManagedObjectFactory.");
        }
        this.mof = mof;
    }

    public void build(DeploymentUnit unit, Set<String> attachments, Map<String, ManagedObject> managedObjects) throws DeploymentException {
        for (Map.Entry entry : unit.getAttachments().entrySet()) {
            if (!KernelDeployment.class.isInstance(entry.getValue())) continue;
            KernelDeployment deployment = (KernelDeployment)KernelDeployment.class.cast(entry.getValue());
            ManagedObject deploymentMO = managedObjects.get(entry.getKey());
            if (deploymentMO == null) {
                deploymentMO = this.mof.createManagedObject(deployment.getClass());
                managedObjects.put((String)entry.getKey(), deploymentMO);
            }
            if (deploymentMO instanceof MutableManagedObject) {
                ((MutableManagedObject)deploymentMO).setName(KernelDeployment.class.getName());
            }
            if (deploymentMO instanceof ManagedObjectImpl) {
                ((ManagedObjectImpl)deploymentMO).setAttachmentName((String)entry.getKey());
            }
            this.build(unit, deployment, deploymentMO, managedObjects);
        }
    }

    public void build(DeploymentUnit unit, KernelDeployment deployment, ManagedObject deploymentMO, Map<String, ManagedObject> managedObjects) throws DeploymentException {
        List beanFactories = deployment.getBeanFactories();
        MetaData metaData = unit.getMetaData();
        ManagedProperty beanFactoriesMP = deploymentMO.getProperty("beanFactories");
        if (beanFactoriesMP == null) {
            return;
        }
        ArrayList<GenericValueSupport> tmpBFs = new ArrayList<GenericValueSupport>();
        CollectionMetaType beansFactoryType = new CollectionMetaType(BeanMetaDataFactory.class.getName(), (MetaType)AbstractManagedObjectFactory.MANAGED_OBJECT_META_TYPE);
        if (beanFactories != null) {
            ArrayList<GenericValue> tmpBeans = new ArrayList<GenericValue>();
            CollectionMetaType beansType = new CollectionMetaType(BeanMetaDataFactory.class.getName(), (MetaType)AbstractManagedObjectFactory.MANAGED_OBJECT_META_TYPE);
            for (BeanMetaDataFactory bmdf : beanFactories) {
                ManagedObject bmdfMO = this.mof.initManagedObject((Object)bmdf, metaData);
                if (bmdfMO == null) {
                    bmdfMO = this.createFactoryManagedObject(bmdf, deploymentMO, metaData);
                }
                if (!(bmdfMO instanceof MutableManagedObject)) {
                    GenericValueSupport gv = new GenericValueSupport(AbstractManagedObjectFactory.MANAGED_OBJECT_META_TYPE, (Serializable)bmdfMO);
                    tmpBFs.add(gv);
                    continue;
                }
                MutableManagedObject bmdfMMO = (MutableManagedObject)bmdfMO;
                bmdfMMO.setParent(deploymentMO);
                Map oldProps = bmdfMMO.getProperties();
                ManagedProperty beansMPCheck = (ManagedProperty)oldProps.get("beans");
                if (beansMPCheck != null) continue;
                HashMap<String, ManagedPropertyImpl> newProps = new HashMap<String, ManagedPropertyImpl>(oldProps);
                Fields fields = this.getFields("beans", (MetaType)beansType);
                ManagedPropertyImpl beansMP = new ManagedPropertyImpl(bmdfMO, fields);
                newProps.put("beans", beansMP);
                List beans = bmdf.getBeans();
                if (beans != null) {
                    for (BeanMetaData bmd : beans) {
                        DeploymentUnit compUnit = unit.getComponent(bmd.getName());
                        if (compUnit == null) {
                            log.debug((Object)("Failed to find component for bean: " + bmd.getName()));
                            continue;
                        }
                        MetaData compMetaData = compUnit.getMetaData();
                        GenericValue gv = this.getManagedObjectValue(bmd, compMetaData, bmdfMO);
                        if (gv == null) continue;
                        ManagedObject compMO = (ManagedObject)gv.getValue();
                        String managedObjectName = compUnit.getName();
                        if (compMO != null && compMO.getAttachmentName() != null) {
                            managedObjectName = compMO.getAttachmentName().equals(compMO.getName()) ? compUnit.getName() : compMO.getName();
                        }
                        managedObjects.put(managedObjectName, compMO);
                        tmpBeans.add(gv);
                    }
                }
                GenericValue[] beanMOs = new GenericValue[tmpBeans.size()];
                tmpBeans.toArray(beanMOs);
                CollectionValueSupport values = new CollectionValueSupport(beansType, (MetaValue[])beanMOs);
                beansMP.setValue((MetaValue)values);
                bmdfMMO.setProperties(newProps);
            }
        }
        GenericValue[] mos = new GenericValue[tmpBFs.size()];
        tmpBFs.toArray(mos);
        CollectionValueSupport values = new CollectionValueSupport(beansFactoryType, (MetaValue[])mos);
        beanFactoriesMP.getFields().setField("value", (Object)values);
    }

    protected ManagedObject createFactoryManagedObject(BeanMetaDataFactory bmdf, ManagedObject parent, MetaData metaData) {
        ManagedObjectImpl bmdfMO = new ManagedObjectImpl(bmdf.getClass().getName());
        HashMap newProps = new HashMap();
        bmdfMO.setParent(parent);
        bmdfMO.setProperties(newProps);
        return bmdfMO;
    }

    protected GenericValue getManagedObjectValue(BeanMetaData bmd, MetaData metaData, ManagedObject parentMO) {
        String name = bmd.getName();
        ManagedObject mo = this.mof.initManagedObject((Object)bmd, null, metaData, name, null);
        if (parentMO != null && mo instanceof MutableManagedObject) {
            MutableManagedObject mmo = (MutableManagedObject)mo;
            mmo.setParent(parentMO);
            Map oldProps = mmo.getProperties();
            HashMap<String, ManagedPropertyImpl> newProps = new HashMap<String, ManagedPropertyImpl>(oldProps);
            Fields stateFields = this.getFields("state", (MetaType)ControllerStateMetaType.TYPE);
            ManagedPropertyImpl stateMP = new ManagedPropertyImpl((ManagedObject)mmo, stateFields);
            newProps.put("state", stateMP);
            mmo.setProperties(newProps);
        }
        return new GenericValueSupport(AbstractManagedObjectFactory.MANAGED_OBJECT_META_TYPE, (Serializable)mo);
    }

    protected Fields getFields(String name, MetaType type) {
        DefaultFieldsImpl fields = new DefaultFieldsImpl();
        fields.setMetaType(type);
        fields.setName(name);
        fields.setField("mappedName", (Object)name);
        fields.setMandatory(false);
        fields.setDescription("The bean controller state");
        return fields;
    }
}

