/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.manager;

import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.util.RequestUtil;

public class StatusTransformer {
    public static void setContentType(HttpServletResponse response, int mode) {
        if (mode == 0) {
            response.setContentType("text/html;charset=utf-8");
        } else if (mode == 1) {
            response.setContentType("text/xml;charset=utf-8");
        }
    }

    public static void writeHeader(PrintWriter writer, Object[] args, int mode) {
        if (mode == 0) {
            writer.print(MessageFormat.format("<html>\n<head>\n<link href=\"{0}/jbossweb.css\" rel=\"stylesheet\" type=\"text/css\" />\n", args));
        } else if (mode == 1) {
            writer.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
            writer.write("<?xml-stylesheet type=\"text/xsl\" href=\"/manager/xform.xsl\" ?>");
            writer.write("<status>");
        }
    }

    public static void writeBody(PrintWriter writer, Object[] args, int mode) {
        if (mode == 0) {
            writer.print(MessageFormat.format("<title>{1}</title>\n</head>\n\n<body>\n\n<div class=\"wrapper\">\n  <div class=\"header\">\n    <div class=\"floatleft\"><a href=\"list\"><img src=\"{0}/images/hdr_hdrtitle.gif\" border=\"0\"></a></div>\n    <div class=\"floatright\"><a href=\"http://www.jboss.com/\"><img src=\"{0}/images/hdr_jbosslogo.gif\" alt=\"JBoss, a division of Red Hat\" border=\"0\"></a><a href=\"http://www.jboss.org\"><img src=\"{0}/images/hdr_jbossorglogo.gif\" alt=\"JBoss.org - Community driven.\" border=\"0\" /></a></div>\n  </div>\n    <div class=\"container\">\n\n", args));
        }
    }

    public static void writeManager1(PrintWriter writer, Object[] args, int mode) {
        if (mode == 0) {
            writer.print(MessageFormat.format("<div class=\"leftcol\"><dl>\n  <dt>Manager</dt>    <dd><a href=\"{1}\">{2}</a></dd>    <dd><a href=\"{3}\">{4}</a></dd>    <dd><a href=\"{5}\">{6}</a></dd>    <dd><a href=\"{7}\">{8}</a></dd>", args));
        }
    }

    public static void writeManager2(PrintWriter writer, Object[] args, int mode) {
        if (mode == 0) {
            writer.print(MessageFormat.format("</dl></div>\n<div class=\"maincol\">\n", args));
        }
    }

    public static void writePageHeading(PrintWriter writer, Object[] args, int mode) {
        if (mode == 0) {
            writer.print(MessageFormat.format("<table width=\"100%\" cellspacing=\"0\" class=\"tableStyle\" >\n<thead>\n <th colspan=\"6\">{0}</th>\n</thead>\n<tr class=\"UnsortableTableHeader\">\n <td>{1}</td>\n <td>{2}</td>\n <td>{3}</td>\n <td>{4}</td>\n <td>{5}</td>\n <td>{6}</td>\n</tr>\n", args));
        }
    }

    public static void writeServerInfo(PrintWriter writer, Object[] args, int mode) {
        if (mode == 0) {
            writer.print(MessageFormat.format("<tbody><tr class=\"oddRow\">\n <td class=\"first\">{0}</small></td>\n <td>{1}</td>\n <td>{2}</td>\n <td>{3}</td>\n <td>{4}</td>\n <td>{5}</td>\n</tr>\n</tbody></table>\n\n", args));
        }
    }

    public static void writeFooter(PrintWriter writer, int mode) {
        if (mode == 0) {
            writer.print("  </div>\n  </div>\n  <div class=\"footer\">&copy; 2008 Red Hat Middleware, LLC. All Rights Reserved. </div>\n</div></body></html>");
        } else if (mode == 1) {
            writer.write("</status>");
        }
    }

    public static void writeOSState(PrintWriter writer, int mode) {
        long[] result = new long[16];
        boolean ok = false;
        try {
            String methodName = "info";
            Class[] paramTypes = new Class[]{result.getClass()};
            Object[] paramValues = new Object[]{result};
            Method method = Class.forName("org.apache.tomcat.jni.OS").getMethod(methodName, paramTypes);
            method.invoke(null, paramValues);
            ok = true;
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (ok) {
            if (mode == 0) {
                writer.print("<h3>OS</h3>");
                writer.print("<p>");
                writer.print(" <strong>Physical memory:</strong> ");
                writer.print(StatusTransformer.formatSize(new Long(result[0]), true));
                writer.print("<br><strong>Available memory:</strong> ");
                writer.print(StatusTransformer.formatSize(new Long(result[1]), true));
                writer.print("<br><strong>Total page file:</strong> ");
                writer.print(StatusTransformer.formatSize(new Long(result[2]), true));
                writer.print("<br><strong>Free page file:</strong> ");
                writer.print(StatusTransformer.formatSize(new Long(result[3]), true));
                writer.print("<br><strong>Memory load:</strong> ");
                writer.print(new Long(result[6]));
                writer.print("<br><strong>Process kernel time:</strong> ");
                writer.print(StatusTransformer.formatTime(new Long(result[11] / 1000L), true));
                writer.print("<br><strong>Process user time:</strong> ");
                writer.print(StatusTransformer.formatTime(new Long(result[12] / 1000L), true));
                writer.print("</p>");
            } else if (mode == 1) {
                // empty if block
            }
        }
    }

    public static void writeVMState(PrintWriter writer, int mode) throws Exception {
        if (mode == 0) {
            writer.print("<h3>JVM</h3>");
            writer.print("<p>");
            writer.print(" <strong>Free memory:</strong> ");
            writer.print(StatusTransformer.formatSize(new Long(Runtime.getRuntime().freeMemory()), true));
            writer.print(" <br><strong>Total memory:</strong> ");
            writer.print(StatusTransformer.formatSize(new Long(Runtime.getRuntime().totalMemory()), true));
            writer.print(" <br><strong>Max memory:</strong> ");
            writer.print(StatusTransformer.formatSize(new Long(Runtime.getRuntime().maxMemory()), true));
            writer.print("</p>");
        } else if (mode == 1) {
            writer.write("<jvm>");
            writer.write("<memory");
            writer.write(" free='" + Runtime.getRuntime().freeMemory() + "'");
            writer.write(" total='" + Runtime.getRuntime().totalMemory() + "'");
            writer.write(" max='" + Runtime.getRuntime().maxMemory() + "'/>");
            writer.write("</jvm>");
        }
    }

    public static void writeConnectorState(PrintWriter writer, ObjectName tpName, String name, MBeanServer mBeanServer, Vector globalRequestProcessors, Vector requestProcessors, int mode) throws Exception {
        if (mode == 0) {
            writer.print("<h3>");
            writer.print(name);
            writer.print("</h3>");
            writer.print("<p>");
            writer.print(" <strong>Max threads:</strong> ");
            writer.print(mBeanServer.getAttribute(tpName, "maxThreads"));
            writer.print(" <br><strong>Current thread count:</strong> ");
            writer.print(mBeanServer.getAttribute(tpName, "currentThreadCount"));
            writer.print(" <br><strong>Current thread busy:</strong> ");
            writer.print(mBeanServer.getAttribute(tpName, "currentThreadsBusy"));
            try {
                Object value = mBeanServer.getAttribute(tpName, "keepAliveCount");
                writer.print(" <br><strong>Keeped alive sockets count:</strong> ");
                writer.print(value);
            }
            catch (Exception e) {
                // empty catch block
            }
            ObjectName grpName = null;
            Enumeration enumeration = globalRequestProcessors.elements();
            while (enumeration.hasMoreElements()) {
                ObjectName objectName = (ObjectName)enumeration.nextElement();
                if (!name.equals(objectName.getKeyProperty("name"))) continue;
                grpName = objectName;
            }
            if (grpName == null) {
                return;
            }
            writer.print(" <br><strong>Max processing time:</strong> ");
            writer.print(StatusTransformer.formatTime(mBeanServer.getAttribute(grpName, "maxTime"), false));
            writer.print(" <br><strong>Processing time:</strong> ");
            writer.print(StatusTransformer.formatTime(mBeanServer.getAttribute(grpName, "processingTime"), true));
            writer.print(" <br><strong>Request count:</strong> ");
            writer.print(mBeanServer.getAttribute(grpName, "requestCount"));
            writer.print(" <br><strong>Error count:</strong> ");
            writer.print(mBeanServer.getAttribute(grpName, "errorCount"));
            writer.print(" <br><strong>Bytes received:</strong> ");
            writer.print(StatusTransformer.formatSize(mBeanServer.getAttribute(grpName, "bytesReceived"), true));
            writer.print(" <br><strong>Bytes sent:</strong> ");
            writer.print(StatusTransformer.formatSize(mBeanServer.getAttribute(grpName, "bytesSent"), true));
            writer.print("</p>");
            writer.print("<table width=\"100%\" cellspacing=\"0\" class=\"tableStyle\">");
            writer.print("<thead><th colspan=\"7\">");
            writer.print(name);
            writer.print("</th></thead>");
            writer.print("<tr class=\"UnsortableTableHeader\"><td>Stage</td><td>Time</td><td>B Sent</td><td>B Received</td><td>Client</td><td>V. Host</td><td>Request</td></tr><tbody>");
            enumeration = requestProcessors.elements();
            boolean isHighlighted = false;
            String highlightStyle = null;
            while (enumeration.hasMoreElements()) {
                isHighlighted = !isHighlighted;
                highlightStyle = isHighlighted ? "oddRow" : "evenRow";
                ObjectName objectName = (ObjectName)enumeration.nextElement();
                if (!name.equals(objectName.getKeyProperty("worker"))) continue;
                writer.print("<tr class=\"");
                writer.print(highlightStyle);
                writer.print("\">");
                StatusTransformer.writeProcessorState(writer, objectName, mBeanServer, mode);
                writer.print("</tr>");
            }
            writer.print("<caption align=\"bottom\">P: Parse and prepare request S: Service F: Finishing R: Ready K: Keepalive</caption></tbody></table>");
        } else if (mode == 1) {
            ObjectName objectName;
            writer.write("<connector name='" + name + "'>");
            writer.write("<threadInfo ");
            writer.write(" maxThreads=\"" + mBeanServer.getAttribute(tpName, "maxThreads") + "\"");
            writer.write(" currentThreadCount=\"" + mBeanServer.getAttribute(tpName, "currentThreadCount") + "\"");
            writer.write(" currentThreadsBusy=\"" + mBeanServer.getAttribute(tpName, "currentThreadsBusy") + "\"");
            writer.write(" />");
            ObjectName grpName = null;
            Enumeration enumeration = globalRequestProcessors.elements();
            while (enumeration.hasMoreElements()) {
                objectName = (ObjectName)enumeration.nextElement();
                if (!name.equals(objectName.getKeyProperty("name"))) continue;
                grpName = objectName;
            }
            if (grpName != null) {
                writer.write("<requestInfo ");
                writer.write(" maxTime=\"" + mBeanServer.getAttribute(grpName, "maxTime") + "\"");
                writer.write(" processingTime=\"" + mBeanServer.getAttribute(grpName, "processingTime") + "\"");
                writer.write(" requestCount=\"" + mBeanServer.getAttribute(grpName, "requestCount") + "\"");
                writer.write(" errorCount=\"" + mBeanServer.getAttribute(grpName, "errorCount") + "\"");
                writer.write(" bytesReceived=\"" + mBeanServer.getAttribute(grpName, "bytesReceived") + "\"");
                writer.write(" bytesSent=\"" + mBeanServer.getAttribute(grpName, "bytesSent") + "\"");
                writer.write(" />");
                writer.write("<workers>");
                enumeration = requestProcessors.elements();
                while (enumeration.hasMoreElements()) {
                    objectName = (ObjectName)enumeration.nextElement();
                    if (!name.equals(objectName.getKeyProperty("worker"))) continue;
                    StatusTransformer.writeProcessorState(writer, objectName, mBeanServer, mode);
                }
                writer.write("</workers>");
            }
            writer.write("</connector>");
        }
    }

    protected static void writeProcessorState(PrintWriter writer, ObjectName pName, MBeanServer mBeanServer, int mode) throws Exception {
        Integer stageValue = (Integer)mBeanServer.getAttribute(pName, "stage");
        int stage = stageValue;
        boolean fullStatus = true;
        boolean showRequest = true;
        String stageStr = null;
        switch (stage) {
            case 1: {
                stageStr = "P";
                fullStatus = false;
                break;
            }
            case 2: {
                stageStr = "P";
                fullStatus = false;
                break;
            }
            case 3: {
                stageStr = "S";
                break;
            }
            case 4: {
                stageStr = "F";
                break;
            }
            case 5: {
                stageStr = "F";
                break;
            }
            case 7: {
                stageStr = "R";
                fullStatus = false;
                break;
            }
            case 6: {
                stageStr = "K";
                fullStatus = true;
                showRequest = false;
                break;
            }
            case 0: {
                stageStr = "R";
                fullStatus = false;
                break;
            }
            default: {
                stageStr = "?";
                fullStatus = false;
            }
        }
        if (mode == 0) {
            writer.write("<td class=\"first\"><strong>");
            writer.write(stageStr);
            writer.write("</strong></td>");
            if (fullStatus) {
                writer.write("<td>");
                writer.print(StatusTransformer.formatTime(mBeanServer.getAttribute(pName, "requestProcessingTime"), false));
                writer.write("</td>");
                writer.write("<td>");
                if (showRequest) {
                    writer.print(StatusTransformer.formatSize(mBeanServer.getAttribute(pName, "requestBytesSent"), false));
                } else {
                    writer.write("?");
                }
                writer.write("</td>");
                writer.write("<td>");
                if (showRequest) {
                    writer.print(StatusTransformer.formatSize(mBeanServer.getAttribute(pName, "requestBytesReceived"), false));
                } else {
                    writer.write("?");
                }
                writer.write("</td>");
                writer.write("<td>");
                writer.print(StatusTransformer.filter(mBeanServer.getAttribute(pName, "remoteAddr")));
                writer.write("</td>");
                writer.write("<td nowrap>");
                writer.write(StatusTransformer.filter(mBeanServer.getAttribute(pName, "virtualHost")));
                writer.write("</td>");
                writer.write("<td nowrap>");
                if (showRequest) {
                    writer.write(StatusTransformer.filter(mBeanServer.getAttribute(pName, "method")));
                    writer.write(" ");
                    writer.write(StatusTransformer.filter(mBeanServer.getAttribute(pName, "currentUri")));
                    String queryString = (String)mBeanServer.getAttribute(pName, "currentQueryString");
                    if (queryString != null && !queryString.equals("")) {
                        writer.write("?");
                        writer.print(RequestUtil.filter(queryString));
                    }
                    writer.write(" ");
                    writer.write(StatusTransformer.filter(mBeanServer.getAttribute(pName, "protocol")));
                } else {
                    writer.write("?");
                }
                writer.write("</td>");
            } else {
                writer.write("<td>?</td><td>?</td><td>?</td><td>?</td><td>?</td><td>?</td>");
            }
        } else if (mode == 1) {
            writer.write("<worker ");
            writer.write(" stage=\"" + stageStr + "\"");
            if (fullStatus) {
                writer.write(" requestProcessingTime=\"" + mBeanServer.getAttribute(pName, "requestProcessingTime") + "\"");
                writer.write(" requestBytesSent=\"");
                if (showRequest) {
                    writer.write("" + mBeanServer.getAttribute(pName, "requestBytesSent"));
                } else {
                    writer.write("0");
                }
                writer.write("\"");
                writer.write(" requestBytesReceived=\"");
                if (showRequest) {
                    writer.write("" + mBeanServer.getAttribute(pName, "requestBytesReceived"));
                } else {
                    writer.write("0");
                }
                writer.write("\"");
                writer.write(" remoteAddr=\"" + StatusTransformer.filter(mBeanServer.getAttribute(pName, "remoteAddr")) + "\"");
                writer.write(" virtualHost=\"" + StatusTransformer.filter(mBeanServer.getAttribute(pName, "virtualHost")) + "\"");
                if (showRequest) {
                    writer.write(" method=\"" + StatusTransformer.filter(mBeanServer.getAttribute(pName, "method")) + "\"");
                    writer.write(" currentUri=\"" + StatusTransformer.filter(mBeanServer.getAttribute(pName, "currentUri")) + "\"");
                    String queryString = (String)mBeanServer.getAttribute(pName, "currentQueryString");
                    if (queryString != null && !queryString.equals("")) {
                        writer.write(" currentQueryString=\"" + RequestUtil.filter(queryString) + "\"");
                    } else {
                        writer.write(" currentQueryString=\"&#63;\"");
                    }
                    writer.write(" protocol=\"" + StatusTransformer.filter(mBeanServer.getAttribute(pName, "protocol")) + "\"");
                } else {
                    writer.write(" method=\"&#63;\"");
                    writer.write(" currentUri=\"&#63;\"");
                    writer.write(" currentQueryString=\"&#63;\"");
                    writer.write(" protocol=\"&#63;\"");
                }
            } else {
                writer.write(" requestProcessingTime=\"0\"");
                writer.write(" requestBytesSent=\"0\"");
                writer.write(" requestBytesRecieved=\"0\"");
                writer.write(" remoteAddr=\"&#63;\"");
                writer.write(" virtualHost=\"&#63;\"");
                writer.write(" method=\"&#63;\"");
                writer.write(" currentUri=\"&#63;\"");
                writer.write(" currentQueryString=\"&#63;\"");
                writer.write(" protocol=\"&#63;\"");
            }
            writer.write(" />");
        }
    }

    public static void writeDetailedState(PrintWriter writer, MBeanServer mBeanServer, int mode) throws Exception {
        if (mode == 0) {
            ObjectName queryHosts = new ObjectName("*:j2eeType=WebModule,*");
            Set<ObjectName> hostsON = mBeanServer.queryNames(queryHosts, null);
            int count = 0;
            for (ObjectName contextON : hostsON) {
                writer.print("<a name=\"" + count++ + ".0\">");
                StatusTransformer.writeContext(writer, contextON, mBeanServer, mode);
            }
        } else if (mode == 1) {
            // empty if block
        }
    }

    public static void writeAppList(PrintWriter writer, MBeanServer mBeanServer, int mode) throws Exception {
        if (mode == 0) {
            ObjectName queryHosts = new ObjectName("*:j2eeType=WebModule,*");
            Set<ObjectName> hostsON = mBeanServer.queryNames(queryHosts, null);
            writer.print("<dt>Application list</dt>");
            int count = 0;
            Iterator<ObjectName> iterator = hostsON.iterator();
            while (iterator.hasNext()) {
                int slash;
                writer.print("<dd>");
                ObjectName contextON = iterator.next();
                String webModuleName = contextON.getKeyProperty("name");
                if (webModuleName.startsWith("//")) {
                    webModuleName = webModuleName.substring(2);
                }
                if ((slash = webModuleName.indexOf("/")) == -1) {
                    ++count;
                    continue;
                }
                writer.print("<a href=\"#" + count++ + ".0\">");
                writer.print(StatusTransformer.filter(webModuleName));
                writer.print("</a>");
                writer.print("</dd>");
            }
        } else if (mode == 1) {
            // empty if block
        }
    }

    protected static void writeContext(PrintWriter writer, ObjectName objectName, MBeanServer mBeanServer, int mode) throws Exception {
        if (mode == 0) {
            int slash;
            String webModuleName = objectName.getKeyProperty("name");
            String name = webModuleName;
            if (name == null) {
                return;
            }
            String hostName = null;
            String contextName = null;
            if (name.startsWith("//")) {
                name = name.substring(2);
            }
            if ((slash = name.indexOf("/")) == -1) {
                return;
            }
            hostName = name.substring(0, slash);
            contextName = name.substring(slash);
            ObjectName queryManager = new ObjectName(objectName.getDomain() + ":type=Manager,path=" + contextName + ",host=" + hostName + ",*");
            Set<ObjectName> managersON = mBeanServer.queryNames(queryManager, null);
            ObjectName managerON2 = null;
            for (ObjectName managerON2 : managersON) {
            }
            ObjectName queryJspMonitor = new ObjectName(objectName.getDomain() + ":type=JspMonitor,WebModule=" + webModuleName + ",*");
            Set<ObjectName> jspMonitorONs = mBeanServer.queryNames(queryJspMonitor, null);
            if (contextName.equals("/")) {
                contextName = "";
            }
            writer.print("<h3>");
            writer.print(StatusTransformer.filter(name));
            writer.print("</h3>");
            writer.print("</a>");
            writer.print("<p>");
            Object startTime = mBeanServer.getAttribute(objectName, "startTime");
            writer.print(" <strong>Start time:</strong> " + new Date((Long)startTime));
            writer.print(" <br><strong>Startup time:</strong> ");
            writer.print(StatusTransformer.formatTime(mBeanServer.getAttribute(objectName, "startupTime"), false));
            writer.print(" <br><strong>TLD scan time:</strong> ");
            writer.print(StatusTransformer.formatTime(mBeanServer.getAttribute(objectName, "tldScanTime"), false));
            if (managerON2 != null) {
                StatusTransformer.writeManager(writer, managerON2, mBeanServer, mode);
            }
            if (jspMonitorONs != null) {
                StatusTransformer.writeJspMonitor(writer, jspMonitorONs, mBeanServer, mode);
            }
            writer.print("</p>");
            String onStr = objectName.getDomain() + ":j2eeType=Servlet,WebModule=" + webModuleName + ",*";
            ObjectName servletObjectName = new ObjectName(onStr);
            Set<ObjectInstance> set = mBeanServer.queryMBeans(servletObjectName, null);
            for (ObjectInstance oi : set) {
                StatusTransformer.writeWrapper(writer, oi.getObjectName(), mBeanServer, mode);
            }
        } else if (mode == 1) {
            // empty if block
        }
    }

    public static void writeManager(PrintWriter writer, ObjectName objectName, MBeanServer mBeanServer, int mode) throws Exception {
        if (mode == 0) {
            writer.print(" <br><strong>Active sessions:</strong> ");
            writer.print(mBeanServer.getAttribute(objectName, "activeSessions"));
            writer.print(" <br><strong>Session count:</strong> ");
            writer.print(mBeanServer.getAttribute(objectName, "sessionCounter"));
            writer.print(" <br><strong>Max active sessions:</strong> ");
            writer.print(mBeanServer.getAttribute(objectName, "maxActive"));
            writer.print(" <br><strong>Rejected session creations:</strong> ");
            writer.print(mBeanServer.getAttribute(objectName, "rejectedSessions"));
            writer.print(" <br><strong>Expired sessions:</strong> ");
            writer.print(mBeanServer.getAttribute(objectName, "expiredSessions"));
            writer.print(" <br><strong>Longest session alive time:</strong> ");
            writer.print(StatusTransformer.formatSeconds(mBeanServer.getAttribute(objectName, "sessionMaxAliveTime")));
            writer.print(" <br><strong>Average session alive time:</strong> ");
            writer.print(StatusTransformer.formatSeconds(mBeanServer.getAttribute(objectName, "sessionAverageAliveTime")));
            writer.print(" <br><strong>Processing time:</strong> ");
            writer.print(StatusTransformer.formatTime(mBeanServer.getAttribute(objectName, "processingTime"), false));
        } else if (mode == 1) {
            // empty if block
        }
    }

    public static void writeJspMonitor(PrintWriter writer, Set jspMonitorONs, MBeanServer mBeanServer, int mode) throws Exception {
        int jspCount = 0;
        int jspReloadCount = 0;
        for (ObjectName jspMonitorON : jspMonitorONs) {
            Object obj = mBeanServer.getAttribute(jspMonitorON, "jspCount");
            jspCount += ((Integer)obj).intValue();
            obj = mBeanServer.getAttribute(jspMonitorON, "jspReloadCount");
            jspReloadCount += ((Integer)obj).intValue();
        }
        if (mode == 0) {
            writer.print(" <br><strong>JSPs loaded:</strong> ");
            writer.print(jspCount);
            writer.print(" <br><strong>JSPs reloaded:</strong> ");
            writer.print(jspReloadCount);
        } else if (mode == 1) {
            // empty if block
        }
    }

    public static void writeWrapper(PrintWriter writer, ObjectName objectName, MBeanServer mBeanServer, int mode) throws Exception {
        if (mode == 0) {
            String servletName = objectName.getKeyProperty("name");
            String[] mappings = (String[])mBeanServer.invoke(objectName, "findMappings", null, null);
            writer.print("<h2>");
            writer.print(StatusTransformer.filter(servletName));
            if (mappings != null && mappings.length > 0) {
                writer.print(" [ ");
                for (int i = 0; i < mappings.length; ++i) {
                    writer.print(StatusTransformer.filter(mappings[i]));
                    if (i >= mappings.length - 1) continue;
                    writer.print(" , ");
                }
                writer.print(" ] ");
            }
            writer.print("</h2>");
            writer.print("<p>");
            writer.print(" <strong>Processing time:</strong> ");
            writer.print(StatusTransformer.formatTime(mBeanServer.getAttribute(objectName, "processingTime"), true));
            writer.print(" <br><strong>Max time:</strong> ");
            writer.print(StatusTransformer.formatTime(mBeanServer.getAttribute(objectName, "maxTime"), false));
            writer.print(" <br><strong>Request count:</strong> ");
            writer.print(mBeanServer.getAttribute(objectName, "requestCount"));
            writer.print(" <br><strong>Error count:</strong> ");
            writer.print(mBeanServer.getAttribute(objectName, "errorCount"));
            writer.print(" <br><strong>Load time:</strong> ");
            writer.print(StatusTransformer.formatTime(mBeanServer.getAttribute(objectName, "loadTime"), false));
            writer.print(" <br><strong>Classloading time:</strong> ");
            writer.print(StatusTransformer.formatTime(mBeanServer.getAttribute(objectName, "classLoadTime"), false));
            writer.print("</p>");
        } else if (mode == 1) {
            // empty if block
        }
    }

    public static String filter(Object obj) {
        if (obj == null) {
            return "?";
        }
        String message = obj.toString();
        char[] content = new char[message.length()];
        message.getChars(0, message.length(), content, 0);
        StringBuffer result = new StringBuffer(content.length + 50);
        block6: for (int i = 0; i < content.length; ++i) {
            switch (content[i]) {
                case '<': {
                    result.append("&lt;");
                    continue block6;
                }
                case '>': {
                    result.append("&gt;");
                    continue block6;
                }
                case '&': {
                    result.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    result.append("&quot;");
                    continue block6;
                }
                default: {
                    result.append(content[i]);
                }
            }
        }
        return result.toString();
    }

    public static String formatSize(Object obj, boolean mb) {
        long bytes = -1L;
        if (obj instanceof Long) {
            bytes = (Long)obj;
        } else if (obj instanceof Integer) {
            bytes = ((Integer)obj).intValue();
        }
        if (mb) {
            long mbytes = bytes / 0x100000L;
            long rest = (bytes - mbytes * 0x100000L) * 100L / 0x100000L;
            return mbytes + "." + (rest < 10L ? "0" : "") + rest + " MB";
        }
        return bytes / 1024L + " KB";
    }

    public static String formatTime(Object obj, boolean seconds) {
        long time = -1L;
        if (obj instanceof Long) {
            time = (Long)obj;
        } else if (obj instanceof Integer) {
            time = ((Integer)obj).intValue();
        }
        if (seconds) {
            return (float)time / 1000.0f + " s";
        }
        return time + " ms";
    }

    public static String formatSeconds(Object obj) {
        long time = -1L;
        if (obj instanceof Long) {
            time = (Long)obj;
        } else if (obj instanceof Integer) {
            time = ((Integer)obj).intValue();
        }
        return time + " s";
    }
}

